/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.common;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.Output;
import com.huawei.nglct.common.functions.SubFunc;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TESplitPageBean {
    private static Logger log = TELogFactory.getNormalLogger();
    private static final String PAGE_NUM_PARAM = "pageNum";
    private static final String RESULT_NUM_PER_PAGE_PARAM = "resultNumPerPage";
    private static final String TOTAL_PAGE_NUM_PARAM = "totalPageNum";
    private static final String TOTAL_RESULT_NUM_PARAM = "totalResultNum";
    private static final String SORT_PARAM_PARAM = "sortParam";
    private static final String SORT_BY_PARAM = "sortby";
    private static final String SORT_BY_ASC = "asc";
    private static final String SORT_BY_DES = "des";

    public static Datainterface getSplitPageData(Datainterface allData, PageParams pageparams, SubFunc subfunc) {
        if (allData.getPageParams() != null && allData.getPageParams().getParamCount() > 0) {
            return allData;
        }
        Datainterface fillterData = new Datainterface();
        int pageNum = 0;
        int resultNumPerPage = 0;
        int totalPageNum = 0;
        int totalResultNum = 0;
        int startIndex = 0;
        int endIndex = 0;
        int size = pageparams.getParamCount();
        for (int i = 0; i < size; ++i) {
            if (pageparams.getParam(i).getName().equals(PAGE_NUM_PARAM)) {
                try {
                    pageNum = Integer.parseInt(pageparams.getParam(i).getValue());
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("The Page Number is Wrong!", (Throwable)e);
                    pageNum = 1;
                }
                continue;
            }
            if (!pageparams.getParam(i).getName().equals(RESULT_NUM_PER_PAGE_PARAM)) continue;
            try {
                resultNumPerPage = Integer.parseInt(pageparams.getParam(i).getValue());
                continue;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("The resultNumPerPage is Wrong!", (Throwable)e);
                resultNumPerPage = 0;
            }
        }
        RowParams errRow = null;
        ArrayList<RowParams> errRows = new ArrayList<RowParams>();
        if (allData.getBussinessParams() != null) {
            totalResultNum = allData.getBussinessParams().getRowParamsCount();
            if (totalResultNum > 0) {
                for (int i = totalResultNum - 1; i >= 0; --i) {
                    errRow = allData.getBussinessParams().getRowParams(i);
                    if (errRow.getRowErrorsCount() <= 0) continue;
                    errRows.add(errRow);
                    allData.getBussinessParams().removeRowParams(i);
                }
                totalResultNum = allData.getBussinessParams().getRowParamsCount();
            }
        } else {
            totalResultNum = 0;
        }
        if (resultNumPerPage <= 0) {
            totalPageNum = 1;
            resultNumPerPage = totalResultNum;
        } else if (totalResultNum == 0) {
            totalPageNum = 1;
        } else {
            totalPageNum = totalResultNum / resultNumPerPage;
            if (totalResultNum % resultNumPerPage > 0) {
                ++totalPageNum;
            }
        }
        if (totalPageNum == 0) {
            pageNum = 0;
        } else if (pageNum < 1 || pageNum > totalPageNum) {
            pageNum = 1;
        }
        try {
            startIndex = (pageNum - 1) * resultNumPerPage;
            endIndex = startIndex + resultNumPerPage > totalResultNum ? totalResultNum : startIndex + resultNumPerPage;
            fillterData.setBussinessParams(new BussinessParams());
            for (int i = startIndex; i < endIndex; ++i) {
                fillterData.getBussinessParams().addRowParams(allData.getBussinessParams().getRowParams(i));
            }
            fillterData.setErrorMessage(allData.getErrorMessage());
            fillterData.setPageParams(new PageParams());
            fillterData.getPageParams().addParam(new Param(PAGE_NUM_PARAM, String.valueOf(pageNum)));
            fillterData.getPageParams().addParam(new Param(RESULT_NUM_PER_PAGE_PARAM, String.valueOf(resultNumPerPage)));
            fillterData.getPageParams().addParam(new Param(TOTAL_PAGE_NUM_PARAM, String.valueOf(totalPageNum)));
            fillterData.getPageParams().addParam(new Param(TOTAL_RESULT_NUM_PARAM, String.valueOf(totalResultNum)));
            if (errRows.size() > 0) {
                fillterData.getBussinessParams().getRowParamList().addAll(errRows);
            }
        }
        catch (Exception e) {
            fillterData = allData;
            log.error("Split Page Failt\u00a3\u00a1", (Throwable)e);
            return fillterData;
        }
        return fillterData;
    }

    private static Param getParam(Param[] paramArr, String paramName) {
        for (int i = paramArr.length - 1; i >= 0; --i) {
            if (!paramArr[i].getName().trim().equals(paramName.trim())) continue;
            return paramArr[i];
        }
        return null;
    }

    public static void sortData(Datainterface allData, SubFunc subfunc, PageParams pageparams) {
        String sortby = SORT_BY_ASC;
        ArrayList<String> sortParamList = new ArrayList<String>();
        int size = pageparams.getParamCount();
        for (int i = 0; i < size; ++i) {
            if (pageparams.getParam(i).getName().equals(SORT_PARAM_PARAM)) {
                sortParamList.add(pageparams.getParam(i).getValue());
                continue;
            }
            if (!pageparams.getParam(i).getName().equals(SORT_BY_PARAM)) continue;
            sortby = pageparams.getParam(i).getValue();
        }
        if (null != sortby && !sortby.equals(SORT_BY_ASC) && !sortby.equals(SORT_BY_DES)) {
            sortby = SORT_BY_ASC;
        }
        TESplitPageBean.sortDatainterface(allData, subfunc, sortParamList, sortby);
    }

    public static void sortDatainterface(Datainterface allData, SubFunc subfunc, ArrayList sortParamList, String sortby) {
        RowParams[] rowparams = allData.getBussinessParams().getRowParams();
        if (null == sortParamList || sortParamList.size() == 0 || rowparams.length <= 1) {
            return;
        }
        try {
            allData.getBussinessParams().addRowParams(0, new RowParams());
            rowparams = allData.getBussinessParams().getRowParams();
            Output out = subfunc.getOutput();
            TESplitPageBean.quickSort(rowparams, out, sortParamList, sortby, 1, rowparams.length - 1);
            allData.getBussinessParams().setRowParams(rowparams);
            allData.getBussinessParams().removeRowParams(0);
        }
        catch (Exception e) {
            log.error("Sort Fail!", (Throwable)e);
            return;
        }
    }

    private static void quickSort(RowParams[] rowparams, Output output, ArrayList sortParamList, String sortby, int low, int high) {
        if (low < high) {
            int pivotloc = TESplitPageBean.partition(rowparams, output, sortParamList, sortby, low, high);
            TESplitPageBean.quickSort(rowparams, output, sortParamList, sortby, low, pivotloc - 1);
            TESplitPageBean.quickSort(rowparams, output, sortParamList, sortby, pivotloc + 1, high);
        }
    }

    private static int partition(RowParams[] rowparams, Output output, ArrayList sortParamList, String sortby, int low, int high) {
        int sortParamLen = sortParamList.size();
        if (sortParamLen == 1) {
            String sortParam = (String)sortParamList.get(0);
            String paramType = output.getParamType(sortParam);
            return TESplitPageBean.partitionByOneSortParam(rowparams, paramType, sortParam, sortby, low, high);
        }
        if (sortParamList.contains("funcBlock")) {
            return TESplitPageBean.partitionByMore(rowparams, sortParamList, sortby, low, high);
        }
        return TESplitPageBean.partitionByMoreSortParam(rowparams, sortParamList, sortby, low, high);
    }

    private static int partitionByOneSortParam(RowParams[] rowparams, String paramType, String sortParam, String sortby, int low, int high) {
        rowparams[0] = rowparams[low];
        Param param = null;
        Param tmpParam = null;
        param = TESplitPageBean.getParam(rowparams[0].getParam(), sortParam);
        if (null != param) {
            while (low < high) {
                while (low < high) {
                    tmpParam = TESplitPageBean.getParam(rowparams[high].getParam(), sortParam);
                    if (sortby.equals(SORT_BY_ASC)) {
                        if (null == tmpParam || tmpParam.compareTo(param, paramType) < 0) break;
                        --high;
                        continue;
                    }
                    if (null != tmpParam && tmpParam.compareTo(param, paramType) > 0) break;
                    --high;
                }
                rowparams[low] = rowparams[high];
                while (low < high) {
                    tmpParam = TESplitPageBean.getParam(rowparams[low].getParam(), sortParam);
                    if (sortby.equals(SORT_BY_ASC)) {
                        if (null != tmpParam && tmpParam.compareTo(param, paramType) > 0) break;
                        ++low;
                        continue;
                    }
                    if (null == tmpParam || tmpParam.compareTo(param, paramType) < 0) break;
                    ++low;
                }
                rowparams[high] = rowparams[low];
            }
        }
        rowparams[low] = rowparams[0];
        return low;
    }

    private static int partitionByMoreSortParam(RowParams[] rowparams, ArrayList sortParamList, String sortby, int low, int high) {
        int i;
        rowparams[0] = rowparams[low];
        int sortParamLen = sortParamList.size();
        Param param = null;
        StringBuffer paramValue = new StringBuffer();
        StringBuffer tmpParamValue = null;
        for (i = 0; i < sortParamLen; ++i) {
            if (!paramValue.toString().equals("")) {
                paramValue.append("_");
            }
            if (null == (param = TESplitPageBean.getParam(rowparams[0].getParam(), (String)sortParamList.get(i)))) continue;
            paramValue.append(param.getValue());
        }
        while (low < high) {
            while (low < high) {
                tmpParamValue = new StringBuffer();
                for (i = 0; i < sortParamLen; ++i) {
                    if (!tmpParamValue.toString().equals("")) {
                        tmpParamValue.append("_");
                    }
                    if (null == (param = TESplitPageBean.getParam(rowparams[high].getParam(), (String)sortParamList.get(i)))) continue;
                    tmpParamValue.append(param.getValue());
                }
                if (sortby.equals(SORT_BY_ASC)) {
                    if (tmpParamValue.toString().compareTo(paramValue.toString()) < 0) break;
                    --high;
                    continue;
                }
                if (tmpParamValue.toString().compareTo(paramValue.toString()) > 0) break;
                --high;
            }
            rowparams[low] = rowparams[high];
            while (low < high) {
                tmpParamValue = new StringBuffer();
                for (i = 0; i < sortParamLen; ++i) {
                    if (!tmpParamValue.toString().equals("")) {
                        tmpParamValue.append("_");
                    }
                    if (null == (param = TESplitPageBean.getParam(rowparams[low].getParam(), (String)sortParamList.get(i)))) continue;
                    tmpParamValue.append(param.getValue());
                }
                if (sortby.equals(SORT_BY_ASC)) {
                    if (tmpParamValue.toString().compareTo(paramValue.toString()) > 0) break;
                    ++low;
                    continue;
                }
                if (tmpParamValue.toString().compareTo(paramValue.toString()) < 0) break;
                ++low;
            }
            rowparams[high] = rowparams[low];
        }
        rowparams[low] = rowparams[0];
        return low;
    }

    public static int partitionByMore(RowParams[] rowparams, ArrayList sortParamList, String sortby, int low, int high) {
        rowparams[0] = (RowParams)rowparams[low].clone();
        RowParams pivotRParam = (RowParams)rowparams[low].clone();
        while (low < high) {
            if (sortby.equals(SORT_BY_ASC)) {
                while (low < high && rowparams[high].compareTo(pivotRParam, sortParamList) >= 0) {
                    --high;
                }
                rowparams[low] = rowparams[high];
                while (low < high && rowparams[low].compareTo(pivotRParam, sortParamList) <= 0) {
                    ++low;
                }
                rowparams[high] = rowparams[low];
                continue;
            }
            while (low < high && rowparams[high].compareTo(pivotRParam, sortParamList) <= 0) {
                --high;
            }
            rowparams[low] = rowparams[high];
            while (low < high && rowparams[low].compareTo(pivotRParam, sortParamList) >= 0) {
                ++low;
            }
            rowparams[high] = rowparams[low];
        }
        rowparams[low] = rowparams[0];
        return low;
    }
}

