/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.common;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.mibsdef.MibObjects;
import com.huawei.nglct.common.mibsdef.MibTable;
import com.huawei.nglct.common.snmpfunctions.SnmpFunctions;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;

public class TESnmpCreateObjectFactory {
    private static HashMap funcDesObjectMap = new HashMap();
    private static final String SNMP_FUNC_DES_FILE_NAME = "snmpfunctiondescrib.xml";
    private static String SNMP_FUNCTION_DESCRIPTION_FILE = "devsupport\\ne_1000\\5.1000.01.01\\" + TEPathManager.CONFIG_PROFILE_PATH + "snmpfunctiondescrib.xml";
    private static String MIB_DESCRIPTION_PATH = TEPathManager.CONFIG_PROFILE_PATH + "mibdif" + File.separator;
    private static Logger log = TELogFactory.getNormalLogger();
    private static HashMap neMibTableMap = new HashMap();

    private TESnmpCreateObjectFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SnmpFunctions parseFuncDesFile(String neIP) throws FileNotFoundException, ValidationException, MarshalException {
        String filePath = SNMP_FUNCTION_DESCRIPTION_FILE;
        BufferedReader reader = null;
        HashMap hashMap = funcDesObjectMap;
        synchronized (hashMap) {
            if (funcDesObjectMap.containsKey(filePath)) return (SnmpFunctions)funcDesObjectMap.get(filePath);
            SnmpFunctions functions = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(TEResourceManager.getPath() + filePath), "UTF-8"));
                functions = SnmpFunctions.unmarshal(reader);
                reader.close();
                if (TESysManagerBean.getInstance().isIntegratedStatus()) return functions;
                funcDesObjectMap.put(filePath, functions);
            }
            catch (UnsupportedEncodingException e) {
                log.error("UnSupport encoding error\u00a3\u00ba", (Throwable)e);
                SnmpFunctions snmpFunctions = null;
                return snmpFunctions;
            }
            catch (IOException ex) {
                log.error("Parse function description file fail!", (Throwable)ex);
                SnmpFunctions snmpFunctions = null;
                return snmpFunctions;
            }
            finally {
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (Exception e2) {
                        TELogFactory.getNormalLogger().error("TESnmpCreateObjectFactory.parseFuncDesFile() fail!", (Throwable)e2);
                    }
                }
            }
            return functions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap parseMibFile(String neIP) {
        String path = "devsupport\\ne_1000\\5.1000.01.01\\" + MIB_DESCRIPTION_PATH;
        String absolutePath = TEResourceManager.getPath() + path;
        log.info("mibdef description file path is\u00a3\u00ba" + absolutePath);
        HashMap mibNameMitMap = new HashMap();
        BufferedReader reader = null;
        HashMap hashMap = neMibTableMap;
        synchronized (hashMap) {
            if (!neMibTableMap.containsKey(path)) {
                MibObjects tempdefinitions = null;
                MibObjects definitions = new MibObjects();
                File mpath = new File(absolutePath);
                if (mpath.isDirectory()) {
                    File[] mibfiles = mpath.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith("xml");
                        }
                    });
                    File mibFile2 = null;
                    for (File mibFile2 : mibfiles) {
                        if (mibFile2.isDirectory()) continue;
                        try {
                            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mibFile2), "UTF-8"));
                            tempdefinitions = MibObjects.unmarshal(reader);
                        }
                        catch (Exception e) {
                            log.error("parse mibdesc file failed", (Throwable)e);
                        }
                        finally {
                            if (null != reader) {
                                try {
                                    reader.close();
                                }
                                catch (Exception e) {
                                    log.error("close reader failed!(parse mibdesc file)", (Throwable)e);
                                }
                            }
                        }
                        TESnmpCreateObjectFactory.joinDef(tempdefinitions, definitions);
                        TESnmpCreateObjectFactory.mapMibTables(tempdefinitions, mibNameMitMap);
                    }
                }
                if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
                    neMibTableMap.put(path, mibNameMitMap);
                }
            } else {
                mibNameMitMap = (HashMap)neMibTableMap.get(path);
            }
        }
        return mibNameMitMap;
    }

    private static void mapMibTables(MibObjects mibtables, HashMap mibNameMitMap) {
        Enumeration evnum = mibtables.enumerateMibTable();
        String moduleName = mibtables.getModuleName();
        MibTable mt = null;
        while (evnum.hasMoreElements()) {
            mt = (MibTable)evnum.nextElement();
            if (mibNameMitMap.put(moduleName + "_" + mt.getName(), mt) == null) continue;
            log.warn("found duplicate key,module name:" + moduleName + "mibtable name:" + mt.getName());
        }
    }

    private static void joinDef(MibObjects fromJoin, MibObjects toJoin) {
        if (fromJoin == null || toJoin == null) {
            return;
        }
        MibTable[] defTables = toJoin.getMibTable();
        MibTable[] tempDefTables = fromJoin.getMibTable();
        MibTable[] _def = new MibTable[defTables.length + tempDefTables.length];
        System.arraycopy(defTables, 0, _def, 0, defTables.length);
        System.arraycopy(tempDefTables, 0, _def, defTables.length, tempDefTables.length);
        toJoin.setMibTable(_def);
    }

    public static MibTable getMibTable(String neIP, String mibName) {
        HashMap neMibMap = TESnmpCreateObjectFactory.parseMibFile(neIP);
        if (neMibMap != null) {
            return (MibTable)neMibMap.get(mibName);
        }
        return null;
    }

    public static Datainterface parseInputData(String inputDataStr) throws MarshalException, ValidationException {
        return TECreateObjectFactory.parseInputData(inputDataStr);
    }

    public static Datainterface parseInputDataFromPath(String filePath) throws MarshalException, ValidationException {
        return TECreateObjectFactory.parseInputDataFromPath(filePath);
    }
}

