/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.common;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class TEParseXMLFile {
    private TEParseXMLFile() {
    }

    public static Document parseFile(File file) {
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builderFactory = DocumentBuilderFactory.newInstance();
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse file is error,file name is " + file.getAbsolutePath(), (Throwable)e);
            return null;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseFile(String filepath) {
        Document doc = null;
        InputStream in = null;
        try {
            in = TEResourceManager.getInputStream(filepath);
            doc = TEParseXMLFile.parseFile(in);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse file is error,file name is " + filepath, (Throwable)e);
            Document document = null;
            return document;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("in.close() fail!", (Throwable)e);
                }
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseFile(String bundleName, String filepath) throws Exception {
        Document doc = null;
        InputStream in = TEResourceManager.getInputStream(bundleName, filepath);
        if (in == null) {
            return doc;
        }
        try {
            doc = TEParseXMLFile.parseFile(in);
            in.close();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().info("", (Throwable)e);
            }
        }
        return doc;
    }

    public static Document parseFile(InputStream in) throws Exception {
        Document doc = null;
        if (null != in) {
            DocumentBuilderFactory builderFactory = null;
            DocumentBuilder builder = null;
            builderFactory = DocumentBuilderFactory.newInstance();
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(in);
        }
        return doc;
    }

    public static Document parseFile(Bundle bundle, String filePath) {
        Document doc = null;
        try {
            File file = TEResourceManager.getFileInBundle(bundle, filePath);
            doc = TEParseXMLFile.parseFile(file);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse file is error,file name is " + filePath, (Throwable)e);
            return null;
        }
        return doc;
    }

    public static ArrayList splitFromChar(String allValue, char splitChar) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (null == allValue) {
            return returnList;
        }
        StringBuffer strBuff = new StringBuffer();
        int len = allValue.length();
        for (int i = 0; i < len; ++i) {
            char tmpChar = allValue.charAt(i);
            if (tmpChar != splitChar && '[' != tmpChar && ']' != tmpChar) {
                strBuff.append(tmpChar);
                continue;
            }
            if (0 == strBuff.length()) continue;
            String t = strBuff.toString().trim();
            if (!returnList.contains(t)) {
                returnList.add(t);
            }
            strBuff.delete(0, strBuff.length());
        }
        if (0 != strBuff.length()) {
            String t = strBuff.toString().trim();
            if (!returnList.contains(t)) {
                returnList.add(t);
            }
            strBuff.delete(0, strBuff.length());
        }
        return returnList;
    }
}

