/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.common;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.OperObject;
import com.huawei.nglct.common.functions.Param;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEDataConverter {
    public static final int INVALID_SUBSOLTID = 255;
    public static final int ZERO_SUBSOLTID = 0;
    public static final String VERIFY_FAILED = "42293";

    public static ArrayList convertToOperation(SubFunc subfunc, Datainterface inputData, int neid) {
        return TEDataConverter.convertToOperation(subfunc, inputData, neid, null);
    }

    public static ArrayList convertToOperation(SubFunc subfunc, Datainterface inputData, int neid, ArrayList operationNameList) {
        int i;
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<Operation> operationList1 = new ArrayList<Operation>();
        Operation operation1 = null;
        Input input1 = null;
        RowParams rowparams = null;
        com.huawei.nglct.common.datainterface.Param rowparam = null;
        boolean modifyFlag = true;
        int defaultPartCount = 0;
        ArrayList qxList = new ArrayList();
        if (null != operationNameList) {
            qxList = operationNameList;
            if (null != subfunc) {
                int size = qxList.size();
                for (i = 0; i < size; ++i) {
                    operation1 = TECreateObjectFactory.getOperation(subfunc, neid, (String)qxList.get(i));
                    if (null == operation1) continue;
                    TEDataConverter.updateOutput(subfunc, operation1);
                }
            }
        } else {
            int len = subfunc.getQxMappingCount();
            for (i = 0; i < len; ++i) {
                qxList.add(subfunc.getQxMapping(i).getContent());
            }
        }
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = qxList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                operation1 = TECreateObjectFactory.getOperation(subfunc, neid, (String)qxList.get(i2));
                if (null == operation1) continue;
                input1 = operation1.getInput();
                int partlen = input1.getPartCount();
                modifyFlag = input1.getPartCount() == 0;
                defaultPartCount = 0;
                for (int part = 0; part < partlen; ++part) {
                    rowparam = rowparams.getParam(input1.getPart(part).getName());
                    if (null == rowparam) {
                        if (!input1.getPart(part).hasDefault()) {
                            modifyFlag = false;
                            break;
                        }
                        ++defaultPartCount;
                        continue;
                    }
                    if (null != rowparam.getValue()) {
                        String value = rowparam.getValue();
                        input1.getPart(part).setValue(value);
                    }
                    if (!rowparam.getModifyFlag()) continue;
                    modifyFlag = true;
                }
                if (!modifyFlag && defaultPartCount != partlen) continue;
                operationList1.add(operation1);
            }
        }
        return operationList1;
    }

    public static Operation getOperation(SubFunc subfunc, int neid, String cmdName) {
        Operation operation1 = null;
        operation1 = subfunc != null && !subfunc.getQxDescribList().isEmpty() ? TECreateObjectFactory.getOperation(neid, cmdName, subfunc.getQxDescribList()) : TECreateObjectFactory.getOperation(neid, cmdName);
        return operation1;
    }

    public static void updateOutput(SubFunc subfunc, Operation operation1) {
        Output[] output1 = operation1.getOutput();
        if (output1 != null) {
            for (int j = 0; j < output1.length; ++j) {
                Part[] part = output1[j].getPart();
                if (part == null) continue;
                for (int k = 0; k < part.length; ++k) {
                    String name = part[k].getName();
                    String type = part[k].getType();
                    Param param = new Param();
                    param.setName(name);
                    param.setType(type);
                    if (subfunc.getOutput().containsParam(param)) continue;
                    subfunc.getOutput().addParam(param);
                }
            }
        }
    }

    public static ArrayList convertToOperation(SubFunc subfunc, Datainterface inputData, String qxFilePath) {
        return TEDataConverter.convertToOperation(subfunc, inputData, qxFilePath, null);
    }

    public static ArrayList convertToOperation(SubFunc subfunc, Datainterface inputData, String qxFilePath, ArrayList operationNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation = null;
        Input input = null;
        RowParams rowparams = null;
        com.huawei.nglct.common.datainterface.Param rowparam = null;
        boolean modifyFlag = true;
        int defaultPartCount = 0;
        ArrayList<String> qxList = operationNameList;
        if (null == operationNameList) {
            qxList = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                qxList.add(subfunc.getQxMapping(i).getContent());
            }
        }
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = qxList.size();
            for (int i = 0; i < size; ++i) {
                operation = TECreateObjectFactory.getOperation(qxFilePath, (String)qxList.get(i));
                if (null == operation) continue;
                input = operation.getInput();
                int partlen = input.getPartCount();
                modifyFlag = input.getPartCount() == 0;
                defaultPartCount = 0;
                for (int part = 0; part < partlen; ++part) {
                    rowparam = rowparams.getParam(input.getPart(part).getName());
                    if (null == rowparam) {
                        if (!input.getPart(part).hasDefault()) {
                            modifyFlag = false;
                            break;
                        }
                        ++defaultPartCount;
                        continue;
                    }
                    if (null != rowparam.getValue()) {
                        input.getPart(part).setValue(rowparam.getValue());
                    }
                    if (!rowparam.getModifyFlag()) continue;
                    modifyFlag = true;
                }
                if (!modifyFlag && defaultPartCount != partlen) continue;
                operationList.add(operation);
            }
        }
        return operationList;
    }

    public static Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList operationList) {
        return TEDataConverter.convertToDatainterface(neid, subfunc, operationList, null);
    }

    public static Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList errorData = TEDataConverter.joinOperation(neid, subfunc, operationList, filterErrorCodeList);
        Operation operation = null;
        if (null == operationList || 0 == operationList.size()) {
            return null;
        }
        RowParams rowparams = null;
        Input input = null;
        Output output = null;
        boolean succ = false;
        boolean fault = false;
        boolean row_succ = false;
        boolean verify_succ = true;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int len = operationList.size();
        block0: for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            TEDataConverter.handleSpecialStr(operation);
            input = operation.getInput();
            if (operation.getOutputCount() == 0) {
                succ = true;
            }
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                rowparams = new RowParams();
                row_succ = TEDataConverter.handleRowError(output, filterErrorCodeList);
                if (row_succ) {
                    succ = true;
                    boolean flag = false;
                    int errorSize = output.getFaultCount();
                    for (int a = 0; a < errorSize; ++a) {
                        if (filterErrorCodeList.contains(Integer.valueOf(output.getFault(a).getCode()))) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue block0;
                    TEDataConverter.handleRowData(neid, subfunc, rowparams, input, output);
                    flag = false;
                } else if (1 == operation.getOutputCount()) {
                    boolean hasDefault = true;
                    int count = operation.getOutput(0).getPartCount();
                    for (int index = 0; index < count; ++index) {
                        if (operation.getOutput(0).getPart(index).hasDefault()) continue;
                        hasDefault = false;
                        break;
                    }
                    if (hasDefault) {
                        TEDataConverter.handleRowData(neid, subfunc, rowparams, input, output);
                    }
                }
                if (0 != rowparams.getParamCount()) {
                    outputData.getBussinessParams().addRowParams(rowparams);
                }
                row_succ = false;
            }
        }
        if (null != errorData && 0 != errorData.size()) {
            fault = true;
            rowparams = new RowParams();
            RowErrors rErrors = null;
            int size = errorData.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorData.get(i);
                rowparams.addRowErrors(rErrors);
                if (!rErrors.getErrorMessage().getErrorcode().equals(VERIFY_FAILED)) continue;
                verify_succ = false;
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 0));
        } else if (!succ && fault || !verify_succ) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 1));
        }
        return outputData;
    }

    public static boolean handleRowError(Output output, ArrayList filterErrorCodeList) {
        int faultCode = 0;
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        int faultlen = output.getFaultCount();
        for (int i = 0; i < faultlen; ++i) {
            faultCode = Integer.parseInt(output.getFault(i).getCode());
            if (0 != faultCode && !filterErrorCodeList.contains(new Integer(faultCode))) continue;
            return true;
        }
        return false;
    }

    public static void handleRowData(int neid, SubFunc subfunc, RowParams rowparams, Input input, Output output) {
        String tmpValue = "";
        String tmpName = "";
        TENE neObj = null;
        int curNEid = neid;
        com.huawei.nglct.common.datainterface.Param param = null;
        int len = subfunc.getOutput().getParamCount();
        for (int col = 0; col < len; ++col) {
            int tmpCol;
            param = new com.huawei.nglct.common.datainterface.Param(subfunc.getOutput().getParam(col).getName(), "");
            if ("neid".equalsIgnoreCase(param.getName())) {
                param.setValue(String.valueOf(neid));
            }
            for (tmpCol = input.getPartCount() - 1; tmpCol >= 0; --tmpCol) {
                tmpName = input.getPart(tmpCol).getName();
                if (!tmpName.equalsIgnoreCase(param.getName())) continue;
                tmpValue = input.getPart(tmpCol).getValue();
                if (null != tmpValue) {
                    param.setValue(tmpValue);
                }
                input.removePart(input.getPart(tmpCol));
                break;
            }
            for (tmpCol = output.getPartCount() - 1; tmpCol >= 0; --tmpCol) {
                tmpName = output.getPart(tmpCol).getName();
                if (!tmpName.equalsIgnoreCase(param.getName())) continue;
                tmpValue = output.getPart(tmpCol).getValue();
                if (null != tmpValue) {
                    param.setValue(tmpValue);
                }
                output.removePart(output.getPart(tmpCol));
                break;
            }
            rowparams.addParam(param);
        }
        if (null != output.getPart("neid")) {
            curNEid = Integer.parseInt(output.getPart("neid").getValue());
        } else if (null != input.getPart("neid")) {
            curNEid = Integer.parseInt(input.getPart("neid").getValue());
        }
        neObj = TENEListMgr.getInstance().getNE(curNEid);
        int slotid = 0;
        int subslotid = 0;
        int boardtype = 0;
        int subboardtype = 0;
        int port = 0;
        String boardName = "";
        if (null != rowparams.getParam("slotid")) {
            slotid = TEDataConverter.getParamIntValue(rowparams.getParam("slotid"));
            if (null != rowparams.getParam("boardtype") && !"".equals(rowparams.getParam("boardtype").getValue())) {
                try {
                    String boardTypeStr = rowparams.getParam("boardtype").getValue();
                    if (TEDataConverter.isNumber(boardTypeStr)) {
                        boardtype = Integer.parseInt(boardTypeStr);
                    }
                }
                catch (NumberFormatException e) {
                    boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    rowparams.getParam("boardtype").setValue(boardtype + "");
                }
            } else {
                boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                param = new com.huawei.nglct.common.datainterface.Param("boardtype", boardtype + "");
                rowparams.addParam(param);
            }
            if (-1 != boardtype) {
                boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
            }
            param = new com.huawei.nglct.common.datainterface.Param("boardname", boardName);
            rowparams.addParam(param);
            rowparams.addParam(new com.huawei.nglct.common.datainterface.Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot(curNEid, slotid))));
            if (!TEBoardUtil.getSubrackNameFromSlot(curNEid, slotid).equals("")) {
                rowparams.addParam(new com.huawei.nglct.common.datainterface.Param("subrackname", TEBoardUtil.getSubrackNameFromSlot(curNEid, slotid)));
            }
            rowparams.addParam(new com.huawei.nglct.common.datainterface.Param("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot(curNEid, slotid))));
        }
        if (null != rowparams.getParam("neid")) {
            String nename = neObj.getNEName();
            String subrackname = TEBoardUtil.getSubrackNameFromSlot(neid, slotid);
            if (slotid > 0 && !subrackname.equals("")) {
                nename = nename + "-" + subrackname;
            }
            param = new com.huawei.nglct.common.datainterface.Param("nename", nename);
            rowparams.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param("realnename", neObj.getNEName());
            rowparams.addParam(param);
        }
        if (null != rowparams.getParam("subslotid")) {
            subslotid = TEDataConverter.getParamIntValue(rowparams.getParam("subslotid"));
            if (null != rowparams.getParam("subboardtype")) {
                try {
                    String subboardtypeStr = rowparams.getParam("subboardtype").getValue();
                    if (TEDataConverter.isNumber(subboardtypeStr)) {
                        subboardtype = Integer.parseInt(subboardtypeStr);
                    }
                }
                catch (NumberFormatException e) {
                    subboardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, subboardtype);
                    rowparams.getParam("subboardtype").setValue(subboardtype + "");
                }
            } else {
                if (255 != subslotid && 0 != subslotid) {
                    try {
                        subboardtype = TEConfigurationDataMgr.getInstance().getSubboardType(neid, slotid, subslotid);
                    }
                    catch (Exception e) {
                        slotid = 255;
                        subslotid = 255;
                    }
                }
                param = new com.huawei.nglct.common.datainterface.Param("subboardtype", subboardtype + "");
                rowparams.addParam(param);
            }
            String subboardname = "";
            if (255 != subslotid && 0 != subslotid) {
                subboardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, subboardtype);
            }
            param = new com.huawei.nglct.common.datainterface.Param("subboardname", subboardname);
            rowparams.addParam(param);
        }
        TEDataConverter.handleSubCardParam(neid, slotid, rowparams);
        if (null != rowparams.getParam("port") && !rowparams.getParam("port").getValue().equals("")) {
            port = TEDataConverter.getParamIntValue(rowparams.getParam("port"));
            String portname = "";
            portname = 255 != subslotid && 0 != subslotid ? TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, subboardtype, port) : TEDataConverter.getPortName(neid, slotid, boardtype, port, subfunc.getPortType());
            param = new com.huawei.nglct.common.datainterface.Param("portname", portname);
            rowparams.addParam(param);
        }
    }

    private static int getParamIntValue(RowParams rowparams, String paramName) {
        int result = -1;
        if (null != rowparams.getParam(paramName)) {
            result = TEDataConverter.getParamIntValue(rowparams.getParam(paramName));
        }
        return result;
    }

    private static int getParamIntValue(com.huawei.nglct.common.datainterface.Param param) {
        int result = -1;
        try {
            String paramvalue = param.getValue();
            if (TEDataConverter.isNumber(paramvalue) && Long.parseLong(paramvalue) < Integer.MAX_VALUE) {
                result = Integer.parseInt(paramvalue);
            }
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("Format " + param.getName() + " Fail!", (Throwable)e);
            result = -1;
        }
        return result;
    }

    private static int getErrorParamIntValue(RowErrors errorRows, String paramName) {
        int result = -1;
        if (null != errorRows.getParam(paramName)) {
            try {
                String errParamValue = errorRows.getParam(paramName).getValue();
                if (TEDataConverter.isNumber(errParamValue)) {
                    result = Integer.parseInt(errParamValue);
                }
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format " + paramName + " Fail!", (Throwable)e);
                result = -1;
            }
        }
        return result;
    }

    private static int handleSubCardParam(int neid, int slotid, RowParams rowparams) {
        int subslotid = TEDataConverter.getParamIntValue(rowparams, "subcard");
        if (-1 != subslotid && 255 != subslotid && 0 != subslotid) {
            int subboardtype = TEDataConverter.getParamIntValue(rowparams, "subboardtype");
            if (-1 != subboardtype) {
                rowparams.getParam("subboardtype").setValue(String.valueOf(subboardtype));
            } else {
                try {
                    subboardtype = TEConfigurationDataMgr.getInstance().getSubboardType(neid, slotid, subslotid);
                }
                catch (Exception e) {
                    slotid = 255;
                    subslotid = 255;
                }
                com.huawei.nglct.common.datainterface.Param param = new com.huawei.nglct.common.datainterface.Param("subboardtype", String.valueOf(subboardtype));
                rowparams.addParam(param);
            }
            String subboardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, subboardtype);
            com.huawei.nglct.common.datainterface.Param param = new com.huawei.nglct.common.datainterface.Param("subboardname", subboardname);
            rowparams.addParam(param);
        }
        return subslotid;
    }

    private static int handleSubCardErrorParam(int neid, int slotid, RowErrors errorRow) {
        int subslotid = TEDataConverter.getErrorParamIntValue(errorRow, "subcard");
        if (-1 != subslotid && 255 != subslotid && 0 != subslotid) {
            int subboardtype = TEDataConverter.getErrorParamIntValue(errorRow, "subboardtype");
            if (-1 != subboardtype) {
                errorRow.getParam("subboardtype").setValue(String.valueOf(subboardtype));
            } else {
                try {
                    subboardtype = TEConfigurationDataMgr.getInstance().getSubboardType(neid, slotid, subslotid);
                }
                catch (Exception e) {
                    slotid = 255;
                    subslotid = 255;
                }
                com.huawei.nglct.common.datainterface.Param param = new com.huawei.nglct.common.datainterface.Param("subboardtype", String.valueOf(subboardtype));
                errorRow.addParam(param);
            }
            String subboardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, subboardtype);
            com.huawei.nglct.common.datainterface.Param param = new com.huawei.nglct.common.datainterface.Param("subcardname", subslotid + "-" + subboardname);
            errorRow.addParam(param);
        }
        return subslotid;
    }

    protected static boolean isNumber(String str) {
        if (null == str || str.isEmpty()) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getPortName(int neid, int slotid, int boardtype, int port, String portType) {
        String portName = "";
        if (portType != null && !portType.isEmpty()) {
            List<Integer> portTypes = TEDataConverter.getPortTypes(portType);
            int len = portTypes.size();
            for (int i = 0; i < len; ++i) {
                portName = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, port, portTypes.get(i));
                if (portName.equals("")) continue;
                portName = port + "(" + portName + ")";
                break;
            }
        }
        if (portName.equals("")) {
            portName = TEConfigurationDataMgr.getInstance().getPortNameForNARTN(neid, slotid, boardtype, port);
        }
        return portName;
    }

    private static List<Integer> getPortTypes(String portType) {
        ArrayList<Integer> portTypelist = new ArrayList<Integer>();
        if (portType.equals(String.valueOf(11))) {
            portTypelist.add(2817);
            portTypelist.add(1802);
        } else if (portType.equals(String.valueOf(4)) || portType.equals(String.valueOf(16))) {
            portTypelist.add(1799);
            portTypelist.add(1025);
            portTypelist.add(63213);
            portTypelist.add(1802);
        } else if (portType.equals(String.valueOf(1))) {
            portTypelist.add(256);
            portTypelist.add(259);
            portTypelist.add(1798);
            portTypelist.add(61001);
            portTypelist.add(61002);
            portTypelist.add(61003);
            portTypelist.add(61009);
        }
        return portTypelist;
    }

    public static ArrayList joinOperation(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        ArrayList operationObject = TEDataConverter.getOperationObject(subfunc);
        ArrayList operObjPart = null;
        ArrayList tmpoperObjPart = null;
        Operation descOperation = null;
        Operation operation = null;
        Operation tmpOperation = null;
        Output curOutput = null;
        Output tmpOutput = null;
        int len = 0;
        int faultCode = 0;
        if (null == operationList || 0 == operationList.size()) {
            return errorDataList;
        }
        len = operationList.size();
        if (null != operationObject && 0 != operationObject.size()) {
            for (int i = 0; i < len; ++i) {
                operation = (Operation)operationList.get(i);
                TEDataConverter.copyInDataToOutData(operation);
                int ouputlen = operation.getOutputCount();
                for (int outputIndex = 0; outputIndex < ouputlen; ++outputIndex) {
                    curOutput = operation.getOutput(outputIndex);
                    faultCode = Integer.parseInt(curOutput.getFault(0).getCode());
                    if (filterErrorCodeList.contains(new Integer(faultCode))) continue;
                    if (0 != faultCode && !filterErrorCodeList.contains(new Integer(faultCode))) {
                        errorDataList.add(TEDataConverter.handleErrorData(neid, subfunc, operation.getInput(), curOutput));
                    }
                    operObjPart = TEDataConverter.getOperObjData(operationObject, operation.getInput(), curOutput);
                    for (int j = i + 1; j < len; ++j) {
                        tmpOperation = (Operation)operationList.get(j);
                        TEDataConverter.copyInDataToOutData(tmpOperation);
                        for (int tmpOutputIndex = tmpOperation.getOutputCount() - 1; tmpOutputIndex >= 0; --tmpOutputIndex) {
                            tmpOutput = tmpOperation.getOutput(tmpOutputIndex);
                            tmpoperObjPart = TEDataConverter.getOperObjData(operationObject, tmpOperation.getInput(), tmpOutput);
                            if (!TEDataConverter.compareOperObj(operObjPart, tmpoperObjPart)) continue;
                            TEDataConverter.joinOperationPart(neid, subfunc, curOutput, tmpOutput, tmpOperation.getInput(), errorDataList, filterErrorCodeList);
                            tmpOperation.removeOutput(tmpOutput);
                        }
                        if (0 != tmpOperation.getOutputCount()) continue;
                        operationList.remove(tmpOperation);
                        --len;
                        --j;
                    }
                }
            }
        } else {
            descOperation = (Operation)operationList.get(0);
            for (int output = 0; output < descOperation.getOutputCount(); ++output) {
                Output desOutput = descOperation.getOutput(output);
                faultCode = Integer.parseInt(desOutput.getFault(0).getCode());
                if (0 == faultCode || filterErrorCodeList.contains(new Integer(faultCode))) continue;
                errorDataList.add(TEDataConverter.handleErrorData(neid, subfunc, descOperation.getInput(), desOutput));
            }
            for (int i = operationList.size() - 1; i > 0; --i) {
                tmpOperation = (Operation)operationList.get(i);
                TEDataConverter.joinOperationOutput(neid, subfunc, descOperation, tmpOperation, errorDataList, filterErrorCodeList);
                operationList.remove(tmpOperation);
            }
        }
        return errorDataList;
    }

    public static boolean compareOperObj(ArrayList operObj, ArrayList otherOperObj) {
        Part part = null;
        Part otherPart = null;
        boolean flag = true;
        if (null != operObj && null != otherOperObj) {
            int size = operObj.size();
            for (int i = 0; i < size; ++i) {
                part = (Part)operObj.get(i);
                int len = otherOperObj.size();
                for (int j = 0; j < len; ++j) {
                    otherPart = (Part)otherOperObj.get(j);
                    if (!part.getName().equalsIgnoreCase(otherPart.getName()) || part.getValue() == null || part.getValue().equals(otherPart.getValue())) continue;
                    return false;
                }
            }
        }
        return flag;
    }

    public static ArrayList getOperationObject(SubFunc subfunc) {
        ArrayList<String> list = new ArrayList<String>();
        OperObject operObj = subfunc.getOperObject();
        if (null == operObj) {
            return list;
        }
        for (int i = 0; i < operObj.getParamCount(); ++i) {
            list.add(operObj.getParam(i).getName().toLowerCase());
        }
        return list;
    }

    public static ArrayList getOperObjData(ArrayList operationObject, Input input, Output output) {
        int i;
        ArrayList<Part> operObjDataArr = new ArrayList<Part>();
        Part curPart = null;
        Part containedPart = null;
        boolean flag = false;
        int size = input.getPartCount();
        for (i = 0; i < size; ++i) {
            if (!operationObject.contains(input.getPart(i).getName().toLowerCase())) continue;
            operObjDataArr.add(input.getPart(i));
        }
        size = output.getPartCount();
        for (i = 0; i < size; ++i) {
            if (!output.getFault(0).getCode().equals("0")) continue;
            curPart = output.getPart(i);
            if (!operationObject.contains(output.getPart(i).getName().toLowerCase())) continue;
            flag = false;
            int len = operObjDataArr.size();
            for (int index = 0; index < len; ++index) {
                containedPart = (Part)operObjDataArr.get(index);
                if (!containedPart.getName().equalsIgnoreCase(curPart.getName()) || null == curPart.getValue()) continue;
                containedPart.setValue(curPart.getValue());
                flag = true;
                break;
            }
            if (flag) continue;
            operObjDataArr.add(curPart);
        }
        return operObjDataArr;
    }

    public static void joinOperationInput(Operation desOperation, Operation sourceOperation) {
        Input desInput = desOperation.getInput();
        Input sourceInput = sourceOperation.getInput();
        int srcinputCount = sourceInput.getPartCount();
        for (int tmpinput = 0; tmpinput < srcinputCount; ++tmpinput) {
            desInput.addPart(sourceInput.getPart(tmpinput));
        }
    }

    public static void joinOperationOutput(int neid, SubFunc subfunc, Operation desOpeation, Operation srcOperation, ArrayList errorDataList, ArrayList filterErrorCodeList) {
        Output desOutput = null;
        Output srcOutput = null;
        Output tmpOutput = null;
        int desOutputCount = desOpeation.getOutputCount();
        int srcOutputCount = srcOperation.getOutputCount();
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        for (int output = 0; output < desOutputCount; ++output) {
            desOutput = desOpeation.getOutput(output);
            tmpOutput = (Output)desOutput.clone();
            for (int tmpoutput = 0; tmpoutput < srcOutputCount; ++tmpoutput) {
                if (0 != tmpoutput) {
                    desOutput = (Output)tmpOutput.clone();
                }
                srcOutput = srcOperation.getOutput(tmpoutput);
                TEDataConverter.joinOperationPart(neid, subfunc, desOutput, srcOutput, srcOperation.getInput(), errorDataList, filterErrorCodeList);
                if (0 == tmpoutput) continue;
                desOpeation.addOutput(desOutput);
            }
        }
    }

    public static void joinOperationPart(int neid, SubFunc subfunc, Output desOutput, Output srcOutput, Input srcInput, ArrayList errorDataList, ArrayList filterErrorCodeList) {
        Part partObj = null;
        if (srcOutput.getFault(0) == null || srcOutput.getFault(0).getCode() == null) {
            return;
        }
        int faultCode = Integer.parseInt(srcOutput.getFault(0).getCode());
        if (filterErrorCodeList.contains(new Integer(faultCode))) {
            return;
        }
        int partLen = srcOutput.getPartCount();
        for (int part = 0; part < partLen; ++part) {
            partObj = desOutput.getPart(srcOutput.getPart(part).getName());
            if (null == desOutput.getPart(srcOutput.getPart(part).getName())) {
                desOutput.addPart(srcOutput.getPart(part));
                continue;
            }
            if (0 != faultCode) continue;
            partObj.setValue(srcOutput.getPart(part).getValue());
        }
        if (0 != faultCode && !filterErrorCodeList.contains(new Integer(faultCode))) {
            errorDataList.add(TEDataConverter.handleErrorData(neid, subfunc, srcInput, srcOutput));
        }
        desOutput.addFault(srcOutput.getFault(0));
    }

    public static RowErrors handleErrorData(int errorCode) {
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(String.valueOf(errorCode));
        if (!String.valueOf(errorCode).equals("")) {
            errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
        } else {
            errorMessage.setErrorinfo("");
        }
        rowError.setErrorMessage(errorMessage);
        return rowError;
    }

    public static RowErrors handleErrorData(int neid, SubFunc subfunc, Input input, Output output) {
        int i;
        String errorCode = "";
        ArrayList operObjct = TEDataConverter.getOperationObject(subfunc);
        errorCode = output.getFault(0).getCode();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        com.huawei.nglct.common.datainterface.Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        if (!errorCode.equals("")) {
            errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot(Integer.parseInt(errorCode)));
        } else {
            errorMessage.setErrorinfo("");
        }
        rowError.setErrorMessage(errorMessage);
        errorparam = new com.huawei.nglct.common.datainterface.Param("neid", String.valueOf(neid));
        rowError.addParam(errorparam);
        int len = input.getPartCount();
        for (i = 0; i < len; ++i) {
            errorparam = new com.huawei.nglct.common.datainterface.Param(input.getPart(i).getName(), input.getPart(i).getValue());
            rowError.addParam(errorparam);
            if (operObjct.contains(errorparam.getName())) continue;
            errorparam = new com.huawei.nglct.common.datainterface.Param("attrId", input.getPart(i).getName());
            rowError.addParam(errorparam);
        }
        len = output.getPartCount();
        for (i = 0; i < len; ++i) {
            errorparam = new com.huawei.nglct.common.datainterface.Param("attrId", output.getPart(i).getName());
            if (null != rowError.getParam(output.getPart(i).getName())) continue;
            rowError.addParam(errorparam);
        }
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        int slotid = 0;
        int subslotid = 0;
        int boardtype = 0;
        int subboardtype = 0;
        int port = 0;
        if (null != rowError.getParam("slotid")) {
            slotid = TEDataConverter.getParamIntValue(rowError.getParam("slotid"));
            rowError.getParam("slotid").setValue(slotid + "");
            if (null != rowError.getParam("boardtype")) {
                try {
                    boardtype = Integer.parseInt(rowError.getParam("boardtype").getValue());
                }
                catch (NumberFormatException e) {
                    boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    rowError.getParam("boardtype").setValue(boardtype + "");
                }
            } else {
                boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                errorparam = new com.huawei.nglct.common.datainterface.Param("boardtype", boardtype + "");
                rowError.addParam(errorparam);
            }
            errorparam = new com.huawei.nglct.common.datainterface.Param("boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype));
            rowError.addParam(errorparam);
            rowError.addParam(new com.huawei.nglct.common.datainterface.Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot(neid, slotid))));
            if (!TEBoardUtil.getSubrackNameFromSlot(neid, slotid).equals("")) {
                rowError.addParam(new com.huawei.nglct.common.datainterface.Param("subrackname", TEBoardUtil.getSubrackNameFromSlot(neid, slotid)));
            }
        }
        if (null != rowError.getParam("neid")) {
            String nename = neObj.getNEName();
            String subrackname = TEBoardUtil.getSubrackNameFromSlot(neid, slotid);
            if (slotid > 0 && !subrackname.equals("")) {
                nename = nename + "-" + subrackname;
            }
            errorparam = new com.huawei.nglct.common.datainterface.Param("nename", nename);
            rowError.addParam(errorparam);
        }
        if (null != rowError.getParam("subslotid")) {
            subslotid = TEDataConverter.getParamIntValue(rowError.getParam("subslotid"));
            int n = subslotid = subslotid == -1 ? 255 : subslotid;
            if (null != rowError.getParam("subboardtype")) {
                try {
                    subboardtype = Integer.parseInt(rowError.getParam("subboardtype").getValue());
                }
                catch (NumberFormatException e) {
                    subboardtype = TEConfigurationDataMgr.getInstance().getSubboardType(neid, slotid, subslotid);
                    rowError.getParam("boardtype").setValue(boardtype + "");
                }
            } else {
                if (255 != subslotid && 0 != subslotid) {
                    subboardtype = TEConfigurationDataMgr.getInstance().getSubboardType(neid, slotid, subslotid);
                }
                errorparam = new com.huawei.nglct.common.datainterface.Param("subboardtype", subboardtype + "");
                rowError.addParam(errorparam);
            }
            String subboardname = "";
            if (255 != subslotid && 0 != subslotid) {
                subboardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, subboardtype);
            }
            errorparam = new com.huawei.nglct.common.datainterface.Param("subboardname", subboardname);
            rowError.addParam(errorparam);
        }
        TEDataConverter.handleSubCardErrorParam(neid, slotid, rowError);
        if (null != rowError.getParam("port") || null != rowError.getParam("portid")) {
            port = null != rowError.getParam("port") ? TEDataConverter.getParamIntValue(rowError.getParam("port")) : TEDataConverter.getParamIntValue(rowError.getParam("portid"));
            String portname = "";
            portname = 255 != subslotid && 0 != subslotid ? TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, subboardtype, port) : TEDataConverter.getPortName(neid, slotid, boardtype, port, subfunc.getPortType());
            errorparam = new com.huawei.nglct.common.datainterface.Param("portname", portname);
            rowError.addParam(errorparam);
            if (slotid != 0) {
                errorparam = new com.huawei.nglct.common.datainterface.Param("fullportname", TEConfigurationDataMgr.getInstance().getPTNPortName(neid, slotid, subslotid, port));
                rowError.addParam(errorparam);
            }
        }
        return rowError;
    }

    public static void handleSpecialStr(Operation operation) {
        if (null == operation) {
            return;
        }
        Output output = null;
        String type = "";
        String value = "";
        int len = operation.getOutputCount();
        for (int i = 0; i < len; ++i) {
            output = operation.getOutput(i);
            int partsize = output.getPartCount();
            for (int index = 0; index < partsize; ++index) {
                type = output.getPart(index).getType();
                value = output.getPart(index).getValue();
                if (null == type || null != value && !type.equalsIgnoreCase("string")) continue;
                value = type.equalsIgnoreCase("string") ? IOStreamConvertor.replaceSpecialStr(value) : (type.equalsIgnoreCase("prototype") ? "" : "-1");
                output.getPart(index).setValue(value);
            }
        }
    }

    public static void copyInDataToOutData(Operation operation) {
        Input input = operation.getInput();
        Output output = null;
        int size = operation.getOutputCount();
        for (int i = 0; i < size; ++i) {
            output = operation.getOutput(i);
            int len = output.getPartCount();
            for (int j = 0; j < len; ++j) {
                if (output.getPart(j).getValue() != null || null == input.getPart(output.getPart(j).getName())) continue;
                output.getPart(j).setValue(input.getPart(output.getPart(j).getName()).getValue());
            }
        }
    }

    public static void addTRANSBeginOper(int neid, SubFunc subFunc, Datainterface inputData, ArrayList operationList) {
        ArrayList<String> operNameList = new ArrayList<String>();
        operNameList.add("QX5_TRANS_BEGIN");
        ArrayList transOper = TEDataConverter.convertToOperation(subFunc, inputData, neid, operNameList);
        operationList.addAll(transOper);
    }

    public static void addSingleTRANSBeginOper(int neid, SubFunc subFunc, Datainterface inputData, ArrayList operationList) {
        ArrayList<String> operNameList = new ArrayList<String>();
        operNameList.add("QX5_TRANS_BEGIN");
        Operation transOper = TECreateObjectFactory.getOperation(neid, "QX5_TRANS_BEGIN");
        operationList.add(transOper);
    }

    public static void addTRANSCommitOper(int neid, SubFunc subFunc, Datainterface inputData, ArrayList operationList) {
        ArrayList<String> operNameList = new ArrayList<String>();
        operNameList.add("QX5_TRANS_COMMIT");
        ArrayList transOper = TEDataConverter.convertToOperation(subFunc, inputData, neid, operNameList);
        operationList.addAll(transOper);
    }

    public static void addSingleTRANSCommitOper(int neid, SubFunc subFunc, Datainterface inputData, ArrayList operationList) {
        ArrayList<String> operNameList = new ArrayList<String>();
        operNameList.add("QX5_TRANS_COMMIT");
        Operation transOper = TECreateObjectFactory.getOperation(neid, "QX5_TRANS_COMMIT");
        operationList.add(transOper);
    }

    public static void addTRANSOper(int neid, SubFunc subFunc, Datainterface inputData, ArrayList operationList) {
        Operation transOperBegin = TECreateObjectFactory.getOperation(neid, "QX5_TRANS_BEGIN");
        operationList.add(0, transOperBegin);
        Operation transOperComit = TECreateObjectFactory.getOperation(neid, "QX5_TRANS_COMMIT");
        operationList.add(transOperComit);
    }
}

