/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.common;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.functions.Functions;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.po.embeddednemgrmo.TENEMOPO;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.buffer.TETimeBuffer;
import com.huawei.nglct.util.device.TEVersionRelationBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.PortType;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;

public class TECreateObjectFactory {
    private static final String FUNC_DES_FILE_NAME = "functiondescrib.xml";
    private static final String TL1FUNC_DES_FILE_NAME = "tl1functiondescrib.xml";
    private static final String QX_DES_FILE_NAME = "qxdescrib.xml";
    private static final String TL1_DES_FILE_NAME = "tl1describ.xml";
    private static TETimeBuffer<String, Functions> funcDesObjectMap = new TETimeBuffer(60);
    private static TETimeBuffer<String, Definitions> qxDesObjectMap = new TETimeBuffer(60);
    private static TETimeBuffer<String, TL1Definitions> tl1DesObjectMap = new TETimeBuffer(20);
    private static final String FUNCTION_DESCRIPTION_FILE = TEPathManager.CONFIG_PROFILE_PATH + "functiondescrib.xml";
    private static final String TL1FUNCTION_DESCRIPTION_FILE = TEPathManager.CONFIG_PROFILE_PATH + "tl1functiondescrib.xml";
    private static final String QX_DESCRIPTION_FILE = TEPathManager.CONFIG_PROFILE_PATH + "qxdescrib.xml";
    private static final String TL1_DESCRIPTION_FILE = TEPathManager.CONFIG_PROFILE_PATH + "tl1describ.xml";
    private static final String DESCRIPTION_FILE_PATH = "nemgr" + File.separator + "device" + File.separator;
    private static Logger log = TELogFactory.getNormalLogger();

    private TECreateObjectFactory() {
    }

    public static Functions parseFuncDesFile() throws FileNotFoundException, ValidationException, MarshalException {
        return TECreateObjectFactory.parseFuncDesFile(null, FUNCTION_DESCRIPTION_FILE);
    }

    public static Functions parseTL1FuncDesFile() throws FileNotFoundException, ValidationException, MarshalException {
        return TECreateObjectFactory.parseFuncDesFile(null, TL1FUNCTION_DESCRIPTION_FILE);
    }

    public static Functions parseFuncDesFile(int neid) throws FileNotFoundException, ValidationException, MarshalException {
        List<String[]> fileList = TEGetFilePath.getQXandFuncFilePath(neid, FUNCTION_DESCRIPTION_FILE);
        String bundlename = fileList.get(0)[0];
        String path = fileList.get(0)[1];
        Functions functions = TECreateObjectFactory.parseFuncDesFile(bundlename, path);
        Functions tmpFunc = null;
        int m = fileList.size();
        for (int i = 1; i < m; ++i) {
            bundlename = fileList.get(i)[0];
            path = fileList.get(i)[1];
            tmpFunc = TECreateObjectFactory.parseFuncDesFile(bundlename, path);
            int len = tmpFunc.getFunctionCount();
            for (int j = 0; j < len; ++j) {
                functions.addFunction(tmpFunc.getFunction(j));
            }
        }
        return functions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Functions parseFuncDesFile(String bundlename, String filePath) throws FileNotFoundException, ValidationException, MarshalException {
        BufferedReader reader = null;
        Functions functions = null;
        TETimeBuffer<String, Functions> tETimeBuffer = funcDesObjectMap;
        synchronized (tETimeBuffer) {
            if (!funcDesObjectMap.containsKey(filePath)) {
                try {
                    InputStream in = TECreateObjectFactory.getDesFile(bundlename, filePath);
                    reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    functions = Functions.unmarshal(reader);
                    reader.close();
                    funcDesObjectMap.put(filePath, functions);
                }
                catch (UnsupportedEncodingException e) {
                    log.error("UnSupport encoding error\u00a3\u00ba", (Throwable)e);
                    Functions functions2 = null;
                    return functions2;
                }
                catch (IOException ex) {
                    log.error("Parse function description file fail!", (Throwable)ex);
                    Functions functions3 = null;
                    return functions3;
                }
                finally {
                    if (null != reader) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            log.info("", (Throwable)e);
                        }
                    }
                }
                if (null == functions) return functions;
                return (Functions)functions.clone();
            }
            try {
                functions = funcDesObjectMap.get(filePath);
            }
            catch (Exception ex) {
                log.error("funcDesObjectMap get fail!", (Throwable)ex);
            }
            if (null == functions) return functions;
            return (Functions)functions.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFuncDesFile(String filePath) {
        TETimeBuffer<String, Functions> tETimeBuffer = funcDesObjectMap;
        synchronized (tETimeBuffer) {
            if (filePath.startsWith("\\")) {
                filePath = filePath.substring(1, filePath.length());
            }
            funcDesObjectMap.remove(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearQxDesFile(String filePath) {
        TETimeBuffer<String, Definitions> tETimeBuffer = qxDesObjectMap;
        synchronized (tETimeBuffer) {
            qxDesObjectMap.remove(filePath);
        }
    }

    private static InputStream getDesFile(String bundlename, String filePath) throws IOException {
        InputStream in = null;
        in = null == bundlename || "".equals(bundlename) ? TEResourceManager.getInputStream(filePath) : TEResourceManager.getInputStream(bundlename, filePath);
        return in;
    }

    public static SubFunc getSubFunc(int sfid) throws MarshalException, FileNotFoundException, ValidationException {
        Functions functions = TECreateObjectFactory.parseFuncDesFile(null, FUNCTION_DESCRIPTION_FILE);
        return functions.getSubFunc(sfid);
    }

    public static SubFunc getSubFunc(int sfid, String dev) throws MarshalException, FileNotFoundException, ValidationException {
        String path = TEPathManager.PACKAGE_PATH + TEPathManager.E2EIP_PROFILE_PATH + TEPathManager.CONFIG_PROFILE_PATH + FUNC_DES_FILE_NAME;
        Functions functions = TECreateObjectFactory.parseFuncDesFile("com.huawei.weblct.e2e_ip", path);
        return functions.getSubFunc(sfid);
    }

    public static SubFunc getSubFunc(int neid, int sfid) throws MarshalException, FileNotFoundException, ValidationException {
        SubFunc subFunc = null;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String hostVersion = ne.getHostVersion();
        subFunc = TECreateObjectFactory.getSubFunc(neType, hostVersion, sfid);
        return subFunc;
    }

    public static SubFunc getSubFunc(int neid, int neType, String hostVersion, int sfid) throws MarshalException, FileNotFoundException, ValidationException {
        SubFunc subFunc = null;
        subFunc = TECreateObjectFactory.getSubFunc(neType, hostVersion, sfid);
        return subFunc;
    }

    public static SubFunc getSubFuncByVer(int neid, int sfid, int devType, String neVersion) throws MarshalException, FileNotFoundException, ValidationException {
        SubFunc subFunc = null;
        String neVersionStr = TECreateObjectFactory.convertNeVersion(neVersion);
        int neType = TEGetNEDomainVersion.getInstance().getNeType(devType);
        subFunc = TECreateObjectFactory.getSubFunc(neType, neVersionStr, sfid);
        return subFunc;
    }

    public static TL1Definitions parseTL1DesFile() throws FileNotFoundException, ValidationException, MarshalException {
        return TECreateObjectFactory.parseTL1DesFile(null, TL1_DESCRIPTION_FILE);
    }

    public static TL1Definitions parseTL1DesFile(int neid) throws FileNotFoundException, ValidationException, MarshalException {
        int neType = 0;
        String hostVersion = "";
        try {
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neid);
            neType = ne.getNEType();
            hostVersion = ne.getHostVersion();
        }
        catch (Exception e) {
            log.error("Get devPkgVersion Fail!", (Throwable)e);
            return null;
        }
        String path = TEGetFilePath.getFilePath(neType, hostVersion, "conf/tl1describ.xml");
        String bundlename = TEGetFilePath.getNEBundleName(neType);
        log.info("Qx interface description file path is\u00a3\u00ba" + path);
        return TECreateObjectFactory.parseTL1DesFile(bundlename, path);
    }

    /*
     * Exception decompiling
     */
    public static TL1Definitions parseTL1DesFile(String bundlename, String filePath) throws FileNotFoundException, ValidationException, MarshalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datainterface parseInputData(String inputDataStr) throws MarshalException, ValidationException {
        Datainterface inputdata = null;
        StringReader reader = null;
        try {
            if (inputDataStr != null) {
                reader = new StringReader(inputDataStr);
                inputdata = Datainterface.unmarshal(reader);
                ((Reader)reader).close();
            }
        }
        catch (IOException ex) {
            log.error("Close Reader Fail!", (Throwable)ex);
        }
        finally {
            if (null != reader) {
                try {
                    ((Reader)reader).close();
                }
                catch (Exception e) {
                    log.info("", (Throwable)e);
                }
            }
        }
        return inputdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datainterface parseInputDataFromPath(String filePath) throws MarshalException, ValidationException {
        BufferedReader reader = null;
        Datainterface datainterface = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            log.info("The file path is :" + TEResourceManager.getPath() + File.separator + filePath);
            datainterface = Datainterface.unmarshal(reader);
            reader.close();
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnSupport encoding error\u00a3\u00ba", (Throwable)e);
            Datainterface datainterface2 = null;
            return datainterface2;
        }
        catch (IOException ex) {
            log.error("Parse qx description file fail!", (Throwable)ex);
            Datainterface datainterface3 = null;
            return datainterface3;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    log.info("", (Throwable)e);
                }
            }
        }
        return datainterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList parseOperationTestFile(String filePath) throws FileNotFoundException, ValidationException, MarshalException {
        BufferedReader reader = null;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        PortType portType = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            portType = PortType.unmarshal((Reader)reader);
            reader.close();
        }
        catch (UnsupportedEncodingException e) {
            log.info("", (Throwable)e);
            ArrayList arrayList = null;
            return arrayList;
        }
        catch (IOException ex) {
            log.error("TECreateObjectFactory.parseOperationTestFile() fail!", (Throwable)ex);
            ArrayList arrayList = null;
            return arrayList;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    log.info("", (Throwable)e);
                }
            }
        }
        int len = portType.getOperationCount();
        for (int i = 0; i < len; ++i) {
            operationList.add(portType.getOperation(i));
        }
        return operationList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datainterface parseInputDataTestFile(String filePath) throws FileNotFoundException, ValidationException, MarshalException {
        BufferedReader reader = null;
        Datainterface inputdata = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            inputdata = Datainterface.unmarshal(reader);
            reader.close();
        }
        catch (UnsupportedEncodingException e) {
            log.info("", (Throwable)e);
            Datainterface datainterface = null;
            return datainterface;
        }
        catch (IOException ex) {
            log.error("TECreateObjectFactory.parseInputDataTestFile() fail!", (Throwable)ex);
            Datainterface datainterface = null;
            return datainterface;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    log.info("", (Throwable)e);
                }
            }
        }
        return inputdata;
    }

    public static Operation getOperation(int cmdid) {
        Operation oper = null;
        try {
            Definitions def = TECreateObjectFactory.parseQxDesFile();
            oper = def.getOperation(cmdid);
        }
        catch (Exception e) {
            log.info("", (Throwable)e);
        }
        return oper;
    }

    public static Operation getOperation(String cmdName) {
        Operation oper = null;
        try {
            Definitions def = TECreateObjectFactory.parseQxDesFile();
            oper = def.getOperation(cmdName);
        }
        catch (Exception e) {
            log.info("", (Throwable)e);
        }
        return oper;
    }

    public static Operation getOperation(String bundlename, String filePath, String cmdName) {
        Operation oper = null;
        try {
            Definitions def = TECreateObjectFactory.parseQxDesFile(bundlename, filePath);
            oper = def.getOperation(cmdName);
        }
        catch (Exception e) {
            log.info("", (Throwable)e);
        }
        return oper;
    }

    public static Operation getOperation(String filePath, String cmdName) {
        Operation oper = null;
        try {
            Definitions def = TECreateObjectFactory.parseQxDesFile(null, filePath);
            oper = def.getOperation(cmdName);
        }
        catch (Exception e) {
            log.info("", (Throwable)e);
        }
        return oper;
    }

    public static Operation getOperation(String filePath, int cmdid) {
        Operation oper = null;
        try {
            Definitions def = TECreateObjectFactory.parseQxDesFile(null, filePath);
            oper = def.getOperation(cmdid);
        }
        catch (Exception e) {
            log.info("", (Throwable)e);
        }
        return oper;
    }

    public static Operation getOperation(int neid, int cmdid) {
        Operation oper = null;
        int neType = 0;
        String hostVersion = "";
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            neType = ne.getNEType();
            hostVersion = ne.getHostVersion();
        }
        catch (Exception e) {
            log.error("Get devPkgVersion Fail!", (Throwable)e);
            return null;
        }
        oper = TECreateObjectFactory.getOperation(neType, hostVersion, "", cmdid);
        return oper;
    }

    public static Operation getOperation(int neid, String cmdName) {
        Operation oper = null;
        int neType = 0;
        String hostVersion = "";
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            neType = ne.getNEType();
            hostVersion = ne.getHostVersion();
        }
        catch (Exception e) {
            log.error("Get devPkgVersion Fail!", (Throwable)e);
            return null;
        }
        oper = TECreateObjectFactory.getOperation(neType, hostVersion, cmdName, 0);
        return oper;
    }

    public static Operation getOperation(int neid, String cmdName, List qxdescribList) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String bundlename = TEGetNEDomainVersion.getInstance().getBundleName(neType);
        String qxdescribfile = null;
        Operation oper = null;
        if (qxdescribList.isEmpty()) {
            oper = TECreateObjectFactory.getOperation(neid, cmdName);
        } else {
            for (int i = qxdescribList.size() - 1; i >= 0 && null == (oper = TECreateObjectFactory.getOperationFromFile(bundlename, qxdescribfile = (String)qxdescribList.get(i), cmdName, 0)); --i) {
            }
        }
        return oper;
    }

    public static Operation getOperation(SubFunc subfunc, int neid, String cmdName) {
        Operation operation1 = null;
        operation1 = subfunc != null && !subfunc.getQxDescribList().isEmpty() ? TECreateObjectFactory.getOperation(neid, cmdName, subfunc.getQxDescribList()) : TECreateObjectFactory.getOperation(neid, cmdName);
        return operation1;
    }

    public static Operation getOperation_NoLock(int neid, String cmdName) {
        Operation oper = null;
        int neType = 0;
        String hostVersion = "";
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            neType = ne.getNEType();
            hostVersion = TECreateObjectFactory.getHostVersion(neid);
        }
        catch (Exception e) {
            log.error("Get devPkgVersion Fail!", (Throwable)e);
            return null;
        }
        oper = TECreateObjectFactory.getOperation(neType, hostVersion, cmdName, 0);
        return oper;
    }

    public static String getHostVersion(int neID) {
        TENEMOPO mopo = TECreateObjectFactory.getTENEPO(neID);
        int neVer = (int)mopo.getVersion();
        return TEConvertUtil.neVersionToString(neVer);
    }

    public static TENEMOPO getTENEPO(int neID) {
        TENEMOPO ne = null;
        TEDaoOperationResult drb = null;
        try {
            drb = TECommonDaoService.findNE_NonLock(new int[]{neID});
            ne = (TENEMOPO)drb.getData().get(0);
            int result = drb.getResult();
            if (0 != result) {
                log.error("Get TENEMOPO fail! result is: " + result);
            }
            return ne;
        }
        catch (Exception e1) {
            log.error("Get TENEMOPO fail: " + e1.getMessage());
            return null;
        }
    }

    public static Operation getOperationWithVer(int neid, String cmdName, String hostVersion) {
        Operation oper = null;
        int neType = 0;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            neType = ne.getNEType();
        }
        catch (Exception e) {
            log.error("Get devPkgVersion Fail!", (Throwable)e);
            return null;
        }
        oper = TECreateObjectFactory.getOperation(neType, hostVersion, cmdName, 0);
        return oper;
    }

    private static Operation getOperation(int neType, String hostVersion, String cmdName, int cmdId) {
        String bundlename;
        String domain = TEGetNEDomainVersion.getInstance().getDomain(neType);
        Operation oper = TECreateObjectFactory.getOperationAdapter(neType, domain, bundlename = TEGetNEDomainVersion.getInstance().getBundleName(neType), hostVersion, cmdName, cmdId);
        if (oper == null) {
            String filePath = TECreateObjectFactory.getDevFilePath(domain, QX_DESCRIPTION_FILE);
            oper = TECreateObjectFactory.getOperationFromFile(bundlename, filePath, cmdName, cmdId);
        }
        return oper;
    }

    private static Operation getOperationAdapter(int neType, String domain, String bundlename, String hostVersion, String cmdName, int cmdId) {
        if (hostVersion == null || hostVersion.equals("")) {
            return null;
        }
        List<String> parentVers = TEVersionRelationBean.getInstance().getParentVersion(neType, hostVersion);
        Operation oper = null;
        String filePath = "";
        if (parentVers == null || parentVers.isEmpty()) {
            filePath = TECreateObjectFactory.getDevNeFilePath(neType, domain, hostVersion, QX_DESCRIPTION_FILE);
            oper = TECreateObjectFactory.getOperationFromFile(bundlename, filePath, cmdName, cmdId);
        } else {
            int len = parentVers.size();
            for (int i = 0; i < len && (oper = TECreateObjectFactory.getOperationFromFile(bundlename, filePath = TECreateObjectFactory.getDevDomainFilePath(domain, parentVers.get(i), QX_DESCRIPTION_FILE), cmdName, cmdId)) == null; ++i) {
            }
        }
        if (oper == null) {
            String version = TEVersionRelationBean.getInstance().gerParentVersion(neType, hostVersion);
            if (version == null) {
                log.info("get gerParentVersion " + hostVersion + " failed!");
                return null;
            }
            if (!version.equals(hostVersion)) {
                oper = TECreateObjectFactory.getOperationAdapter(neType, domain, bundlename, version, cmdName, cmdId);
            }
        }
        return oper;
    }

    private static SubFunc getSubFunc(int neType, String hostVersion, int sfid) {
        String bundlename;
        String domain = TEGetNEDomainVersion.getInstance().getDomain(neType);
        SubFunc subfunc = TECreateObjectFactory.getSubFuncAdpater(neType, domain, bundlename = TEGetNEDomainVersion.getInstance().getBundleName(neType), hostVersion, sfid);
        if (subfunc == null) {
            String filePath = "";
            if (domain.equals("tl1ngwdm")) {
                filePath = TECreateObjectFactory.getDevFilePath(domain, FUNCTION_DESCRIPTION_FILE);
                File file = TEResourceManager.getFileByName(bundlename, filePath);
                if (!(null != file && file.exists() || null != (file = TEResourceManager.getFileByName(bundlename, filePath = "nemgr" + File.separator + "tl1ngwdm" + File.separator + FUNCTION_DESCRIPTION_FILE)) && file.exists())) {
                    filePath = "nemgr" + File.separator + "tl1necommon" + File.separator + FUNCTION_DESCRIPTION_FILE;
                }
            } else {
                filePath = TECreateObjectFactory.getDevFilePath(domain, FUNCTION_DESCRIPTION_FILE);
            }
            subfunc = TECreateObjectFactory.getSubFuncFromFile(bundlename, filePath, sfid);
        }
        return subfunc;
    }

    private static SubFunc getSubFuncAdpater(int neType, String domain, String bundlename, String hostVersion, int sfid) {
        String version;
        if (hostVersion == null || hostVersion.equals("")) {
            return null;
        }
        List<String> pVerList = TEVersionRelationBean.getInstance().getParentVersion(neType, hostVersion);
        SubFunc subfunc = null;
        String filePath = "";
        if (pVerList == null || pVerList.isEmpty()) {
            filePath = TECreateObjectFactory.getDevNeFilePath(neType, domain, hostVersion, FUNCTION_DESCRIPTION_FILE);
            subfunc = TECreateObjectFactory.getSubFuncFromFile(bundlename, filePath, sfid);
        } else {
            int len = pVerList.size();
            for (int i = 0; i < len && (subfunc = TECreateObjectFactory.getSubFuncFromFile(bundlename, filePath = TECreateObjectFactory.getDevDomainFilePath(domain, pVerList.get(i), FUNCTION_DESCRIPTION_FILE), sfid)) == null; ++i) {
            }
        }
        if (subfunc == null && !(version = TEVersionRelationBean.getInstance().gerParentVersion(neType, hostVersion)).equals(hostVersion)) {
            subfunc = TECreateObjectFactory.getSubFuncAdpater(neType, domain, bundlename, version, sfid);
        }
        return subfunc;
    }

    private static SubFunc getSubFuncFromFile(String bundlename, String fileName, int sfid) {
        File file = TEResourceManager.getFileByName(bundlename, fileName);
        SubFunc subFunc = null;
        if (null != file && file.exists()) {
            try {
                Functions functions = TECreateObjectFactory.parseFuncDesFile(bundlename, fileName);
                subFunc = functions.getSubFunc(sfid);
            }
            catch (Exception e) {
                log.info("parseFuncDesFile fail!", (Throwable)e);
            }
        }
        return subFunc;
    }

    private static Operation getOperationFromFile(String bundlename, String fileName, String cmdName, int cmdID) {
        File file = TEResourceManager.getFileByName(bundlename, fileName);
        Operation oper = null;
        if (null != file && file.exists()) {
            try {
                Definitions def = TECreateObjectFactory.parseQxDesFile(bundlename, fileName);
                oper = cmdName == null || cmdName.equals("") ? def.getOperation(cmdID) : def.getOperation(cmdName);
            }
            catch (Exception e) {
                log.info("parseQxDesFile fail!", (Throwable)e);
            }
        }
        return oper;
    }

    public static TL1Operation getTL1Operation(int neid, String cmdName) {
        TL1Operation oper = null;
        int neType = 0;
        String hostVersion = "";
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            neType = ne.getNEType();
            hostVersion = ne.getHostVersion();
        }
        catch (Exception e) {
            log.error("Get devPkgVersion Fail!", (Throwable)e);
            return null;
        }
        String path = TEGetFilePath.getFilePath(neType, hostVersion, TL1_DESCRIPTION_FILE);
        oper = TECreateObjectFactory.getTL1Operation(neid, path, cmdName);
        return oper;
    }

    public static TL1Operation getTL1Operation(int neid, String filePath, String cmdName) {
        if (null == filePath) {
            return null;
        }
        TL1Operation oper = null;
        int neType = TECreateObjectFactory.getNeType(neid);
        String bundlename = TEGetFilePath.getNEBundleName(neType);
        try {
            String path;
            String nowVersion;
            TL1Definitions def = TECreateObjectFactory.parseTL1DesFile(bundlename, filePath);
            if (null != def) {
                oper = def.getTL1Operation(cmdName);
            }
            if (null == oper && null != (nowVersion = TECreateObjectFactory.getNeVersion(neid, filePath)) && null != (path = TEGetFilePath.getInheritedFilePath(neType, nowVersion, TL1_DESCRIPTION_FILE)) && !filePath.equals(path)) {
                oper = TECreateObjectFactory.getTL1Operation(neid, path, cmdName);
            }
        }
        catch (Exception e) {
            log.info("", (Throwable)e);
        }
        return oper;
    }

    public static Operation[] getOperations(String filePath) {
        try {
            Definitions def = TECreateObjectFactory.parseQxDesFile(null, filePath);
            return def.getPortType(0).getOperation();
        }
        catch (Exception e) {
            log.info("", (Throwable)e);
            return new Operation[0];
        }
    }

    public static Definitions parseQxDesFile() throws FileNotFoundException, ValidationException, MarshalException {
        return TECreateObjectFactory.parseQxDesFile(null, QX_DESCRIPTION_FILE);
    }

    public static Definitions parseQxDesFile(int neid) throws FileNotFoundException, ValidationException, MarshalException {
        List<String[]> fileList = TEGetFilePath.getQXandFuncFilePath(neid, QX_DESCRIPTION_FILE);
        String bundlename = fileList.get(0)[0];
        String path = fileList.get(0)[1];
        Definitions definitions = TECreateObjectFactory.parseQxDesFile(bundlename, path);
        Definitions defin = null;
        int m = fileList.size();
        for (int i = 1; i < m; ++i) {
            bundlename = fileList.get(i)[0];
            path = fileList.get(i)[1];
            defin = TECreateObjectFactory.parseQxDesFile(bundlename, path);
            int len = defin.getPortType().length;
            for (int j = 0; j < len; ++j) {
                definitions.addPortType(defin.getPortType(j));
            }
        }
        return definitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Definitions parseQxDesFile(String bundlename, String filePath) throws FileNotFoundException, ValidationException, MarshalException {
        BufferedReader reader = null;
        Definitions definitions = null;
        TETimeBuffer<String, Definitions> tETimeBuffer = qxDesObjectMap;
        synchronized (tETimeBuffer) {
            if (!qxDesObjectMap.containsKey(filePath)) {
                try {
                    InputStream in = TECreateObjectFactory.getDesFile(bundlename, filePath);
                    reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    log.info("The file path is :" + TEResourceManager.getPath() + File.separator + filePath);
                    definitions = Definitions.unmarshal((Reader)reader);
                    reader.close();
                    qxDesObjectMap.put(filePath, definitions);
                }
                catch (UnsupportedEncodingException e) {
                    log.error("UnSupport encoding error\u00a3\u00ba", (Throwable)e);
                    Definitions definitions2 = null;
                    return definitions2;
                }
                catch (IOException ex) {
                    log.error("Parse qx description file fail!", (Throwable)ex);
                    Definitions definitions3 = null;
                    return definitions3;
                }
                finally {
                    if (null != reader) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            log.info("", (Throwable)e);
                        }
                    }
                }
                if (null == definitions) return definitions;
                return TECreateObjectFactory.getDefinitions(definitions);
            }
            try {
                definitions = qxDesObjectMap.get(filePath);
            }
            catch (Exception ex) {
                log.error("qxDesObjectMap get fail!", (Throwable)ex);
            }
            if (null == definitions) return definitions;
            return TECreateObjectFactory.getDefinitions(definitions);
        }
    }

    private static final Definitions getDefinitions(Definitions definitions) {
        Definitions tmp = new Definitions();
        PortType[] portType = definitions.getPortType();
        int len = portType.length;
        for (int i = 0; i < len; ++i) {
            tmp.addPortType(portType[i]);
        }
        return tmp;
    }

    private static String getNeVersion(int neid, String filePath) {
        String regEx = "5[.]\\d+[.]\\d+[.]\\d+";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(filePath);
        boolean hasVersion = matcher.find();
        if (hasVersion) {
            return matcher.group(0);
        }
        return null;
    }

    private static String convertNeVersion(String neVersion) {
        if (null == neVersion || "".equals(neVersion)) {
            return "";
        }
        String[] tmpArray = neVersion.split("\\.");
        StringBuffer neVersionStr = new StringBuffer();
        for (int i = 0; i < tmpArray.length; ++i) {
            String indexStr = tmpArray[i];
            int tmpValue = Integer.parseInt(indexStr);
            if (0 != i && tmpValue >= 0 && tmpValue <= 10) {
                indexStr = "0" + tmpValue;
            }
            neVersionStr.append(indexStr);
            if (i == tmpArray.length - 1) continue;
            neVersionStr.append('.');
        }
        return neVersionStr.toString();
    }

    private static int getNeType(int neid) {
        int neType = 0;
        if (neid >= 0) {
            neType = TENEListMgr.getInstance().getNE(neid).getNEType();
        }
        return neType;
    }

    private static String getDevNeFilePath(int neType, String domain, String version, String fileName) {
        String filePath = "";
        filePath = domain.equals("tl1ngwdm") ? "nemgr" + File.separator + domain + File.separator + "ne_" + neType + File.separator + version + File.separator + fileName : DESCRIPTION_FILE_PATH + domain + File.separator + "ne_" + neType + File.separator + version + File.separator + fileName;
        return filePath;
    }

    private static String getDevDomainFilePath(String domain, String version, String filename) {
        return DESCRIPTION_FILE_PATH + domain + File.separator + version + File.separator + filename;
    }

    private static String getDevFilePath(String domain, String filename) {
        return DESCRIPTION_FILE_PATH + domain + File.separator + filename;
    }
}

