/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.xmlinterpreter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.TEParserKey;
import com.huawei.nglct.cbb.xmlinterpreter.TEParserPara;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreter;
import com.huawei.nglct.util.xml.TEResourceManager;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLInterpreterImpl
implements XMLInterpreter {
    @Override
    public int interpretXMLTag(Node node) {
        if (!node.hasChildNodes()) {
            return 0;
        }
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if ("macro_desc".equals(nodeName)) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                String macroName = "";
                int iValue = 0;
                int n = namedNodeMap.getLength();
                for (int j = 0; j < n; ++j) {
                    Node attr = namedNodeMap.item(j);
                    macroName = attr.getNodeName();
                    iValue = Integer.parseInt(attr.getNodeValue().trim());
                    SDXMLInterpreterMgr.getInstance().addMacorValue(macroName, iValue);
                }
                continue;
            }
            if (!"include".equals(nodeName)) continue;
            Element element = (Element)node;
            String fileName = element.getAttribute("file");
            String bundleName = element.getAttribute("bundlename");
            fileName = TEResourceManager.getPath() + fileName;
            boolean isLoaded = SDXMLInterpreterMgr.getInstance().isLoaded(fileName);
            if (isLoaded) continue;
            TELogFactory.getNormalLogger().info("include bundlename is " + bundleName + ";include filename is " + fileName);
            int result = 0;
            result = null == bundleName || "".equals(bundleName) ? SDXMLInterpreterMgr.getInstance().parseXMLFile(fileName) : SDXMLInterpreterMgr.getInstance().parseXMLFile(bundleName, fileName);
            if (result != 0) continue;
            SDXMLInterpreterMgr.getInstance().addLoadedFile(fileName);
        }
        return 0;
    }

    @Override
    public boolean isSupportReload() {
        return false;
    }

    @Override
    public int appXMLParseFunc(TEParserKey funKey, Node tag, TEParserPara para) {
        return 0;
    }
}

