/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.xmlinterpreter;

import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.mo.TEMarcoTypeInfo;
import com.huawei.nglct.mo.TEPubStaticMarcoInfoMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEPubMarcoInterpreter
extends XMLInterpreterImpl {
    private SDXMLInterpreterMgr sMgr = SDXMLInterpreterMgr.getInstance();
    private TEPubStaticMarcoInfoMgr pMgr = TEPubStaticMarcoInfoMgr.getInstance();
    private String language = TESysManagerBean.getInstance().getlanguage();

    @Override
    public int interpretXMLTag(Node node) {
        if (!node.hasChildNodes()) {
            return 0;
        }
        String name = null;
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            node = nodeList.item(i);
            name = node.getNodeName();
            if ("domain_info".equals(name)) {
                this.pMgr.addLinkTypeInfoList(this.interpret(node, "domain_id"));
                continue;
            }
            if ("shelftype_info".equals(name)) {
                this.pMgr.addLinkTypeInfoList(this.interpret(node, "shelftypeid"));
                continue;
            }
            if ("gateWayType_info".equals(name)) {
                this.pMgr.addLinkTypeInfoList(this.interpret(node, "gatewayType"));
                continue;
            }
            if ("speedLevel_info".equals(name)) {
                this.pMgr.addLinkTypeInfoList(this.interpret(node, "speedlevelid"));
                continue;
            }
            if (!"linkType_info".equals(name)) continue;
            this.pMgr.addLinkTypeInfoList(this.interpret(node, "linkTypeid"));
        }
        return 0;
    }

    List<TEMarcoTypeInfo> interpret(Node node, String nodeName) {
        ArrayList<TEMarcoTypeInfo> tmpList = new ArrayList<TEMarcoTypeInfo>();
        if (!node.hasChildNodes()) {
            return tmpList;
        }
        String name = null;
        String value = null;
        Node attr = null;
        TEMarcoTypeInfo tmpMarcoInfo = null;
        NamedNodeMap namedNodeMap = null;
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            tmpMarcoInfo = new TEMarcoTypeInfo();
            node = nodeList.item(i);
            if ("desc".equals(node.getNodeName())) {
                namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength();
                for (int j = 0; j < n; ++j) {
                    attr = namedNodeMap.item(j);
                    name = attr.getNodeName();
                    value = attr.getNodeValue();
                    if (nodeName.equals(name)) {
                        tmpMarcoInfo.marcoID = this.sMgr.parseInt(value);
                        if (!"shelftypeid".equals(nodeName)) continue;
                        this.pMgr.addShelfMacro(value, tmpMarcoInfo.marcoID);
                        continue;
                    }
                    if (!this.language.equals(name)) continue;
                    tmpMarcoInfo.marcoName = value;
                }
            }
            tmpList.add(tmpMarcoInfo);
        }
        return tmpList;
    }
}

