/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.xmlinterpreter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreter;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDXMLInterpreterMgr {
    private Map<String, XMLInterpreter> m_InterPreterMap = new HashMap<String, XMLInterpreter>();
    private TIntIntHashMap m_MacroNameValueMap = new TIntIntHashMap();
    private List<String> m_LoadFileList = new ArrayList<String>();
    private List<String> m_MacroFileList = new ArrayList<String>();
    private TIntArrayList loadedFileList = new TIntArrayList();
    private Object m_Mutex = new Object();
    private static SDXMLInterpreterMgr m_instance = null;

    private SDXMLInterpreterMgr() {
    }

    public static synchronized SDXMLInterpreterMgr getInstance() {
        if (null == m_instance) {
            m_instance = new SDXMLInterpreterMgr();
        }
        return m_instance;
    }

    private int hashString(String str) {
        int h = str.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public void initial() {
        int m = this.m_MacroFileList.size();
        for (int i = 0; i < m; ++i) {
            this.parseXMLFile(this.m_MacroFileList.get(i));
        }
        int n = this.m_LoadFileList.size();
        for (int j = 0; j < n; ++j) {
            this.parseXMLFile(this.m_LoadFileList.get(j));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterpreter(String interpreterName, XMLInterpreter pInterpreter) {
        Object object = this.m_Mutex;
        synchronized (object) {
            if (!this.m_InterPreterMap.containsKey(interpreterName)) {
                this.m_InterPreterMap.put(interpreterName, pInterpreter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLInterpreter getInterpreter(String interpreterName) {
        Object object = this.m_Mutex;
        synchronized (object) {
            return this.m_InterPreterMap.get(interpreterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_Mutex;
        synchronized (object) {
            this.m_InterPreterMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacorValue(String macroName, int macroValue) {
        Object object = this.m_Mutex;
        synchronized (object) {
            int hash = this.hashString(macroName);
            this.m_MacroNameValueMap.put(hash, macroValue);
        }
    }

    public int parseInt(String value) {
        if (null == value || "".equals(value)) {
            return 0;
        }
        int retValue = 0;
        int hash = this.hashString(value);
        if (this.m_MacroNameValueMap.containsKey(hash)) {
            retValue = this.m_MacroNameValueMap.get(hash);
        } else {
            try {
                retValue = Integer.decode(value);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("The string of " + value + " is invalid.");
            }
        }
        return retValue;
    }

    public void parseIntList(String numStr, TIntArrayList result) {
        result.clear();
        String[] numString = this.splitIntString(numStr);
        this.parseIntList(numString, result);
    }

    public void parseIntList(String numStr, List<Integer> result) {
        result.clear();
        String[] numString = this.splitIntString(numStr);
        TIntArrayList list = new TIntArrayList();
        this.parseIntList(numString, list);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result.add(list.get(i));
        }
    }

    private void parseIntList(String[] numString, TIntArrayList list) {
        int size = numString.length;
        for (int i = 0; i < size; ++i) {
            String numberStr = numString[i].trim();
            int indexSplit = numberStr.indexOf("-");
            if (indexSplit > 0) {
                String[] numSplitStr = numberStr.split("-");
                int start = 0;
                int end = 0;
                start = Integer.decode(numSplitStr[0].trim());
                end = Integer.decode(numSplitStr[1].trim());
                for (int j = start; j <= end; ++j) {
                    list.add(j);
                }
                continue;
            }
            list.add(this.parseInt(numberStr));
        }
    }

    private String[] splitIntString(String numStr) {
        String[] strResult = new String[]{};
        if (null != numStr && !"".equalsIgnoreCase(numStr.trim())) {
            numStr = numStr.replace("[", "");
            numStr = numStr.replace("]", "");
            strResult = numStr.split(",");
        }
        return strResult;
    }

    public void parseNestingList(String numStr, List<TIntArrayList> nestList) {
        TIntArrayList iList = new TIntArrayList();
        nestList.clear();
        numStr = numStr.replace("{", "");
        numStr = numStr.replace("}", "");
        String[] numString = numStr.split(";");
        int m = numString.length;
        for (int i = 0; i < m; ++i) {
            this.parseIntList(numString[i], iList);
            nestList.add((TIntArrayList)iList.clone());
        }
    }

    public int parseNEVer(String value) {
        return TEConvertUtil.convertVerStrToInt(value);
    }

    public int parseNEVerList(String value, TIntArrayList verList) {
        verList.clear();
        ArrayList tmpList = new ArrayList();
        TENEListUtils.stringToStrList(value, tmpList);
        int m = tmpList.size();
        for (int i = 0; i < m; ++i) {
            verList.add(this.parseNEVer((String)tmpList.get(i)));
        }
        return 0;
    }

    public boolean parseXMLBuffer(byte[] xmlbuffer, int bufferlen) {
        XMLInterpreter pInterpreter;
        NodeList nodeList;
        Node node;
        String interperterName;
        if (null == xmlbuffer || 0 == bufferlen) {
            return false;
        }
        String fileName = new String(xmlbuffer);
        Document doc = TEParseXMLFile.parseFile(fileName);
        if (null != doc && !"".equals(interperterName = (node = (nodeList = doc.getElementsByTagName("root")).item(0)).getAttributes().getNamedItem("interpreter").getNodeValue()) && null != (pInterpreter = this.getInterpreter(interperterName))) {
            pInterpreter.interpretXMLTag(node);
            return true;
        }
        return false;
    }

    public boolean isLoaded(String fileName) {
        return this.loadedFileList.contains(TEStringUtils.hashString(fileName));
    }

    public void clearLoadedFileList() {
        this.loadedFileList.clear();
    }

    public void addLoadedFile(String fileName) {
        this.loadedFileList.add(TEStringUtils.hashString(fileName));
    }

    public int parseXMLFile(String fileName) {
        Document doc = TEParseXMLFile.parseFile(fileName);
        if (null == doc) {
            return 2;
        }
        this.parseXMLFile(doc);
        try {
            if (fileName.endsWith("macro_var_cptype.xml")) {
                TELogFactory.getNormalLogger().info("parse macro_var_cptype.xml");
                this.regCPType2MacroName(doc);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("parse failed:  ", (Throwable)e);
        }
        return 0;
    }

    private void regCPType2MacroName(Document doc) {
        NodeList nodes = doc.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node element = nodes.item(i);
            if (!"root".equals(element.getNodeName())) continue;
            NodeList subNodes = element.getChildNodes();
            if (subNodes == null || subNodes.getLength() == 0) {
                return;
            }
            for (int h = 0; h < subNodes.getLength(); ++h) {
                NamedNodeMap attrs;
                Node node = subNodes.item(h);
                if (!"macro_desc".equals(node.getNodeName()) || (attrs = node.getAttributes()) == null) continue;
                Node t = null;
                for (int j = 0; j < attrs.getLength(); ++j) {
                    t = attrs.item(j);
                    TECircuitPackDescription.getInstance().addCPType2MacroName(Integer.parseInt(t.getNodeValue().trim()), t.getNodeName().trim());
                }
            }
        }
    }

    public int parseXMLFile(String bundleName, String fileName) {
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile(bundleName, fileName);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("SDXMLInterpreterMgr.parseXMLFile() fail!", (Throwable)e);
        }
        if (null == doc) {
            return 2;
        }
        this.parseXMLFile(doc);
        return 0;
    }

    private void parseXMLFile(Document doc) {
        XMLInterpreter pInterpreter;
        NodeList nodeList;
        Node node;
        String interperterName;
        if (null != doc && !"".equals(interperterName = (node = (nodeList = doc.getElementsByTagName("root")).item(0)).getAttributes().getNamedItem("interpreter").getNodeValue()) && null != (pInterpreter = this.getInterpreter(interperterName))) {
            try {
                pInterpreter.interpretXMLTag(node);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().info(interperterName + " interpret failed:  ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMacroValueByName(String strName) {
        Object object = this.m_Mutex;
        synchronized (object) {
            int value = -1;
            int hash = this.hashString(strName);
            if (this.m_MacroNameValueMap.containsKey(hash)) {
                value = this.m_MacroNameValueMap.get(hash);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoadFile(String strFile) {
        Object object = this.m_Mutex;
        synchronized (object) {
            if (this.m_LoadFileList.contains(strFile)) {
                return;
            }
            this.m_LoadFileList.add(strFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacroFile(String strFile) {
        Object object = this.m_Mutex;
        synchronized (object) {
            if (this.m_MacroFileList.contains(strFile)) {
                return;
            }
            this.m_MacroFileList.add(strFile);
        }
    }
}

