/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.xmlinterpreter;

import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.nelist.model.TEPortAttrKey;
import com.huawei.nglct.nelist.model.TEWDMInterfaceGradeDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDWdmInterfaceGradeInterpreter
extends XMLInterpreterImpl {
    @Override
    public int interpretXMLTag(Node node) {
        if (TESysManagerBean.getInstance().getShowGrade() == 0 || !node.hasChildNodes()) {
            return 0;
        }
        String name = null;
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            node = nodeList.item(i);
            name = node.getNodeName();
            if (!"board".equals(name)) continue;
            this.interpretBoard(node);
        }
        return 0;
    }

    private void interpretBoard(Node node) {
        String name = null;
        String value = null;
        Node attr = null;
        String boardType = "-1";
        NamedNodeMap namedNodeMap = node.getAttributes();
        int m = namedNodeMap.getLength();
        for (int i = 0; i < m; ++i) {
            attr = namedNodeMap.item(i);
            name = attr.getNodeName();
            value = attr.getNodeValue();
            if (!"cp_type_id".equals(name)) continue;
            boardType = value;
        }
        NodeList subNodeList = node.getChildNodes();
        HashMap<TEPortAttrKey, ArrayList<String>> attrGradeMap = new HashMap<TEPortAttrKey, ArrayList<String>>();
        int num = subNodeList.getLength();
        for (int i = 0; i < num; ++i) {
            node = subNodeList.item(i);
            name = node.getNodeName();
            if (!"item".equals(name)) continue;
            this.interpretItem(node, attrGradeMap);
        }
        TEWDMInterfaceGradeDataMgr.addGradeHashMap(Integer.parseInt(boardType), attrGradeMap);
    }

    private void interpretItem(Node node, HashMap<TEPortAttrKey, ArrayList<String>> attrGradeMap) {
        String name = null;
        String value = null;
        Node attr = null;
        String port = "";
        TEPortAttrKey attrKey = null;
        ArrayList<String> port_list = null;
        ArrayList<String> attr_list = null;
        ArrayList<String> grade_list = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int m = namedNodeMap.getLength();
        for (int i = 0; i < m; ++i) {
            attr = namedNodeMap.item(i);
            name = attr.getNodeName();
            value = attr.getNodeValue();
            if ("portid_list".equals(name)) {
                port_list = SDWdmInterfaceGradeInterpreter.getIntArr(value);
            }
            if ("attr_id_list".equals(name)) {
                attr_list = SDWdmInterfaceGradeInterpreter.getIntArr(value);
            }
            if (!"grade_list".equals(name)) continue;
            grade_list = SDWdmInterfaceGradeInterpreter.getStringArr(value);
        }
        String attrStr = "";
        int total = port_list.size();
        for (int k = 0; k < total; ++k) {
            port = (String)port_list.get(k);
            int length = attr_list.size();
            for (int m2 = 0; m2 < length; ++m2) {
                attrStr = attr_list.get(m2);
                attrKey = new TEPortAttrKey(port, attrStr);
                attrGradeMap.put(attrKey, grade_list);
            }
        }
    }

    private static ArrayList<String> getIntArr(String attr_value) {
        ArrayList<String> attrList = new ArrayList<String>();
        if (null == attr_value || "".equals(attr_value.trim())) {
            return attrList;
        }
        String[] attrs = attr_value.split(",");
        String attr = null;
        int minV = -1;
        int maxV = -1;
        for (int i = attrs.length - 1; i >= 0; --i) {
            attr = attrs[i];
            if (attr.indexOf("-") > 0) {
                minV = Integer.parseInt(attr.split("-")[0]);
                maxV = Integer.parseInt(attr.split("-")[1]);
                for (int value = minV; value <= maxV; ++value) {
                    attrList.add("" + value);
                }
                continue;
            }
            if (attr.equals("")) continue;
            attrList.add("" + attr);
        }
        return attrList;
    }

    private static ArrayList<String> getStringArr(String attr_value) {
        ArrayList<String> attrList = new ArrayList<String>();
        if (null == attr_value || "".equals(attr_value.trim())) {
            return attrList;
        }
        String[] attrs = attr_value.split(",");
        String attr = null;
        for (int i = attrs.length - 1; i >= 0; --i) {
            attr = attrs[i];
            if (attr.equals("")) continue;
            attrList.add(attr);
        }
        return attrList;
    }
}

