/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.xmlinterpreter;

import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.circuitpack.TESDPortRecord;
import com.huawei.nglct.util.batch.TECollectionOperations;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDPortInterpreter
extends XMLInterpreterImpl {
    @Override
    public int interpretXMLTag(Node node) {
        if (!node.hasChildNodes()) {
            return 0;
        }
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if ("port_description".equals(nodeName)) {
                this.interpretPort(node);
                continue;
            }
            if (!"inner_port_description".equals(nodeName)) continue;
            this.interpretInnerPort(node);
        }
        return 0;
    }

    void interpretPort(Node node) {
        TIntArrayList iList = new TIntArrayList();
        TESDPortRecord record = new TESDPortRecord();
        Node attr = null;
        String name = "";
        String value = "";
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int m = namedNodeMap.getLength();
        for (int i = 0; i < m; ++i) {
            attr = namedNodeMap.item(i);
            name = attr.getNodeName();
            value = attr.getNodeValue();
            if ("port_type".equals(name)) {
                record.outPortType = record.portType = mgr.parseInt(value);
                continue;
            }
            if ("port_type_name".equals(name)) {
                record.portTypeName = value;
                continue;
            }
            if ("mo_class_name".equals(name)) {
                record.moClassName = value;
                continue;
            }
            if ("support_interface_level".equals(name)) {
                mgr.parseIntList(value, iList);
                TECollectionOperations.copyFromTIntArrayList(iList, record.levelList);
                continue;
            }
            if ("is_visible".equals(name)) {
                record.bVisible = Integer.valueOf(value) == 1;
                continue;
            }
            if ("name_updatable".equals(name)) {
                record.bNameUpdable = Integer.valueOf(value) == 1;
                continue;
            }
            if ("port_domain".equals(name)) {
                record.domainType = mgr.parseInt(value);
                continue;
            }
            if (!"static_contain_fblist".equals(name)) continue;
            mgr.parseIntList(value, iList);
            TECollectionOperations.copyFromTIntArrayList(iList, record.containFBList);
        }
        TEPortDescription.getInstance().addPortRecord(record);
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int j = 0; j < n; ++j) {
            node = nodeList.item(j);
            if (!"port_contain_mo".equals(node.getNodeName())) continue;
            this.interpretContainMO(record.portType, node);
        }
    }

    void interpretInnerPort(Node node) {
        TIntArrayList iList = new TIntArrayList();
        TESDPortRecord record = new TESDPortRecord();
        Node attr = null;
        String name = "";
        String value = "";
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int m = namedNodeMap.getLength();
        for (int i = 0; i < m; ++i) {
            attr = namedNodeMap.item(i);
            name = attr.getNodeName();
            value = attr.getNodeValue();
            if ("inner_port_type".equals(name)) {
                record.portType = mgr.parseInt(value);
                continue;
            }
            if ("outer_port_type".equals(name)) {
                record.outPortType = mgr.parseInt(value);
                continue;
            }
            if ("mo_class_name".equals(name)) {
                record.moClassName = value;
                continue;
            }
            if ("support_interface_level".equals(name)) {
                mgr.parseIntList(value, iList);
                TECollectionOperations.copyFromTIntArrayList(iList, record.levelList);
                continue;
            }
            if ("is_visible".equals(name)) {
                record.bVisible = Integer.valueOf(value) == 1;
                continue;
            }
            if ("port_domain".equals(name)) {
                record.domainType = mgr.parseInt(value);
                continue;
            }
            if (!"static_contain_fblist".equals(name)) continue;
            mgr.parseIntList(value, iList);
            TECollectionOperations.copyFromTIntArrayList(iList, record.containFBList);
        }
        TEPortDescription.getInstance().addPortRecord(record);
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int j = 0; j < n; ++j) {
            node = nodeList.item(j);
            if (!"port_contain_mo".equals(node.getNodeName())) continue;
            this.interpretContainMO(record.portType, node);
        }
    }

    void interpretContainMO(int portType, Node node) {
        int level = 0;
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        TEPortDescription pDesc = TEPortDescription.getInstance();
        Node attr = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int m = namedNodeMap.getLength();
        for (int i = 0; i < m; ++i) {
            attr = namedNodeMap.item(i);
            String name = attr.getNodeName();
            String value = attr.getNodeValue();
            if (!"interface_level".equals(name)) continue;
            level = mgr.parseInt(value);
        }
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int j = 0; j < n; ++j) {
            TIntArrayList iVec = new TIntArrayList();
            int fbType = 255;
            int usCount = 0;
            boolean isEnable = true;
            node = nodeList.item(j);
            if (!"item".equals(node.getNodeName())) continue;
            namedNodeMap = node.getAttributes();
            int mn = namedNodeMap.getLength();
            for (int k = 0; k < mn; ++k) {
                attr = namedNodeMap.item(k);
                String name = attr.getNodeName();
                String value = attr.getNodeValue();
                if ("fbtype".equals(name)) {
                    fbType = mgr.parseInt(value);
                    continue;
                }
                if ("count".equals(name)) {
                    usCount = Integer.valueOf(value);
                    continue;
                }
                if ("idlist".equals(name)) {
                    mgr.parseIntList(value, iVec);
                    continue;
                }
                if ("mo_name".equals(name)) {
                    fbType = fbDesc.getFBTypeClassName(value);
                    continue;
                }
                if (!"is_enable".equals(name)) continue;
                isEnable = !value.equals("0");
            }
            if (usCount != 0 && isEnable) {
                pDesc.addPortMOCount(portType, level, fbType, usCount);
                continue;
            }
            if (iVec.size() <= 0) continue;
            ArrayList usVec = new ArrayList();
            TECollectionOperations.copyFromTIntArrayList(iVec, usVec);
            pDesc.addPortMOIDs(portType, level, fbType, usVec);
        }
    }
}

