/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.xmlinterpreter;

import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.nelist.model.TENEModelDescription;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.TEPortTPDataRecord;
import com.huawei.nglct.nelist.model.TETPLayerData;
import com.huawei.nglct.util.device.port.TEPortUtil;
import gnu.trove.TIntArrayList;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDNECPModelInterpreter
extends XMLInterpreterImpl {
    @Override
    public int interpretXMLTag(Node node) {
        if (node.hasChildNodes()) {
            return 0;
        }
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            int neType = 2047;
            int shelfType = 255;
            int minVer = 0;
            int maxVer = 0;
            Node attr = null;
            String name = "";
            String value = "";
            node = nodeList.item(i);
            if (!"ne_description".equals(node.getNodeName())) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                attr = namedNodeMap.item(j);
                name = attr.getNodeName();
                value = attr.getNodeValue();
                if ("ne_type".equals(name)) {
                    neType = mgr.parseInt(value);
                    continue;
                }
                if ("shelf_type".equals(name)) {
                    shelfType = mgr.parseInt(value);
                    continue;
                }
                if ("ver_min".equals(name)) {
                    minVer = Integer.valueOf(value);
                    continue;
                }
                if (!"ver_max".equals(name)) continue;
                maxVer = Integer.valueOf(value);
            }
            if (!node.hasChildNodes()) continue;
            nodeList = node.getChildNodes();
            int mn = nodeList.getLength();
            for (int k = 0; k < mn; ++k) {
                attr = nodeList.item(k);
                if (!"circuitpack_tp_desc".equals(attr.getNodeName())) continue;
                this.interpretCPTag(neType, shelfType, minVer, maxVer, node);
            }
        }
        return 0;
    }

    void interpretCPTag(int neType, int shelfType, int minVer, int maxVer, Node node) {
        Node attr = null;
        String name = "";
        String value = "";
        TIntArrayList iVec = new TIntArrayList();
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int m = namedNodeMap.getLength();
        for (int i = 0; i < m; ++i) {
            attr = namedNodeMap.item(i);
            name = attr.getNodeName();
            value = attr.getNodeValue();
            if (!"cp_type".equals(name)) continue;
            mgr.parseIntList(value, iVec);
        }
        if (!node.hasChildNodes() || iVec.size() == 0) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int j = 0; j < n; ++j) {
            TIntArrayList iList = new TIntArrayList();
            int portType = 0;
            node = nodeList.item(j);
            namedNodeMap = node.getAttributes();
            int mn = namedNodeMap.getLength();
            for (int k = 0; k < mn; ++k) {
                attr = namedNodeMap.item(k);
                name = attr.getNodeName();
                value = attr.getNodeValue();
                if ("port_type".equals(name)) {
                    portType = mgr.parseInt(value);
                    continue;
                }
                if ("interface_level".equals(name)) {
                    mgr.parseInt(value);
                    continue;
                }
                if (!"port_no_list".equals(name)) continue;
                mgr.parseIntList(value, iList);
            }
            if (node.hasChildNodes()) continue;
            HashSet<TETPLayerData> tpSet = new HashSet<TETPLayerData>();
            TEPortTPDataRecord record = new TEPortTPDataRecord(shelfType, minVer, maxVer, portType);
            nodeList = node.getChildNodes();
            int t = nodeList.getLength();
            for (int s = 0; s < t; ++s) {
                tpSet.clear();
                attr = nodeList.item(s);
                if (this.isMatchTPTag(attr, 1)) {
                    this.interpretTP(tpSet, attr, 1);
                }
                if (tpSet.size() <= 0) continue;
                record.m_TPList.add(tpSet);
            }
            if (record.m_TPList.size() <= 0) continue;
            TEPortDescription pPortD = TEPortDescription.getInstance();
            int mm = iList.size();
            for (int ii = 0; ii < mm; ++ii) {
                record.m_PortIDSet.add(TEPortUtil.getPortID(pPortD.getPortDomain(portType), iList.get(ii)));
            }
            int nn = iVec.size();
            for (int jj = 0; jj < nn; ++jj) {
                TENEModelDescription.getInstance().addTPDataRecord(neType, iVec.get(jj), record);
            }
        }
    }

    boolean isMatchTPTag(Node node, int layer) {
        String item = "tp" + layer + "_item";
        return item.equals(node.getNodeName());
    }

    void interpretTP(Set<TETPLayerData> tpSet, Node node, int layer) {
        Node attr = null;
        String name = "";
        String value = "";
        TETPLayerData tpData = new TETPLayerData();
        TIntArrayList iVec = new TIntArrayList();
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int m = namedNodeMap.getLength();
        for (int i = 0; i < m; ++i) {
            attr = namedNodeMap.item(i);
            name = attr.getNodeName();
            value = attr.getNodeValue();
            if ("tp_type".equals(name)) {
                mgr.parseIntList(value, iVec);
                continue;
            }
            if ("tp_list".equals(name)) {
                mgr.parseIntList(value, tpData.m_FBIDList);
                continue;
            }
            if (!"build_flag".equals(name)) continue;
            tpData.m_IsBuild = mgr.parseInt(value) == 1;
        }
        tpData.m_iLayer = layer;
        int n = iVec.size();
        for (int j = 0; j < n; ++j) {
            tpData.m_FBType = iVec.get(j);
            tpSet.add((TETPLayerData)tpData.clone());
        }
        if (!node.hasChildNodes()) {
            return;
        }
        ++layer;
        NodeList nodeList = node.getChildNodes();
        int mn = nodeList.getLength();
        for (int k = 0; k < mn; ++k) {
            attr = nodeList.item(k);
            if (!this.isMatchTPTag(attr, layer)) continue;
            this.interpretTP(tpSet, attr, layer);
        }
    }
}

