/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.xmlinterpreter;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.bscfg.equipment.TEEquipmentRecord;
import com.huawei.nglct.bscfg.equipment.TEInstallCPDependcyRecord;
import com.huawei.nglct.bscfg.installcp.TECPOccupySlot;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.mo.VerRange;
import com.huawei.nglct.po.TESubrackTypes;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.convertor.TEVersionConvertUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDEquipmentInterpreter
extends XMLInterpreterImpl {
    @Override
    public int interpretXMLTag(Node node) {
        if (!node.hasChildNodes()) {
            return 0;
        }
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            node = nodeList.item(i);
            if (!"ne_description".equals(node.getNodeName())) continue;
            int neType = 0;
            TIntArrayList iList = new TIntArrayList();
            TEEquipmentRecord record = new TEEquipmentRecord();
            NamedNodeMap namedNodeMap = node.getAttributes();
            record.setM_DefaultShelf(3);
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                Node attr = namedNodeMap.item(j);
                String name = attr.getNodeName();
                String value = attr.getNodeValue();
                if ("ne_type".equals(name)) {
                    neType = SDXMLInterpreterMgr.getInstance().parseInt(value);
                    record.setM_NEType(neType);
                    record.setM_TypeDefineName(value);
                    boolean alreadyIntered = TEEquipmentDescription.getInstance().isDeviceConfIntered(neType);
                    if (!alreadyIntered) continue;
                    this.interpretPNPBDData(neType, node);
                    continue;
                }
                if ("ne_type_name".equals(name)) {
                    record.setM_TypeName(value);
                    continue;
                }
                if ("topo_ne_type_name".equals(name)) {
                    record.setM_topoTypeName(value);
                    continue;
                }
                if ("domain_list".equals(name)) {
                    SDXMLInterpreterMgr.getInstance().parseIntList(value, iList);
                    record.setM_DomainList(iList);
                    continue;
                }
                if ("equip_class".equals(name)) {
                    record.setM_EquClass(SDXMLInterpreterMgr.getInstance().parseInt(value));
                    continue;
                }
                if ("default_shelf".equals(name)) {
                    record.setM_DefaultShelf(SDXMLInterpreterMgr.getInstance().parseInt(value));
                    continue;
                }
                if ("default_scc".equals(name)) {
                    record.setM_DefaultSCC(SDXMLInterpreterMgr.getInstance().parseInt(value));
                    continue;
                }
                if ("default_scc_slot".equals(name)) {
                    record.setM_DefalutSCCSlot(SDXMLInterpreterMgr.getInstance().parseInt(value));
                    continue;
                }
                if ("default_ver".equals(name)) {
                    record.setM_DefaultVer(SDXMLInterpreterMgr.getInstance().parseNEVer(value));
                    continue;
                }
                if ("is_neid_modifiable".equals(name)) {
                    int modifiable = SDXMLInterpreterMgr.getInstance().parseInt(value);
                    record.setM_NEIDModifiable(modifiable == 1);
                    continue;
                }
                if ("is_used_by_one".equals(name)) {
                    int beUsedBYONE = SDXMLInterpreterMgr.getInstance().parseInt(value);
                    record.setM_BeUsedBYONE(beUsedBYONE == 1);
                    continue;
                }
                if ("is_support_slave_shelf".equals(name)) {
                    int isSlaveShelf = SDXMLInterpreterMgr.getInstance().parseInt(value);
                    record.setM_bSupportSlaveShelf(isSlaveShelf == 1);
                    continue;
                }
                if (!"slot_relation".equals(name)) continue;
                int slotRelation = SDXMLInterpreterMgr.getInstance().parseInt(value);
                record.setM_SlotRelation(slotRelation);
            }
            TEEquipmentDescription.getInstance().addNERecord(record);
            if (!node.hasChildNodes()) continue;
            NodeList childNodes = node.getChildNodes();
            int mm = childNodes.getLength();
            for (int k = 0; k < mm; ++k) {
                Node childNode = childNodes.item(k);
                String nodeName = childNode.getNodeName();
                if ("shelf".equals(nodeName)) {
                    this.interpretShelf(neType, childNode);
                    this.interpretSubrack(record, childNode);
                    continue;
                }
                if ("ne_nm_cp_type_map".equals(nodeName)) {
                    this.interpretCPTypeMap(neType, childNode);
                    continue;
                }
                if (!"ne_contain_mo".equals(nodeName) || TESysManagerBean.getInstance().isIntegratedStatus()) continue;
                this.interpretContainMO(neType, childNode);
            }
        }
        return 0;
    }

    protected void interpretSubrack(TEEquipmentRecord record, Node node) {
        if (node == null) {
            return;
        }
        Element elm = (Element)node;
        String shelfType = elm.getAttribute("shelf_type");
        if (shelfType != null && !shelfType.equals("") && record.isM_bSupportSlaveShelf()) {
            String tl1Name = elm.getAttribute("tl1name");
            if (tl1Name == null) {
                tl1Name = "";
            }
            String[] tl1Names = tl1Name.split(",");
            int len = tl1Names.length;
            for (int i = 0; i < len; ++i) {
                TESubrackTypes.getInstance().registerTypeMapping(record.getM_NEType(), SDXMLInterpreterMgr.getInstance().parseInt(shelfType), tl1Names[i]);
            }
        }
    }

    protected void interpretShelf(int neType, Node node) {
        int shelfType = 255;
        String neIcon = "";
        int iShelfCount = 1;
        int iSpan = 0;
        int beginShelf = 0;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int m = namedNodeMap.getLength();
        for (int i = 0; i < m; ++i) {
            Node attr = namedNodeMap.item(i);
            String name = attr.getNodeName();
            String value = attr.getNodeValue();
            if ("shelf_type".equals(name)) {
                shelfType = SDXMLInterpreterMgr.getInstance().parseInt(value);
                continue;
            }
            if ("shelf_count".equals(name)) {
                iShelfCount = SDXMLInterpreterMgr.getInstance().parseInt(value);
                continue;
            }
            if ("span_num".equals(name)) {
                iSpan = SDXMLInterpreterMgr.getInstance().parseInt(value);
                continue;
            }
            if (!"ne_icon".equals(name)) continue;
            neIcon = value;
        }
        if (0 != neIcon.length()) {
            TEEquipmentDescription.getInstance().addNEShelfIcon(neType, shelfType, neIcon);
        }
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int j = 0; j < n; ++j) {
            node = nodeList.item(j);
            String nodeName = node.getNodeName();
            if ("install_slot_list".equals(nodeName)) {
                if (TESysManagerBean.getInstance().isIntegratedStatus()) continue;
                this.interpretInstallSlotList(neType, shelfType, iShelfCount, iSpan, node, beginShelf);
                continue;
            }
            if ("install_circuitpack".equals(nodeName)) {
                this.interpretInstallCP(neType, shelfType, iShelfCount, iSpan, node, beginShelf);
                continue;
            }
            if (!"ne_nm_slot_map".equals(nodeName)) continue;
            this.interpretSlotMap(neType, shelfType, node);
        }
    }

    private void interpretInstallSlotList(int neType, int shelfType, int iShelfCount, int iSpan, Node node, int beginShelf) {
        TIntArrayList cpSlotList = new TIntArrayList();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int m = namedNodeMap.getLength();
        for (int i = 0; i < m; ++i) {
            node = namedNodeMap.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue().trim();
            if (!"slot_list".equals(name)) continue;
            TIntArrayList iList = new TIntArrayList();
            SDXMLInterpreterMgr.getInstance().parseIntList(value, iList);
            cpSlotList.add(iList.toNativeArray());
        }
        TEEquipmentDescription.getInstance().addInstallSlotList(neType, shelfType, cpSlotList);
    }

    private void interpretInstallCP(int neType, int shelfType, int iShelfCount, int iSpan, Node node, int beginShelf) {
        if (!node.hasChildNodes()) {
            return;
        }
        int cpType = 0;
        String language = TESysManagerBean.getInstance().getlanguage();
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            TECPOccupySlot record;
            node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if ("dependency_constrain".equals(nodeName)) {
                this.interpretDependcy(neType, shelfType, node);
                continue;
            }
            if (!"item".equals(nodeName)) continue;
            VerRange verRange = null;
            String unSupportLanguages = null;
            ArrayList<TECPOccupySlot> recordList = new ArrayList<TECPOccupySlot>();
            ArrayList<TIntArrayList> multiSlot = new ArrayList<TIntArrayList>();
            ArrayList<TIntArrayList> occupySlot = new ArrayList<TIntArrayList>();
            TIntArrayList iList = new TIntArrayList();
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                Node attr = namedNodeMap.item(j);
                String name = attr.getNodeName();
                String value = attr.getNodeValue();
                if ("cp_type".equals(name)) {
                    cpType = SDXMLInterpreterMgr.getInstance().parseInt(value);
                    continue;
                }
                if ("install_slot_list".equals(name)) {
                    SDXMLInterpreterMgr.getInstance().parseIntList(value, iList);
                    continue;
                }
                if ("multi_slot_list".equals(name)) {
                    SDXMLInterpreterMgr.getInstance().parseNestingList(value, multiSlot);
                    continue;
                }
                if ("occupy_slot_list".equals(name)) {
                    SDXMLInterpreterMgr.getInstance().parseNestingList(value, occupySlot);
                    continue;
                }
                if ("neVersion".equals(name)) {
                    int[] from = new int[1];
                    int[] to = new int[1];
                    if (0 != TEVersionConvertUtil.parseVerFromTo(value, from, to)) continue;
                    verRange = new VerRange(0, 0);
                    verRange.init(from[0], to[0]);
                    continue;
                }
                if (!"unsupport_language_list".equals(name)) continue;
                unSupportLanguages = value;
            }
            if (cpType == 0 || null != unSupportLanguages && unSupportLanguages.contains(language)) continue;
            int mm = iList.size();
            for (int k = 0; k < mm; ++k) {
                record = new TECPOccupySlot();
                record.setM_SlotID(iList.get(k));
                record.setVerRange(verRange);
                recordList.add(record);
            }
            if (multiSlot.size() > 0) {
                int mn = multiSlot.size();
                for (int ii = 0; ii < mn; ++ii) {
                    record = new TECPOccupySlot();
                    record.setM_SlotID(((TIntArrayList)multiSlot.get(ii)).get(0));
                    record.setM_OccupySlotList((TIntArrayList)multiSlot.get(ii));
                    record.setVerRange(verRange);
                    recordList.add(record);
                }
            }
            TEEquipmentDescription.getInstance().addInstallCPRecord(neType, shelfType, cpType, recordList);
            if (occupySlot.size() <= 0) continue;
            recordList.clear();
            int nn = occupySlot.size();
            for (int jj = 0; jj < nn; ++jj) {
                record = new TECPOccupySlot();
                record.setM_SlotID(((TIntArrayList)occupySlot.get(jj)).get(0));
                record.setM_OccupySlotList((TIntArrayList)occupySlot.get(jj));
                recordList.add(record);
            }
            TEEquipmentDescription.getInstance().addOccupyCPRecord(neType, shelfType, cpType, recordList);
        }
    }

    private void interpretDependcy(int neType, int shelfType, Node node) {
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            TEInstallCPDependcyRecord record = new TEInstallCPDependcyRecord();
            TIntArrayList iList = new TIntArrayList();
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                Node attr = namedNodeMap.item(j);
                String name = attr.getNodeName();
                String value = attr.getNodeValue();
                if ("icp_slot".equals(name)) {
                    record.m_ICPSlot = SDXMLInterpreterMgr.getInstance().parseInt(value);
                    continue;
                }
                if ("pcp_slot".equals(name)) {
                    record.m_PCPSlot = SDXMLInterpreterMgr.getInstance().parseInt(value);
                    continue;
                }
                if ("relative_slot".equals(name)) {
                    record.m_RelativeSlot = SDXMLInterpreterMgr.getInstance().parseInt(value);
                    continue;
                }
                if ("icp_type_list".equals(name)) {
                    SDXMLInterpreterMgr.getInstance().parseIntList(value, iList);
                    record.m_ICPTypeList.add(iList.toNativeArray());
                    continue;
                }
                if (!"pcp_type_list".equals(name)) continue;
                SDXMLInterpreterMgr.getInstance().parseIntList(value, iList);
                record.m_PCPTypeList.add(iList.toNativeArray());
            }
            TEEquipmentDescription.getInstance().addInstallCPDependcyRecord(neType, shelfType, record);
        }
    }

    private void interpretSlotMap(int neType, int shelfType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            TIntArrayList cpTypeList = new TIntArrayList();
            int neSlotID = 0;
            int nmSlotID = 0;
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                Node attr = namedNodeMap.item(j);
                String name = attr.getNodeName();
                String value = attr.getNodeValue();
                if ("nm_slot_id".equals(name)) {
                    nmSlotID = SDXMLInterpreterMgr.getInstance().parseInt(value);
                    continue;
                }
                if ("ne_slot_id".equals(name)) {
                    neSlotID = SDXMLInterpreterMgr.getInstance().parseInt(value);
                    continue;
                }
                if (!"cp_type_list".equals(name)) continue;
                SDXMLInterpreterMgr.getInstance().parseIntList(value, cpTypeList);
            }
            TEEquipmentDescription.getInstance().addNENMSlotMapRecord(neType, shelfType, nmSlotID, neSlotID, cpTypeList);
        }
    }

    void interpretCPTypeMap(int neType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            int neCPType = 0;
            int nmCPType = 0;
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = nodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node attr = namedNodeMap.item(j);
                String name = attr.getNodeName();
                String value = attr.getNodeValue();
                if ("ne_cp_type".equals(name)) {
                    neCPType = SDXMLInterpreterMgr.getInstance().parseInt(value);
                    continue;
                }
                if (!"nm_cp_type".equals(name)) continue;
                nmCPType = SDXMLInterpreterMgr.getInstance().parseInt(value);
            }
            TEEquipmentDescription.getInstance().addNENMTypeMapRecord(neType, neCPType, nmCPType);
        }
    }

    private void interpretContainMO(int neType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            String name = "";
            int count = 1;
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                Node attr = namedNodeMap.item(j);
                String nodeName = attr.getNodeName();
                String nodeValue = attr.getNodeValue();
                if ("mo_name".equals(nodeName)) {
                    name = nodeValue;
                    continue;
                }
                if (!"mo_count".equals(nodeName)) continue;
                count = SDXMLInterpreterMgr.getInstance().parseInt(nodeValue);
            }
            TEEquipmentDescription.getInstance().addMOCount(neType, name, count);
        }
    }

    private void interpretPNPBDData(int neType, Node node) {
        NodeList shelfNodeList = ((Element)node).getElementsByTagName("shelf");
        Element shelfNode = null;
        int size = shelfNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            shelfNode = (Element)shelfNodeList.item(i);
            this.interpretShelf(neType, shelfNode);
        }
    }
}

