/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.xmlinterpreter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.mo.CfgDataMgr;
import com.huawei.nglct.mo.VerRange;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.util.batch.TECollectionOperations;
import com.huawei.nglct.util.convertor.TEVersionConvertUtil;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDCircuitPackInterpreter
extends XMLInterpreterImpl {
    @Override
    public int interpretXMLTag(Node node) {
        if (!node.hasChildNodes()) {
            return 0;
        }
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            try {
                TESDCircuitPackRecord record = new TESDCircuitPackRecord();
                int cpType = 0;
                TIntArrayList iList = new TIntArrayList();
                node = nodeList.item(i);
                String nodeName = node.getNodeName();
                if (!"circuitpack_desc".equals(nodeName)) continue;
                NamedNodeMap namedNodeMap = node.getAttributes();
                TIntArrayList modelPortList = new TIntArrayList();
                int modelGrade = -1;
                int n = namedNodeMap.getLength();
                for (int j = 0; j < n; ++j) {
                    Node attr = namedNodeMap.item(j);
                    String name = attr.getNodeName();
                    String value = attr.getNodeValue();
                    if ("cp_type".equals(name)) {
                        record.cpType = mgr.parseInt(value.trim());
                        record.cpTypeName = value;
                    }
                    if ("macro_value".equals(name)) {
                        record.cpType = Integer.valueOf(value);
                        continue;
                    }
                    if ("cp_type_name".equals(name)) {
                        record.cpName = value;
                        continue;
                    }
                    if ("dynamic_type".equals(name)) {
                        record.dynamicType = mgr.parseInt(value);
                        continue;
                    }
                    if ("port_num".equals(name)) {
                        record.portNumber = Integer.valueOf(value);
                        continue;
                    }
                    if ("subcp_num".equals(name)) {
                        record.subCPNumber = Integer.valueOf(value);
                        continue;
                    }
                    if ("wdm_cp_type".equals(name)) {
                        mgr.parseIntList(value, iList);
                        int s = iList.size();
                        for (int intIt = 0; intIt < s; ++intIt) {
                            record.wdmType |= iList.get(intIt);
                        }
                        continue;
                    }
                    if ("wdm_cp_logo_type".equals(name)) {
                        record.m_usWDMFuncType = mgr.parseInt(value);
                        continue;
                    }
                    if ("occupy_slot_num".equals(name)) {
                        record.occupySlotNumber = Integer.valueOf(value);
                        continue;
                    }
                    if ("support_xc_level".equals(name)) {
                        mgr.parseIntList(value, iList);
                        TECollectionOperations.copyFromTIntArrayList(iList, record.supportLevelList);
                        continue;
                    }
                    if ("support_als_ports".equals(name)) {
                        ArrayList portList = new ArrayList();
                        mgr.parseIntList(value, iList);
                        TECollectionOperations.copyFromTIntArrayList(iList, portList);
                        TECircuitPackDescription.getInstance().addCPSupportALSPortList(record.cpType, portList);
                        continue;
                    }
                    if ("static_contain_fblist".equals(name)) {
                        mgr.parseIntList(value, iList);
                        TECollectionOperations.copyFromTIntArrayList(iList, record.containFBList);
                        continue;
                    }
                    if ("model_grade".equals(name)) {
                        modelGrade = Integer.parseInt(value);
                        continue;
                    }
                    if (!"model_port_list".equals(name)) continue;
                    mgr.parseIntList(value, modelPortList);
                }
                this.handleBoardMacroValue(node, record);
                if (modelGrade != -1) {
                    TEOTNModelDataMgr.getInstance().putBoardGrade(record.cpType, modelGrade, modelPortList);
                }
                TECircuitPackDescription.getInstance().addCPRecord(record);
                if (!node.hasChildNodes()) continue;
                NodeList childList = node.getChildNodes();
                cpType = record.cpType;
                int mn = childList.getLength();
                for (int k = 0; k < mn; ++k) {
                    Node aNode = childList.item(k);
                    nodeName = aNode.getNodeName();
                    if ("install_port".equals(nodeName)) {
                        this.interpretInstallPort(cpType, aNode);
                        continue;
                    }
                    if ("addible_port".equals(nodeName)) {
                        this.interpretAddiblePort(cpType, aNode);
                        continue;
                    }
                    if ("addible_default_port".equals(nodeName)) {
                        this.interpretAddibleDefaultPort(cpType, aNode);
                        continue;
                    }
                    if ("sub_circuitpack".equals(nodeName)) {
                        this.interpretSubCP(cpType, aNode);
                        continue;
                    }
                    if ("relative_slot_port".equals(nodeName)) {
                        this.interpretRelariveSlotPort(cpType, aNode);
                        continue;
                    }
                    if ("cp_contain_mo_count".equals(nodeName)) {
                        this.interpretContainMO(cpType, aNode);
                        continue;
                    }
                    if ("port_para".equals(nodeName)) {
                        this.interpretCPPortPara(cpType, aNode);
                        continue;
                    }
                    if ("cp_mode".equals(nodeName)) {
                        this.interpretCPMode(cpType, aNode);
                        continue;
                    }
                    if (!"mapping_ability".equalsIgnoreCase(nodeName)) continue;
                    TEVirtualPortUtil.interpretMappingAbility(cpType, aNode);
                }
                continue;
            }
            catch (Throwable e) {
                TELogFactory.getNormalLogger().error("SDCircuitPackInterpreter.interpretXMLTag() fail!", e);
            }
        }
        return 0;
    }

    private void handleBoardMacroValue(Node node, TESDCircuitPackRecord record) {
        String macroValue;
        Element elem = (Element)node;
        if (elem.hasAttribute("macro_value") && null != (macroValue = elem.getAttribute("macro_value")) && !macroValue.isEmpty()) {
            record.cpType = Integer.parseInt(macroValue);
            SDXMLInterpreterMgr.getInstance().addMacorValue(record.cpTypeName, record.cpType);
            TECircuitPackDescription.getInstance().addCPType2MacroName(record.cpType, record.cpTypeName);
        }
    }

    void interpretCPMode(int cpType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                node = namedNodeMap.item(j);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                if (!"support_cpmode".equals(name)) continue;
                TIntArrayList iCpmodeList = new TIntArrayList();
                SDXMLInterpreterMgr.getInstance().parseIntList(value, iCpmodeList);
                if (iCpmodeList.isEmpty()) continue;
                TECircuitPackDescription.getInstance().addCPSupportModeList(cpType, iCpmodeList);
            }
        }
    }

    void interpretInstallPort(int cpType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            TIntArrayList iList = new TIntArrayList();
            int Signaltype = 255;
            int usage = 4;
            int portType = 0;
            int subfbgroup = 0;
            int level = 0;
            ArrayList portList = new ArrayList();
            int dynType = 1;
            int cpMode = 0;
            String aid_frefix = "";
            int port_offset = 0;
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                node = namedNodeMap.item(j);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                if ("cp_mode".equals(name)) {
                    cpMode = mgr.parseInt(value);
                }
                if ("port_type".equals(name)) {
                    portType = mgr.parseInt(value);
                    continue;
                }
                if ("subfbgroup".equals(name)) {
                    subfbgroup = mgr.parseInt(value);
                    continue;
                }
                if ("interface_level".equals(name)) {
                    level = mgr.parseInt(value);
                    continue;
                }
                if ("port_no_list".equals(name)) {
                    mgr.parseIntList(value, iList);
                    TECollectionOperations.copyFromTIntArrayList(iList, portList);
                    continue;
                }
                if ("signal_type".equals(name)) {
                    Signaltype = mgr.parseInt(value);
                    continue;
                }
                if ("port_usage".equals(name)) {
                    usage = mgr.parseInt(value);
                    continue;
                }
                if ("port_dyntype".equals(name)) {
                    dynType = mgr.parseInt(value);
                    continue;
                }
                if ("aid_frefix".equals(name)) {
                    aid_frefix = value;
                    continue;
                }
                if ("port_offset".equals(name)) {
                    port_offset = mgr.parseInt(value);
                    continue;
                }
                if (!"board_mode".equals(name)) continue;
                cpMode = mgr.parseInt(value);
            }
            if (0 != cpMode) {
                TECircuitPackDescription.getInstance().addInstallCPPort(cpType, portType, subfbgroup, level, portList, Signaltype, usage, dynType, cpMode, aid_frefix, port_offset);
                continue;
            }
            TECircuitPackDescription.getInstance().addInstallCPPort(cpType, portType, subfbgroup, level, portList, Signaltype, usage, dynType, 0, aid_frefix, port_offset);
        }
    }

    void interpretAddiblePort(int cpType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        TECircuitPackDescription pCPD = TECircuitPackDescription.getInstance();
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            String virtualFlg = "no";
            TIntArrayList iList = new TIntArrayList();
            TIntArrayList iPortList = new TIntArrayList();
            TIntArrayList dependPortList = new TIntArrayList();
            TIntArrayList iboardModeList = new TIntArrayList();
            ArrayList<Integer> boardModeList = new ArrayList<Integer>();
            int signaltype = 255;
            int usage = 4;
            int portType = 0;
            int subfbgroup = 0;
            int dynType = 2;
            ArrayList<VerRange> verRangeList = null;
            VerRange verRange = null;
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                node = namedNodeMap.item(j);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                if ("port_no_list".equals(name)) {
                    mgr.parseIntList(value, iPortList);
                    continue;
                }
                if ("dependport_no_list".equals(name)) {
                    mgr.parseIntList(value, dependPortList);
                    continue;
                }
                if ("port_type".equals(name)) {
                    portType = mgr.parseInt(value);
                    continue;
                }
                if ("subfbgroup".equals(name)) {
                    subfbgroup = mgr.parseInt(value);
                    continue;
                }
                if ("interface_level_list".equals(name)) {
                    mgr.parseIntList(value, iList);
                    continue;
                }
                if ("board_mode".equals(name)) {
                    mgr.parseIntList(value, iboardModeList);
                    TECollectionOperations.copyFromTIntArrayList(iboardModeList, boardModeList);
                    continue;
                }
                if ("signal_type".equals(name)) {
                    signaltype = mgr.parseInt(value);
                    continue;
                }
                if ("port_usage".equals(name)) {
                    usage = mgr.parseInt(value);
                    continue;
                }
                if ("port_dyntype".equals(name)) {
                    dynType = mgr.parseInt(value);
                    continue;
                }
                if ("ne_version".equals(name)) {
                    verRangeList = new ArrayList<VerRange>();
                    int[] from = new int[1];
                    int[] to = new int[1];
                    if (0 != TEVersionConvertUtil.parseSplitVerFromTo(value, from, to, ",")) continue;
                    verRange = new VerRange(0, 0);
                    verRange.init(from[0], to[0]);
                    verRangeList.add(verRange);
                    continue;
                }
                if (!"virtualport".equals(name)) continue;
                virtualFlg = value;
            }
            if (dependPortList.isEmpty()) {
                int s = iPortList.size();
                for (int k = 0; k < s; ++k) {
                    int mm = iList.size();
                    for (int iIt = 0; iIt < mm; ++iIt) {
                        pCPD.addAddiblePort(cpType, iPortList.get(k), portType, subfbgroup, iList.get(iIt), signaltype, usage, dynType, 0, verRangeList, boardModeList);
                        TEVirtualPortUtil.addVirtualInfoToAddiblePort(cpType, iPortList.get(k), iList.get(iIt), "yes".equals(virtualFlg));
                    }
                }
                continue;
            }
            int t1 = 0;
            int mn = iPortList.size();
            int nn = dependPortList.size();
            for (int t2 = 0; t1 < mn && t2 < nn; ++t1, ++t2) {
                int mm = iList.size();
                for (int iIt = 0; iIt < mm; ++iIt) {
                    pCPD.addAddiblePort(cpType, iPortList.get(t1), portType, subfbgroup, iList.get(iIt), signaltype, usage, dynType, dependPortList.get(t2), verRangeList, boardModeList);
                    TEVirtualPortUtil.addVirtualInfoToAddiblePort(cpType, iPortList.get(t1), iList.get(iIt), "yes".equals(virtualFlg));
                }
            }
        }
    }

    void interpretAddibleDefaultPort(int cpType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        SDXMLInterpreterMgr mgr1 = SDXMLInterpreterMgr.getInstance();
        TECircuitPackDescription pCPD = TECircuitPackDescription.getInstance();
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            TIntArrayList iList = new TIntArrayList();
            TIntArrayList iPortList = new TIntArrayList();
            TIntArrayList dependPortList = new TIntArrayList();
            TIntArrayList iboardModeList = new TIntArrayList();
            ArrayList<Integer> boardModeList = new ArrayList<Integer>();
            int signaltype = 255;
            int usage = 4;
            int portType = 0;
            int subfbgroup = 0;
            int dynType = 2;
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                node = namedNodeMap.item(j);
                String name1 = node.getNodeName();
                String value = node.getNodeValue();
                if ("port_no_list".equals(name1)) {
                    mgr1.parseIntList(value, iPortList);
                    continue;
                }
                if ("dependport_no_list".equals(name1)) {
                    mgr1.parseIntList(value, dependPortList);
                    continue;
                }
                if ("port_type".equals(name1)) {
                    portType = mgr1.parseInt(value);
                    continue;
                }
                if ("subfbgroup".equals(name1)) {
                    subfbgroup = mgr1.parseInt(value);
                    continue;
                }
                if ("interface_level_list".equals(name1)) {
                    mgr1.parseIntList(value, iList);
                    continue;
                }
                if ("board_mode".equals(name1)) {
                    mgr1.parseIntList(value, iboardModeList);
                    TECollectionOperations.copyFromTIntArrayList(iboardModeList, boardModeList);
                    continue;
                }
                if ("signal_type".equals(name1)) {
                    signaltype = mgr1.parseInt(value);
                    continue;
                }
                if ("port_usage".equals(name1)) {
                    usage = mgr1.parseInt(value);
                    continue;
                }
                if (!"port_dyntype".equals(name1)) continue;
                dynType = mgr1.parseInt(value);
            }
            if (dependPortList.isEmpty()) {
                int s = iPortList.size();
                for (int k = 0; k < s; ++k) {
                    int mm = iList.size();
                    for (int iIt = 0; iIt < mm; ++iIt) {
                        pCPD.addAddibleDefaultPort(cpType, iPortList.get(k), portType, subfbgroup, iList.get(iIt), signaltype, usage, dynType, 0, boardModeList);
                    }
                }
                continue;
            }
            int t1 = 0;
            int mn = iPortList.size();
            int nn = dependPortList.size();
            for (int t2 = 0; t1 < mn && t2 < nn; ++t1, ++t2) {
                int mm = iList.size();
                for (int iIt = 0; iIt < mm; ++iIt) {
                    pCPD.addAddibleDefaultPort(cpType, iPortList.get(t1), portType, subfbgroup, iList.get(iIt), signaltype, usage, dynType, dependPortList.get(t2), boardModeList);
                }
            }
        }
    }

    void interpretSubCP(int cpType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            int subSlot = 0;
            int startPort = 0;
            TIntArrayList iList = new TIntArrayList();
            ArrayList subCPTypeList = new ArrayList();
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                node = namedNodeMap.item(j);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                if ("sub_slot".equals(name)) {
                    subSlot = mgr.parseInt(value);
                    continue;
                }
                if ("start_port_no".equals(name)) {
                    startPort = mgr.parseInt(value);
                    continue;
                }
                if (!"sub_cp_type_list".equals(name)) continue;
                mgr.parseIntList(value, iList);
                TECollectionOperations.copyFromTIntArrayList(iList, subCPTypeList);
            }
            TECircuitPackDescription.getInstance().addSubCPPort(cpType, subSlot, subCPTypeList, startPort);
        }
    }

    void interpretRelariveSlotPort(int cpType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            int relaSlot = 0;
            int startPort = 0;
            TIntArrayList iCPTypeList = new TIntArrayList();
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                node = namedNodeMap.item(j);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                if ("relative_slot".equals(name)) {
                    relaSlot = Integer.valueOf(value);
                    continue;
                }
                if ("icp_type_list".equals(name)) {
                    mgr.parseIntList(value, iCPTypeList);
                    continue;
                }
                if (!"start_port_no".equals(name)) continue;
                startPort = Integer.valueOf(value);
            }
            if (iCPTypeList.size() > 0) {
                int s = iCPTypeList.size();
                for (int k = 0; k < s; ++k) {
                    TECircuitPackDescription.getInstance().addItfCPPort(cpType, iCPTypeList.get(k), relaSlot, startPort);
                }
                continue;
            }
            TECircuitPackDescription.getInstance().addItfCPPort(cpType, 255, relaSlot, startPort);
        }
    }

    void interpretContainMO(int cpType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            String strName = "";
            int usCount = 1;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                node = namedNodeMap.item(j);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                if ("mo_name".equals(name)) {
                    strName = value;
                    continue;
                }
                if (!"mo_count".equals(name)) continue;
                usCount = Integer.valueOf(value);
            }
            TECircuitPackDescription.getInstance().addCPMOCount(cpType, strName, usCount);
        }
    }

    void interpretCPPortPara(int cpType, Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            node = nodeList.item(i);
            if (!"item".equals(node.getNodeName())) continue;
            String inName = "";
            String outName = "";
            int offsetID = 0;
            TIntArrayList iList = new TIntArrayList();
            TIntArrayList portIDList = new TIntArrayList();
            TEPortParaRecord record = new TEPortParaRecord();
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                TIntArrayList neSerList;
                node = namedNodeMap.item(j);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                if ("port_no_list".equals(name)) {
                    mgr.parseIntList(value, portIDList);
                    continue;
                }
                if ("port_type".equals(name)) {
                    record.portType = mgr.parseInt(value);
                    continue;
                }
                if ("layer_typ".equals(name)) {
                    record.layerType = mgr.parseInt(value);
                    continue;
                }
                if ("xc_cfg_type".equals(name)) {
                    record.supXCCfgType = mgr.parseInt(value);
                    continue;
                }
                if ("support_xc_level".equals(name)) {
                    iList.clear();
                    mgr.parseIntList(value, iList);
                    neSerList = this.convertFromNMToNE(iList);
                    TECollectionOperations.copyFromTIntArrayList(neSerList, record.supXCLevelList);
                    continue;
                }
                if ("support_tl1xc_level".equals(name)) {
                    iList.clear();
                    mgr.parseIntList(value, iList);
                    neSerList = this.convertFromNMToNE(iList);
                    TECollectionOperations.copyFromTIntArrayList(neSerList, record.supTl1XCLevelList);
                    continue;
                }
                if ("path_list".equals(name)) {
                    iList.clear();
                    mgr.parseIntList(value, iList);
                    TECollectionOperations.copyFromTIntArrayList(iList, record.srcPathIDList);
                    TECollectionOperations.copyFromTIntArrayList(iList, record.snkPathIDList);
                    continue;
                }
                if ("src_path_list".equals(name)) {
                    iList.clear();
                    mgr.parseIntList(value, iList);
                    TECollectionOperations.copyFromTIntArrayList(iList, record.srcPathIDList);
                    continue;
                }
                if ("snk_path_list".equals(name)) {
                    iList.clear();
                    mgr.parseIntList(value, iList);
                    TECollectionOperations.copyFromTIntArrayList(iList, record.snkPathIDList);
                    continue;
                }
                if ("in_name".equals(name)) {
                    record.inName = value;
                    continue;
                }
                if ("out_name".equals(name)) {
                    record.outName = value;
                    continue;
                }
                if ("in_name_id".equals(name)) {
                    inName = value;
                    continue;
                }
                if ("out_name_id".equals(name)) {
                    outName = value;
                    continue;
                }
                if ("name_offset_id".equals(name)) {
                    offsetID = mgr.parseInt(value);
                    continue;
                }
                if ("ts_cfg_type".equals(name)) {
                    record.supTSCfgType = mgr.parseInt(value);
                    continue;
                }
                if ("ts_support_path".equals(name)) {
                    iList.clear();
                    mgr.parseIntList(value, iList);
                    TECollectionOperations.copyFromTIntArrayList(iList, record.tsPathIDList);
                    continue;
                }
                if ("ts_total_num".equals(name)) {
                    record.tsTotalNum = mgr.parseInt(value);
                    continue;
                }
                if (!"board_mode".equals(name)) continue;
                iList.clear();
                mgr.parseIntList(value, iList);
                record.boardModeList = new ArrayList();
                TECollectionOperations.copyFromTIntArrayList(iList, (ArrayList)record.boardModeList);
            }
            String name = "";
            int mn = portIDList.size();
            for (int k = 0; k < mn; ++k) {
                int portId = portIDList.get(k);
                if (!"".equals(inName)) {
                    record.inName = name = inName.substring(0, inName.lastIndexOf("%d")) + (portId + offsetID);
                }
                if (!"".equals(outName)) {
                    record.outName = name = outName.substring(0, outName.lastIndexOf("%d")) + (portId + offsetID);
                }
                TECircuitPackDescription.getInstance().addCPPortPara(cpType, portId, (TEPortParaRecord)record.clone());
            }
        }
    }

    private TIntArrayList convertFromNMToNE(TIntArrayList nmServiceTypeList) {
        CfgDataMgr dataMgr = CfgDataMgr.getInstance();
        TIntArrayList tempArr = new TIntArrayList();
        int size = nmServiceTypeList.size();
        for (int i = 0; i < size; ++i) {
            int nmServiceType = nmServiceTypeList.get(i);
            int neServiceType = dataMgr.getNESerTypeByNM(nmServiceType);
            tempArr.add(neServiceType);
        }
        return tempArr;
    }
}

