/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.ScriptFile;
import com.huawei.nglct.cbb.script.TECmdNameConvert;
import com.huawei.nglct.cbb.script.TEImapAppFile;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptDataConstants;
import com.huawei.nglct.cbb.script.TEScriptEnumMgr;
import com.huawei.nglct.cbb.script.TEScriptManagementResult;
import com.huawei.nglct.cbb.script.TEScriptMgrUtil;
import com.huawei.nglct.core.communication.DebugTracer;
import com.huawei.nglct.core.neproxy.TEProcID;
import com.huawei.nglct.core.startup.SystemConfiguration;
import com.huawei.nglct.util.string.TEConvertUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class TScriptFileImpl
extends ScriptFile {
    public static final char[] TO_BE_IGNORED_BEGIN = "/*NeBoardInfo".toCharArray();
    private boolean remainPreConfiged = false;
    private boolean cmdHasBeenChecked = false;
    private TEImapAppFile imapAppFile;
    private String fileName;
    private int version = 33620738;
    private List<TEScriptCmd> scriptCmds = new ArrayList<TEScriptCmd>();
    private TEScriptManagementResult result;
    private TEScriptDataConstants.READING_STATE state = TEScriptDataConstants.READING_STATE.ST_NORMAL;
    private int line;
    private int curCmdIndex = -1;

    public TScriptFileImpl(TEScriptDataConstants.SCRIPT_TYPE scriptType, List<Integer> neIDs, TEScriptManagementResult result) {
        this.result = result;
        this.imapAppFile = null;
    }

    public boolean getNextCmdCode(List<Integer> cmdCode) {
        if (this.curCmdIndex > this.scriptCmds.size() - 1) {
            return false;
        }
        cmdCode.clear();
        cmdCode.add(this.scriptCmds.get(this.curCmdIndex++).getCmdCode());
        return true;
    }

    public boolean preGetNextCmdCode(List<Integer> cmdCode) {
        if (this.curCmdIndex >= this.scriptCmds.size() - 1) {
            return false;
        }
        cmdCode.clear();
        cmdCode.add(this.scriptCmds.get(this.curCmdIndex + 1).getCmdCode());
        return true;
    }

    public boolean getPreCmdCode(List<Integer> cmdCode) {
        if (this.curCmdIndex < 0) {
            return false;
        }
        cmdCode.clear();
        cmdCode.add(this.scriptCmds.get(--this.curCmdIndex).getCmdCode());
        return true;
    }

    public boolean getCmdCodeAtIndex(List<Integer> cmdCode, int index) {
        if (this.curCmdIndex > this.scriptCmds.size() - 1) {
            return false;
        }
        if (index < 0 || index > this.scriptCmds.size() - 1) {
            return false;
        }
        cmdCode.clear();
        cmdCode.add(this.scriptCmds.get(index).getCmdCode());
        this.curCmdIndex = index;
        return true;
    }

    public boolean openForRead(String dir, String fileName) {
        TEImapAppFile.FileHandle scriptFile;
        String fullFileName = this.getFullDir(dir, fileName);
        TEProcID procID = new TEProcID(SystemConfiguration.getPubserverProcID(), '\u0000');
        if (this.imapAppFile == null) {
            this.imapAppFile = new TEImapAppFile(fullFileName, TEScriptDataConstants.FILE_OPERATION_TYPE.OPERATE_ONLY_READ, TEScriptDataConstants.FILE_OPEN_MODE.OPEN_WITH_FILE_HANDLE, procID);
            if (0 != this.imapAppFile.getResult()) {
                return false;
            }
        }
        if ((scriptFile = this.imapAppFile.getFileHandle()) != null && scriptFile.readHandle != null) {
            try {
                char[] chs = new char[255];
                int count = scriptFile.readHandle.read(chs);
                String snippet = new String(chs, 0, count);
                int pos1 = snippet.indexOf("//{{script_version=");
                int pos2 = snippet.indexOf("}}");
                if (pos1 != -1 && pos2 != -1) {
                    String strVer = snippet.substring(pos1 + 19, pos2);
                    int intVer = TEConvertUtil.convertVerStrToInt(strVer);
                    this.version = intVer == 0 ? 33620738 : intVer;
                }
                scriptFile.reOpenReader();
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("TScriptFileImpl.openForRead() fail!", (Throwable)e);
            }
        } else {
            DebugTracer.trace(String.format("Open Script File for read error!filename:%s.\n", fullFileName));
        }
        return null != scriptFile;
    }

    public boolean openForWrite(TEScriptDataConstants.SCRIPT_TYPE scriptType, String dir, String fileName, int userID, boolean havAnnot) {
        String fullFileName = this.getFullDir(dir, fileName);
        TEProcID procID = new TEProcID(SystemConfiguration.getPubserverProcID(), '\u0000');
        if (this.imapAppFile == null) {
            this.imapAppFile = new TEImapAppFile(userID);
        }
        if (havAnnot) {
            this.imapAppFile.open(fullFileName, TEScriptDataConstants.FILE_OPERATION_TYPE.OPERATE_READ_WRITE, TEScriptDataConstants.FILE_OPEN_MODE.OPEN_WITH_FILE_HANDLE, procID);
        } else {
            this.imapAppFile.open(fullFileName, TEScriptDataConstants.FILE_OPERATION_TYPE.OPERATE_APPEND, TEScriptDataConstants.FILE_OPEN_MODE.OPEN_WITH_FILE_HANDLE, procID);
        }
        if (0 != this.imapAppFile.getResult()) {
            return false;
        }
        TEImapAppFile.FileHandle scriptFile = this.imapAppFile.getFileHandle();
        if (scriptFile != null) {
            if (havAnnot) {
                TEScriptMgrUtil.writeNMVersion(this.imapAppFile);
                String sName = "currentscriptversion";
                ArrayList<Integer> hook = new ArrayList<Integer>(1);
                int curScriVer = !TEScriptEnumMgr.instance().valueS2I(hook, sName, 0, "scriptversion", 0) ? this.version : (Integer)hook.get(0);
                String seperatedVer = String.format("%d.%d.%d.%d", curScriVer >> 24 & 0xFF, curScriVer >> 16 & 0xFF, curScriVer >> 8 & 0xFF, curScriVer & 0xFF);
                StringBuffer buf = new StringBuffer();
                buf.append("//{{script_version=");
                buf.append(seperatedVer);
                buf.append("}}\n");
                this.imapAppFile.writeString(buf.toString());
                String userName = "";
                this.writeScriptExporterInfo(scriptType, userName);
            }
        } else {
            DebugTracer.trace(String.format("Open Script File for write error!filename:%s.\n", fullFileName));
        }
        return scriptFile != null;
    }

    public boolean writeScriptExporterInfo(TEScriptDataConstants.SCRIPT_TYPE type, String userName) {
        StringBuffer buf = new StringBuffer();
        buf.append("// ");
        switch (type) {
            case ST_NECFG: {
                buf.append("NE Configuration Data Script");
                break;
            }
            case ST_PORTNAME: {
                buf.append("NE Port Name Script");
                break;
            }
            case ST_NETCFG: {
                buf.append("Network Config Script");
                break;
            }
            case ST_NELIST: {
                buf.append("NE List Script");
                break;
            }
            case ST_NMINFO: {
                buf.append("Local NM Information");
                break;
            }
            case ST_NETSVC: {
                buf.append("Transmit Service Data Script");
                break;
            }
            case ST_ERRINFO: {
                buf.append("Error List file");
                break;
            }
            case ST_MDCFG: {
                buf.append("MDS Config Script");
                break;
            }
            default: {
                DebugTracer.trace("Input Unknown ScriptType in TScriptFileImpl::WriteScriptExporterInfo, eScriptType is " + type.getValue() + "\n");
                return false;
            }
        }
        buf.append("\n");
        buf.append("// ");
        buf.append(String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", Calendar.getInstance()));
        buf.append(" Created by ");
        buf.append(userName);
        buf.append("\n\n");
        return this.imapAppFile.writeString(buf.toString());
    }

    @Override
    public boolean writeCommand(TEScriptCmd cmd) {
        boolean ret = true;
        if (this.imapAppFile == null) {
            return false;
        }
        if (cmd.getSize() == 0) {
            return true;
        }
        int curColumn = 0;
        String paraName = "";
        int paraCount = cmd.getSize();
        ArrayList<String> paraValues = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        String cmdHead = TECmdNameConvert.getCorrespondCmdName(buf, cmd.getCmdCode()) ? buf.toString() : "";
        if ("".equals(cmdHead)) {
            for (int i = 0; i < paraCount; ++i) {
                buf.setLength(0);
                cmd.getPara(i, buf, paraValues, 0);
                if (paraValues.size() <= 0) continue;
                ret = this.imapAppFile.writeString((String)paraValues.get(0));
            }
            ret = this.imapAppFile.writeString("\n");
        } else {
            ret = this.imapAppFile.writeString(":");
            ret = this.imapAppFile.writeString(cmdHead);
            ret = this.imapAppFile.writeString(":{");
            curColumn += cmdHead.length() + 3;
            String paraSep = "";
            for (int i = 0; i < paraCount; ++i) {
                buf.setLength(0);
                cmd.getPara(i, buf, paraValues, 0);
                if (paraValues.size() == 0) {
                    DebugTracer.trace("ParaValue List is empty.\n");
                    continue;
                }
                if (buf.length() != 0) {
                    ret = this.imapAppFile.writeString(paraSep);
                    if (curColumn > 80 && i < paraCount - 1) {
                        ret = this.imapAppFile.writeString("\n  ");
                        curColumn = 2;
                    }
                    paraSep = ", ";
                    ret = this.imapAppFile.writeString(buf.toString());
                    ret = this.imapAppFile.writeString("=");
                    curColumn += paraName.length() + 1;
                    String paraValueSep = "";
                    int size = paraValues.size();
                    for (int j = 0; j < size; ++j) {
                        String oneValue = (String)paraValues.get(j);
                        ret = this.imapAppFile.writeString(paraValueSep);
                        paraValueSep = "&";
                        ret = this.imapAppFile.writeString(oneValue);
                        if ((curColumn += oneValue.length() + 1) <= 80 || j + 1 == paraValues.size() - 1) continue;
                        ret = this.imapAppFile.writeString("\n  ");
                        curColumn = 2;
                    }
                    continue;
                }
                DebugTracer.trace("ParaName is empty when write command.\n");
            }
            ret = this.imapAppFile.writeString("};\n\n");
        }
        if (!ret) {
            this.result.errorCode = 1090614060;
        }
        return true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int countCommands(int cmdID) {
        int count = 0;
        for (int i = 0; i < 0; ++i) {
            if (this.scriptCmds.get(i).getCmdCode() != cmdID) continue;
            ++count;
        }
        return count;
    }

    public boolean goToFirstCommand() {
        if (this.scriptCmds.size() == 0) {
            return false;
        }
        this.curCmdIndex = 0;
        return true;
    }

    public boolean getCmdCodeOfCurrCmdAndCheck(List<Integer> cmdID) {
        ArrayList<TEScriptCmd> hook;
        if (this.cmdHasBeenChecked && !this.getOneCommand(hook = new ArrayList<TEScriptCmd>())) {
            return false;
        }
        this.cmdHasBeenChecked = true;
        return this.getCmdCodeOfCurrCmd(cmdID);
    }

    public boolean getOneCommand(List<TEScriptCmd> cmd) {
        if (this.curCmdIndex == -1) {
            return false;
        }
        cmd.clear();
        TEScriptCmd curCmd = this.scriptCmds.get(this.curCmdIndex - 1);
        this.curLine = curCmd.getLineNo();
        cmd.add(curCmd);
        if (this.curCmdIndex > this.scriptCmds.size()) {
            this.curCmdIndex = -1;
        }
        return true;
    }

    public boolean getCmdCodeOfCurrCmd(List<Integer> cmdID) {
        if (this.curCmdIndex == -1 || this.curCmdIndex > this.scriptCmds.size() - 1) {
            return false;
        }
        cmdID.add(this.scriptCmds.get(this.curCmdIndex).getCmdCode());
        return true;
    }

    public void pushOneCommand(TEScriptCmd cmd) {
        this.scriptCmds.add(cmd);
    }

    public boolean setRemainPreConfiged(boolean remainPreConfiged) {
        boolean oldState = remainPreConfiged;
        this.remainPreConfiged = remainPreConfiged;
        return oldState;
    }

    public boolean isRemainPreConfiged() {
        return this.remainPreConfiged;
    }

    public int getNextMMLString(StringBuffer buf) {
        try {
            String readed;
            int tmp;
            char preCh = '\u0000';
            int count = 0;
            while ((tmp = this.imapAppFile.getFileHandle().readHandle.read()) != -1) {
                char ch = (char)tmp;
                if ((short)ch == 10) {
                    ++this.line;
                }
                if ('\r' == ch) continue;
                if (ch == TO_BE_IGNORED_BEGIN[count]) {
                    if (++count == TO_BE_IGNORED_BEGIN.length) {
                        buf.setLength(0);
                        return 0;
                    }
                } else {
                    count = 0;
                }
                if (this.state == TEScriptDataConstants.READING_STATE.ST_NORMAL) {
                    if (ch == '/') {
                        this.state = TEScriptDataConstants.READING_STATE.ST_PRECMT;
                    } else {
                        if (ch >= 'A' && ch <= 'Z') {
                            ch = (char)(ch + 32);
                        }
                        buf.append(ch == '\n' ? (char)' ' : (char)ch);
                        if (ch == '\"') {
                            this.state = TEScriptDataConstants.READING_STATE.ST_STRING;
                        } else if (ch == ';') {
                            break;
                        }
                    }
                } else if (this.state == TEScriptDataConstants.READING_STATE.ST_STRING) {
                    buf.append(ch);
                    if (ch == '\"' && preCh != '\\') {
                        this.state = TEScriptDataConstants.READING_STATE.ST_NORMAL;
                    }
                } else if (this.state == TEScriptDataConstants.READING_STATE.ST_PRECMT) {
                    if (ch == '/') {
                        this.state = TEScriptDataConstants.READING_STATE.ST_CMTLN;
                    } else if (ch == '*') {
                        this.state = TEScriptDataConstants.READING_STATE.ST_CMTBK;
                    } else {
                        this.state = TEScriptDataConstants.READING_STATE.ST_NORMAL;
                        buf.append('/');
                        buf.append(ch == '\n' ? (char)' ' : (char)ch);
                        if (';' == ch) {
                            break;
                        }
                    }
                } else if (this.state == TEScriptDataConstants.READING_STATE.ST_CMTLN) {
                    if (ch == '\n') {
                        buf.append(' ');
                        this.state = TEScriptDataConstants.READING_STATE.ST_NORMAL;
                    }
                } else if (this.state == TEScriptDataConstants.READING_STATE.ST_CMTBK) {
                    if (ch == '*') {
                        this.state = TEScriptDataConstants.READING_STATE.ST_PREBKEND;
                    }
                } else if (this.state == TEScriptDataConstants.READING_STATE.ST_PREBKEND) {
                    if (ch == '/') {
                        buf.append(' ');
                        this.state = TEScriptDataConstants.READING_STATE.ST_NORMAL;
                    } else if (ch != '*') {
                        this.state = TEScriptDataConstants.READING_STATE.ST_CMTBK;
                    }
                }
                preCh = ch;
            }
            if ((readed = buf.toString().trim()).length() == 0) {
                return 0;
            }
            buf.setLength(0);
            buf.append(readed);
            return this.line;
        }
        catch (IOException e) {
            DebugTracer.trace(String.format("Exception occurred during reading the script file: %s\n", this.fileName));
            DebugTracer.trace(e);
            return 0;
        }
    }

    public void close() {
        if (this.imapAppFile != null) {
            this.imapAppFile.close();
        }
    }

    protected String getFullDir(String dir, String fileName) {
        String fullFileName = "";
        if (dir == null || dir.equalsIgnoreCase("")) {
            if (fileName == null || fileName.equalsIgnoreCase("")) {
                return null;
            }
            fullFileName = fileName;
        } else {
            fullFileName = dir;
            fullFileName = fullFileName + '/';
            fullFileName = fullFileName + fileName;
        }
        this.fileName = fileName;
        return fullFileName;
    }
}

