/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.script;

import com.huawei.nglct.cbb.script.TEEnumMapKey;
import com.huawei.nglct.cbb.script.TEEnumPair;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.system.TESystemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEScriptXMLParser {
    public static final String SCRIPT_ENUM_FILE_NAME = TESystemUtil.getIMAPEnvironment() + "/../core/conf/xml/script/script_enum.xml";
    protected Map<TEEnumMapKey, List<TEEnumPair>> enumMap;

    public void connnect(Map enumMap) {
        this.enumMap = enumMap;
    }

    public void parseScriptEnumXML() {
        Document doc = TEParseXMLFile.parseFile(SCRIPT_ENUM_FILE_NAME);
        if (null == doc) {
            return;
        }
        NodeList cmds = doc.getElementsByTagName("Cmd");
        int iSize = cmds.getLength();
        for (int i = 0; i < iSize; ++i) {
            Element cmdElement = (Element)cmds.item(i);
            int curCmdID = Integer.valueOf(cmdElement.getAttribute("cmdid"));
            NodeList paras = cmdElement.getElementsByTagName("Para");
            int jSize = paras.getLength();
            for (int j = 0; j < jSize; ++j) {
                Element paraElement = (Element)paras.item(j);
                NodeList values = paraElement.getElementsByTagName("Value");
                String paraName = paraElement.getAttribute("name");
                int extendid = Integer.valueOf(paraElement.getAttribute("extendid"));
                TEEnumMapKey enumMapKey = new TEEnumMapKey(curCmdID, paraName, extendid);
                List valueList = TEScriptXMLParser.parseScriptEumValue(values);
                this.enumMap.put(enumMapKey, valueList);
            }
        }
    }

    protected static List parseScriptEumValue(NodeList values) {
        ArrayList<TEEnumPair> valueList = new ArrayList<TEEnumPair>();
        int size = values.getLength();
        for (int i = 0; i < size; ++i) {
            Element valueElement = (Element)values.item(i);
            String strNum = valueElement.getAttribute("num").trim();
            int numValue = 0;
            if (strNum == null || "".equals(strNum)) continue;
            numValue = strNum.startsWith("0x") || strNum.startsWith("0X") ? Integer.parseInt(strNum.substring(2), 16) : (strNum.startsWith("0") && strNum.length() > 1 ? Integer.parseInt(strNum.substring(1), 8) : Integer.parseInt(strNum));
            String strValue = valueElement.getAttribute("str");
            TEEnumPair enumPair = new TEEnumPair(numValue, strValue);
            valueList.add(enumPair);
        }
        return valueList;
    }
}

