/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.script;

import com.huawei.nglct.cbb.script.TEMMLParaStruct;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptEnumMgr;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptHandlerMgr;
import com.huawei.nglct.cbb.script.TEScriptWriterUtil;
import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;

public class TEScriptOperationMgr {
    private static TEScriptOperationMgr instance = new TEScriptOperationMgr();
    private TEScriptHandlerMgr handlerMgr = null;
    private TEScriptWriterUtil writer = null;
    private TEScriptEnumMgr scriptEnum = TEScriptEnumMgr.instance();
    private Logger embededWnemgrLogger = TEWNEMgrJniLogFactory.getLogger(TEScriptOperationMgr.class.getName());
    private Set<Integer> notSupportBoardSet = new HashSet<Integer>();
    private Set<Integer> needCheckItemSet = new HashSet<Integer>();

    private TEScriptOperationMgr() {
        this.initData();
        this.notSupportBoardSet.add(2292);
        this.notSupportBoardSet.add(2110);
        this.notSupportBoardSet.add(1067);
        this.notSupportBoardSet.add(2109);
        this.notSupportBoardSet.add(927);
        this.needCheckItemSet.add(720926);
        this.needCheckItemSet.add(720927);
        this.needCheckItemSet.add(720928);
        this.needCheckItemSet.add(720942);
        this.needCheckItemSet.add(720943);
        this.needCheckItemSet.add(720944);
        this.needCheckItemSet.add(720933);
        this.needCheckItemSet.add(720934);
        this.needCheckItemSet.add(720932);
        this.needCheckItemSet.add(720937);
        this.needCheckItemSet.add(720938);
        this.needCheckItemSet.add(720939);
        this.needCheckItemSet.add(720941);
        this.needCheckItemSet.add(720935);
        this.needCheckItemSet.add(720936);
        this.needCheckItemSet.add(720964);
        this.needCheckItemSet.add(720950);
        this.needCheckItemSet.add(720949);
        this.needCheckItemSet.add(720948);
        this.needCheckItemSet.add(720929);
        this.needCheckItemSet.add(720930);
        this.needCheckItemSet.add(720961);
        this.needCheckItemSet.add(720963);
        this.needCheckItemSet.add(720947);
        this.needCheckItemSet.add(720945);
    }

    private void initData() {
        this.embededWnemgrLogger.info("begin to init script data");
        this.embededWnemgrLogger.info("begin to init script handle conf ......");
        this.handlerMgr = TEScriptHandlerMgr.getInstance();
        this.embededWnemgrLogger.info("end to init script handle conf ......");
        this.embededWnemgrLogger.info("begin to init script enum data");
        this.scriptEnum.init();
        this.embededWnemgrLogger.info("end to init script enum data");
        this.writer = TEScriptWriterUtil.getInstance();
        this.embededWnemgrLogger.info("end to init script data");
    }

    public static TEScriptOperationMgr getInstance() {
        return instance;
    }

    public static void init() {
    }

    public TEScriptHandler getHandler(int neID, int item) {
        return this.handlerMgr.getHandler(neID, item);
    }

    public int writeCommand(int neID, int item, TEScriptCmd cs) {
        TEMMLParaStruct boardPara = cs.getMMLPara("board");
        if (this.needCheckItemSet.contains(item) && boardPara != null && !boardPara.values.isEmpty()) {
            String bdStr = boardPara.values.get(0);
            int slot = 0;
            slot = bdStr.indexOf("-") > 0 ? Integer.parseInt(bdStr.split("-")[0].substring(1)) : Integer.parseInt(bdStr);
            TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neID, slot);
            if (board == null) {
                return 0;
            }
            if (this.notSupportBoardSet.contains(board.getBoardType())) {
                return 0;
            }
        }
        return this.writer.writeCommand(neID, item, cs);
    }

    public int writeComment(int neID, int item, String comment) {
        if (comment != null && !comment.isEmpty() && comment.lastIndexOf("\n") != comment.length() - 1) {
            comment = comment + "\n";
        }
        return this.writer.writeComment(neID, item, comment);
    }

    public Set<Integer> getNotSupportSet() {
        return this.notSupportBoardSet;
    }

    public boolean isSupportExport(int neID, int slotID) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        return !this.notSupportBoardSet.contains(board.getBoardType());
    }
}

