/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.script;

import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class TEScriptHandlerMgr {
    private static final String SCRIPTHANDLERMAPPING_FILENAME = "scripthandlermapping.xml";
    private static final String VERSIONATTRIBUTE = "version";
    private static final String VERSIONADAPTERTAG = "versionadapter";
    private static final String DEVICETYPEATTRIBUTE = "devicetype";
    private static final String ADAPTERTAG = "adapter";
    private static final String CLASSATTRIBUTE = "class";
    private static final String ITEMATTRIBUTE = "item";
    private static final String HANDLERTAG = "handler";
    private static final String CONTINOUSVERSPLIT = "-";
    private static final String VER_SPLIT_STR = ",";
    private static final String SCRIPT_DIR_NAME = "script";
    private static Logger embededWnemgrLogger = TEWNEMgrJniLogFactory.getLogger(TEScriptHandlerMgr.class.getName());
    private static TEScriptHandlerMgr instance = new TEScriptHandlerMgr();
    private Map<Integer, HandlerConf> handlerConfs = new HashMap<Integer, HandlerConf>();

    private TEScriptHandlerMgr() {
        try {
            this.init();
        }
        catch (Exception e) {
            embededWnemgrLogger.error("", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        String version = "5.76.05.20-5.76.99.99";
        int index = version.indexOf(CONTINOUSVERSPLIT);
        String left = version.substring(0, index);
        String right = version.substring(index + 1);
        int leftv = VersionUtil.singleVersionStr2Int(left);
        int rightv = VersionUtil.singleVersionStr2Int(right);
        System.out.print("leftv:" + leftv);
        System.out.print("rightv:" + rightv);
    }

    private void init() {
        StringBuffer filePath = new StringBuffer(TEResourceManager.getPath()).append(File.separator).append(TEPathManager.CONFIG_PROFILE_PATH).append(SCRIPT_DIR_NAME).append(File.separator).append(SCRIPTHANDLERMAPPING_FILENAME);
        embededWnemgrLogger.info("script conf file path!->" + filePath);
        File file = TEResourceManager.getFileByName(filePath.toString());
        if (null == file || !file.exists()) {
            embededWnemgrLogger.info("script conf file not exists!->" + filePath);
            return;
        }
        embededWnemgrLogger.info("begin to load script handler conf->" + file.getAbsolutePath());
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builderFactory = DocumentBuilderFactory.newInstance();
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (Exception e) {
            embededWnemgrLogger.info("", (Throwable)e);
            return;
        }
        if (null == doc) {
            embededWnemgrLogger.info("parse script handler failed....");
            return;
        }
        NodeList handlers = doc.getElementsByTagName(HANDLERTAG);
        int iSize = handlers.getLength();
        for (int i = 0; i < iSize; ++i) {
            Element cmdElement = (Element)handlers.item(i);
            HandlerConf key = new HandlerConf();
            this.processHandlerConf(cmdElement, key);
        }
    }

    private void processHandlerConf(Element handlerElement, HandlerConf key) {
        String item = handlerElement.getAttribute(ITEMATTRIBUTE);
        String cls = handlerElement.getAttribute(CLASSATTRIBUTE);
        key.item = Integer.parseInt(item);
        key.hcls = cls;
        this.handlerConfs.put(key.item, key);
        embededWnemgrLogger.info("Script when put the key.item->" + key.item);
        NodeList adapters = handlerElement.getElementsByTagName(ADAPTERTAG);
        int size = adapters.getLength();
        for (int i = 0; i < size; ++i) {
            Element adapterElement = (Element)adapters.item(i);
            this.processHandlerDeviceAdapter(adapterElement, key);
        }
    }

    private void processHandlerDeviceAdapter(Element adapterElement, HandlerConf key) {
        String device = adapterElement.getAttribute(DEVICETYPEATTRIBUTE);
        if (device == null) {
            return;
        }
        String cls = adapterElement.getAttribute(CLASSATTRIBUTE);
        if (null == cls) {
            cls = key.hcls;
        }
        DeviceAdapter adapter = new DeviceAdapter();
        adapter.devicetype = Integer.parseInt(device);
        adapter.hcls = cls;
        key.addDeviceAdapter(adapter);
        NodeList adapters = adapterElement.getElementsByTagName(VERSIONADAPTERTAG);
        int iSize = adapters.getLength();
        for (int i = 0; i < iSize; ++i) {
            Element versionElement = (Element)adapters.item(i);
            this.processVersionAdapter(versionElement, adapter);
        }
    }

    private void processVersionAdapter(Element versionElement, DeviceAdapter adapter) {
        String version = versionElement.getAttribute(VERSIONATTRIBUTE);
        if (version == null || version.equals("")) {
            return;
        }
        String cls = versionElement.getAttribute(CLASSATTRIBUTE);
        if (null == cls) {
            cls = adapter.hcls;
        }
        VersionAdapter verAdapter = new VersionAdapter();
        verAdapter.hcls = cls;
        embededWnemgrLogger.info("parse ver " + version);
        verAdapter.parseVersion(version);
        adapter.addVersionAdapter(verAdapter);
    }

    static TEScriptHandlerMgr getInstance() {
        return instance;
    }

    TEScriptHandler getHandler(int neID, int item) {
        embededWnemgrLogger.info("Script The item is: " + item);
        HandlerConf key = this.handlerConfs.get(item);
        embededWnemgrLogger.info("Get script The item key is: " + key);
        return this.getHandler(neID, key);
    }

    private TEScriptHandler getHandler(int neID, HandlerConf key) {
        TENE neobj = TENEListMgr.getInstance().getNE(neID);
        if (neobj == null) {
            return null;
        }
        long version = neobj.getShowOrHostVersion();
        int type = neobj.getNEType();
        if (null == key) {
            return null;
        }
        String cls = key.getHandlerClassName(type, (int)version);
        if (cls == null) {
            return null;
        }
        if (cls.equals("")) {
            cls = key.hcls;
        }
        Object obj = null;
        try {
            obj = Class.forName(cls).newInstance();
        }
        catch (Exception e) {
            embededWnemgrLogger.error("class is not found:" + cls);
            return null;
        }
        return obj;
    }

    private class ContinousVersion
    implements VersionChecker,
    VersionParser {
        int incstep = 4;
        Range[] rs = new Range[4];
        int vc = 0;

        private ContinousVersion() {
        }

        @Override
        public boolean checkVersion(int ver) {
            boolean result = false;
            for (Range r : this.rs) {
                if (r == null || !r.isIn(ver)) continue;
                result = true;
                break;
            }
            return result;
        }

        @Override
        public void parseVersion(String version) {
            int index = version.indexOf(TEScriptHandlerMgr.CONTINOUSVERSPLIT);
            String left = version.substring(0, index);
            String right = version.substring(index + 1);
            int leftv = VersionUtil.singleVersionStr2Int(left);
            int rightv = VersionUtil.singleVersionStr2Int(right);
            Range r = new Range(leftv, rightv);
            this.addRange(r);
        }

        private void addRange(Range r) {
            this.encapcity();
            this.rs[this.vc] = r;
            ++this.vc;
        }

        private void encapcity() {
            if (this.rs.length >= this.vc) {
                Range[] nv = new Range[this.vc + this.incstep];
                System.arraycopy(this.rs, 0, nv, 0, this.rs.length);
                this.rs = nv;
            }
        }

        @Override
        public boolean fit(String version) {
            boolean result;
            boolean bl = result = null != version;
            if (result) {
                result = version.contains(TEScriptHandlerMgr.CONTINOUSVERSPLIT);
            }
            return result;
        }
    }

    private class Range {
        final int min;
        final int max;

        Range(int l, int r) {
            this.min = Math.min(l, r);
            this.max = Math.max(l, r);
        }

        boolean isIn(int value) {
            return value <= this.max && value >= this.min;
        }
    }

    static class VersionUtil {
        VersionUtil() {
        }

        static int singleVersionStr2Int(String version) {
            return Integer.parseInt(version.replaceAll("\\.", ""));
        }
    }

    private class SingleVersionRange
    implements VersionChecker,
    VersionParser {
        int incstep = 4;
        int[] versions = new int[this.incstep];
        int vc = 0;

        private SingleVersionRange() {
        }

        @Override
        public boolean checkVersion(int version) {
            boolean result;
            boolean bl = result = null == this.versions;
            if (!result) {
                for (int v : this.versions) {
                    if (v != version) continue;
                    result = v == version;
                    break;
                }
            }
            return result;
        }

        @Override
        public void parseVersion(String version) {
            ++this.vc;
            this.encapcity();
            this.versions[this.vc] = VersionUtil.singleVersionStr2Int(version);
        }

        private void encapcity() {
            if (this.versions.length >= this.vc) {
                int[] nv = new int[this.vc + this.incstep];
                System.arraycopy(this.versions, 0, nv, 0, this.versions.length);
                this.versions = nv;
            }
        }

        @Override
        public boolean fit(String version) {
            boolean result;
            boolean bl = result = null != version;
            if (result) {
                result = !version.contains(TEScriptHandlerMgr.CONTINOUSVERSPLIT);
            }
            return result;
        }
    }

    private static interface VersionParser {
        public boolean fit(String var1);

        public void parseVersion(String var1);
    }

    private static interface VersionChecker {
        public boolean checkVersion(int var1);
    }

    private final class DeviceVersion {
        SingleVersionRange singlevers;
        ContinousVersion verranges;
        VersionChecker[] checkers;
        VersionParser[] parsers;

        private DeviceVersion() {
            this.singlevers = new SingleVersionRange();
            this.verranges = new ContinousVersion();
            this.checkers = new VersionChecker[]{this.singlevers, this.verranges};
            this.parsers = new VersionParser[]{this.singlevers, this.verranges};
        }

        boolean checkVersion(int version) {
            boolean result = false;
            for (VersionChecker checker : this.checkers) {
                if (null == checker || !checker.checkVersion(version)) continue;
                result = true;
                break;
            }
            return result;
        }

        void parseVersion(String version) {
            String[] vers;
            for (String ver : vers = version.split(TEScriptHandlerMgr.VER_SPLIT_STR)) {
                for (VersionParser parser : this.parsers) {
                    if (!parser.fit(ver)) continue;
                    parser.parseVersion(ver);
                    return;
                }
            }
        }
    }

    private class VersionAdapter {
        DeviceVersion version;
        String hcls;

        private VersionAdapter() {
        }

        boolean checkVersion(int ver) {
            return this.version.checkVersion(ver);
        }

        void parseVersion(String verStr) {
            if (null == this.version) {
                this.version = new DeviceVersion();
            }
            this.version.parseVersion(verStr);
        }
    }

    private class DeviceAdapter {
        int devicetype;
        String hcls;
        List<VersionAdapter> verAdapters = new ArrayList<VersionAdapter>();

        private DeviceAdapter() {
        }

        void addVersionAdapter(VersionAdapter adapter) {
            this.verAdapters.add(adapter);
        }

        boolean checkDeviceType(int type) {
            return type == this.devicetype;
        }

        String getHandlerClassName(int version) {
            String cls = this.hcls;
            if (this.verAdapters.isEmpty()) {
                return this.hcls;
            }
            for (VersionAdapter veradapter : this.verAdapters) {
                if (!veradapter.checkVersion(version)) continue;
                cls = veradapter.hcls;
                return cls;
            }
            return null;
        }
    }

    private class HandlerConf {
        int item;
        String hcls;
        List<DeviceAdapter> devAdapters = new ArrayList<DeviceAdapter>();

        private HandlerConf() {
        }

        void addDeviceAdapter(DeviceAdapter adapter) {
            this.devAdapters.add(adapter);
        }

        String getHandlerClassName(int type, int version) {
            String cls = this.hcls;
            if (this.devAdapters.isEmpty()) {
                return cls;
            }
            for (DeviceAdapter devadapter : this.devAdapters) {
                if (!devadapter.checkDeviceType(type)) continue;
                cls = devadapter.getHandlerClassName(version);
                if (cls == null) {
                    return null;
                }
                return cls;
            }
            return null;
        }
    }
}

