/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEMMLParaStruct;
import com.huawei.nglct.cbb.script.TEScriptEnumMgr;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.List;

public class TEScriptCmd {
    private int cmdCode;
    private int lineNo;
    private boolean processed;
    private List<TEMMLParaStruct> params = new ArrayList<TEMMLParaStruct>();

    public TEScriptCmd() {
    }

    public TEScriptCmd(int cmdCode, List<TEMMLParaStruct> params, int lineNo) {
        this.cmdCode = cmdCode;
        this.params.addAll(params);
        this.lineNo = lineNo;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public boolean setParaValue(String paraName, String paraValue, boolean needQuote, boolean needKeepCase) {
        if (null == paraName || "".equals(paraName)) {
            return false;
        }
        if (!(null != paraValue && "" != paraValue || needQuote)) {
            return false;
        }
        TEMMLParaStruct para = this.getMMLPara(paraName);
        if (para != null) {
            para.name = paraName;
            para.values.clear();
            if (null != paraValue && paraValue.length() > 0 && '\\' == paraValue.charAt(paraValue.length() - 1)) {
                paraValue = paraValue + "$";
            }
            if (needQuote) {
                paraValue = "\"" + paraValue + "\"";
            } else if (!needQuote && !needKeepCase) {
                paraValue = paraValue.toLowerCase();
            }
            para.values.add(paraValue);
            return true;
        }
        return this.addPara(paraName, paraValue, needQuote, needKeepCase);
    }

    public boolean addPara(String paraName, String paraValue, boolean needQuote, boolean needKeepCase) {
        if (null == paraName || "".equals(paraName)) {
            return false;
        }
        if (!(null != paraValue && "" != paraValue || needQuote)) {
            return false;
        }
        TEMMLParaStruct para = new TEMMLParaStruct();
        para.name = paraName;
        if (null != paraValue && paraValue.length() > 0 && '\\' == paraValue.charAt(paraValue.length() - 1)) {
            paraValue = paraValue + "$";
        }
        if (needQuote) {
            paraValue = "\"" + paraValue + "\"";
        } else if (!needQuote && !needKeepCase) {
            paraValue = paraValue.toLowerCase();
        }
        para.values.add(paraValue);
        this.params.add(para);
        return true;
    }

    public boolean addPara(String paraName, int paraValue, boolean hexFormat, boolean needQuote) {
        if (null == paraName || "".equals(paraName)) {
            return false;
        }
        ArrayList<String> hook = new ArrayList<String>();
        String strVal = !TEScriptEnumMgr.instance().valueI2S(hook, paraValue, this.cmdCode, paraName, 0) ? (hexFormat ? "0x" + Integer.toHexString(paraValue) : Integer.toString(paraValue)) : (String)hook.get(0);
        return this.addPara(paraName, strVal, needQuote, false);
    }

    public boolean addPara(String paraName, List<Integer> paraValue, boolean hexFormat, boolean needQuote) {
        if (null == paraName || "".equals(paraName)) {
            return false;
        }
        if (null == paraValue || paraValue.size() == 0) {
            return false;
        }
        StringBuffer buf = new StringBuffer();
        int size = paraValue.size();
        for (int i = 0; i < size; ++i) {
            ArrayList<String> hook = new ArrayList<String>();
            String strVal = !TEScriptEnumMgr.instance().valueI2S(hook, paraValue.get(i), this.cmdCode, paraName, 0) ? (hexFormat ? Integer.toHexString(paraValue.get(i)) : Integer.toString(paraValue.get(i))) : (String)hook.get(0);
            if (i != 0) {
                buf.append("&");
            }
            buf.append(strVal);
        }
        return this.addPara(paraName, buf.toString(), needQuote, false);
    }

    public boolean addPara(String paraName, List<TEScriptCmd> paraValue) {
        if (null == paraName || "".equals(paraName)) {
            return false;
        }
        if (null == paraValue || paraValue.size() == 0) {
            return false;
        }
        StringBuilder buf = new StringBuilder();
        int size = paraValue.size();
        for (int i = 0; i < size; ++i) {
            TEScriptCmd cmd = paraValue.get(i);
            if (cmd.params.isEmpty()) continue;
            StringBuilder buftemp = new StringBuilder();
            buftemp.append('{');
            int len = cmd.params.size();
            for (int j = 0; j < len; ++j) {
                TEMMLParaStruct para = cmd.params.get(j);
                if (null == para.values || para.values.isEmpty()) continue;
                buftemp.append(para.name).append('=').append(para.values.get(0)).append(',');
            }
            if (buftemp.length() > 1) {
                buf.append(buftemp.substring(0, buftemp.length() - 1));
            }
            buf.append('}');
            buf.append('&');
        }
        String strVal = "";
        if (buf.length() > 2) {
            strVal = buf.substring(0, buf.length() - 1);
        }
        return this.addPara(paraName, strVal, false, false);
    }

    public TEMMLParaStruct getMMLPara(String paraName) {
        for (int i = 0; i < this.params.size(); ++i) {
            if (!this.params.get((int)i).name.equals(paraName)) continue;
            return this.params.get(i);
        }
        return null;
    }

    public boolean getPara(String paraName, List<String> paraValue, boolean needDelete) {
        boolean finded;
        TEMMLParaStruct para = new TEMMLParaStruct();
        boolean bl = finded = this.getPara(paraName, para, needDelete) && para.values.size() == 1;
        if (finded) {
            String strVal = para.values.get(0);
            paraValue.add(TEScriptCmd.decorateStr(strVal));
        }
        return finded;
    }

    public boolean getPara(String paraName, List<String> paraValue, int needParaCount, boolean needDelete) {
        TEMMLParaStruct para = new TEMMLParaStruct();
        boolean finded = this.getPara(paraName, para, needDelete);
        if (finded && (needParaCount == 0 || needParaCount == para.values.size())) {
            int size = para.values.size();
            for (int i = 0; i < size; ++i) {
                paraValue.add(para.values.get(i));
            }
        } else {
            finded = false;
        }
        return finded;
    }

    public boolean getPara(String paraName, boolean needDelete, List<Integer> paraValue) {
        TEMMLParaStruct para = new TEMMLParaStruct();
        if (!this.getPara(paraName, para, needDelete) || para.values.size() != 1) {
            return false;
        }
        String str = TEStringUtils.trim(para.values.get(0), "\"");
        return TEScriptCmd.getIntValue(paraValue, str, this.cmdCode, paraName);
    }

    public boolean getPara(String paraName, boolean needDelete, boolean[] paraValue) {
        TEMMLParaStruct para = new TEMMLParaStruct();
        String value = null;
        if (!this.getPara(paraName, para, needDelete) || para.values.size() != 1) {
            return false;
        }
        try {
            value = para.values.get(0);
            paraValue[0] = Boolean.parseBoolean(value);
        }
        catch (RuntimeException e) {
            TELogFactory.getNormalLogger().error(String.format("Read a malformed boolean value '%s' during script importing.", value));
            return false;
        }
        return true;
    }

    public boolean getPara(String paraName, int needParaCount, boolean needDelete, List<Integer> paraValue) {
        boolean found;
        TEMMLParaStruct para = new TEMMLParaStruct();
        boolean bl = found = this.getPara(paraName, para, needDelete) && (needParaCount == 0 || needParaCount == para.values.size());
        if (found) {
            int size = para.values.size();
            for (int i = 0; i < size; ++i) {
                TEScriptCmd.getIntValue(paraValue, para.values.get(i), this.cmdCode, paraName);
            }
        }
        return found;
    }

    public boolean getPara(int index, StringBuffer paraName, StringBuffer paraValue) {
        boolean finded;
        TEMMLParaStruct para = new TEMMLParaStruct();
        boolean bl = finded = this.getPara(index, para) && 1 == para.values.size();
        if (finded) {
            paraName.append(para.name);
            paraValue.append(TEScriptCmd.decorateStr(para.values.get(0)));
        }
        return finded;
    }

    public boolean getPara(int index, StringBuffer paraName, List<String> paraValue, int paraCount) {
        TEMMLParaStruct para = new TEMMLParaStruct();
        boolean finded = this.getPara(index, para);
        if (finded) {
            if (paraCount != 0 && paraCount != para.values.size()) {
                return false;
            }
            paraValue.clear();
            paraName.append(para.name);
            int size = para.values.size();
            for (int i = 0; i < size; ++i) {
                paraValue.add(para.values.get(i));
            }
        }
        return finded;
    }

    public boolean getPara(int index, StringBuffer paraName, List<Integer> paraValue) {
        TEMMLParaStruct para = new TEMMLParaStruct();
        if (!this.getPara(index, para) || 1 != para.values.size()) {
            return false;
        }
        paraName.append(para.name);
        return TEScriptCmd.getIntValue(paraValue, para.values.get(0), this.cmdCode, paraName.toString());
    }

    public boolean getPara(int index, StringBuffer paraName, int needParaCount, List<Integer> paraValue) {
        TEMMLParaStruct para = new TEMMLParaStruct();
        boolean finded = this.getPara(index, para);
        if (finded) {
            if (needParaCount != 0 && needParaCount != para.values.size()) {
                return false;
            }
            paraValue.clear();
            paraName.append(para.name);
            int size = para.values.size();
            for (int i = 0; i < size; ++i) {
                TEScriptCmd.getIntValue(paraValue, para.values.get(i), this.cmdCode, paraName.toString());
            }
        }
        return finded;
    }

    public boolean getPara(String paraName, TEMMLParaStruct para, boolean needDelete) {
        boolean finded = false;
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            TEMMLParaStruct tmpPara = this.params.get(i);
            if (!paraName.equalsIgnoreCase(tmpPara.name)) continue;
            para.name = tmpPara.name;
            para.values.addAll(tmpPara.values);
            if (needDelete) {
                this.params.remove(i);
            }
            finded = true;
            break;
        }
        return finded;
    }

    public boolean getPara(int index, TEMMLParaStruct para) {
        if (index >= this.params.size()) {
            return false;
        }
        TEMMLParaStruct tmpPara = this.params.get(index);
        para.name = tmpPara.name;
        para.values.addAll(tmpPara.values);
        return true;
    }

    public int getSize() {
        return this.params.size();
    }

    public int getCmdCode() {
        return this.cmdCode;
    }

    public void setCmdCode(int cmdCode) {
        this.cmdCode = cmdCode;
    }

    public void deleteAllPara() {
        this.params.clear();
    }

    private static boolean getIntValue(List<Integer> intValue, String strValue, int cmdCode, String name) {
        try {
            intValue.add(Integer.parseInt(TEScriptCmd.decorateStr(strValue)));
            return true;
        }
        catch (NumberFormatException e) {
            ArrayList<Integer> hook = new ArrayList<Integer>();
            boolean isEnum = TEScriptEnumMgr.instance().valueS2I(hook, strValue, cmdCode, name, 0);
            if (isEnum) {
                intValue.add((Integer)hook.get(0));
            }
            return isEnum;
        }
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    protected static String decorateStr(String strVal) {
        if (strVal.length() > 1 && strVal.charAt(strVal.length() - 1) == '$' && strVal.charAt(strVal.length() - 2) == '\\') {
            strVal = strVal.substring(0, strVal.length() - 1);
        }
        if (strVal.startsWith("\"")) {
            strVal = strVal.substring(1);
        }
        if (strVal.endsWith("\"")) {
            strVal = strVal.substring(0, strVal.length() - 1);
        }
        return strVal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cmdCode;
        result = 31 * result + this.lineNo;
        result = 31 * result + (this.params == null ? 0 : ((Object)this.params).hashCode());
        result = 31 * result + (this.processed ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TEScriptCmd)) {
            return false;
        }
        TEScriptCmd other = (TEScriptCmd)obj;
        if (this.cmdCode != other.cmdCode) {
            return false;
        }
        if (this.lineNo != other.lineNo) {
            return false;
        }
        if (this.params == null ? other.params != null : !((Object)this.params).equals(other.params)) {
            return false;
        }
        return this.processed == other.processed;
    }

    public String toString() {
        return "TEScriptCmd [cmdCode=" + this.cmdCode + ", lineNo=" + this.lineNo + ", processed=" + this.processed + ", params=" + this.params + "]";
    }
}

