/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptDataConstants;
import com.huawei.nglct.core.communication.DebugTracer;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.neproxy.TEProcID;
import com.huawei.nglct.core.startup.SystemConfiguration;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnNullReq;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.f_interface.asnscript.AsnGetProcIPRsp;
import com.huawei.nglct.nemgr.f_interface.asnscript.AsnGetRemoteFileReq;
import com.huawei.nglct.nemgr.f_interface.asnscript.AsnGetRemoteFileRsp;
import com.huawei.nglct.nemgr.f_interface.asnscript.AsnSendRemoteFileReq;
import com.huawei.nglct.nemgr.f_interface.asnscript.AsnSendRemoteFileRsp;
import com.huawei.nglct.util.io.IOStreamConvertor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;

public class TEImapAppFile {
    private FileHandle fileHandle;
    private int result;
    private FileInfo fileInfo;
    private int userID;

    public TEImapAppFile(int userID) {
        this.userID = userID;
        this.init();
    }

    public TEImapAppFile(String strFilePath, TEScriptDataConstants.FILE_OPERATION_TYPE openOper, TEScriptDataConstants.FILE_OPEN_MODE openMode, TEProcID procID) {
        this.init();
        this.open(strFilePath, openOper, openMode, procID);
    }

    public boolean writeString(String content) {
        if (this.fileHandle == null || this.fileHandle.writeHandle == null) {
            return false;
        }
        if (content == null || "".equals(content)) {
            return false;
        }
        try {
            this.fileHandle.writeHandle.write(content);
            this.fileHandle.writeHandle.flush();
        }
        catch (IOException e) {
            DebugTracer.trace("Write string into script file failed!");
            TELogFactory.getNormalLogger().error("TEImapAppFile.writeString() fail!", (Throwable)e);
            return false;
        }
        return true;
    }

    public int getResult() {
        return this.result;
    }

    public FileHandle getFileHandle() {
        return this.fileHandle;
    }

    public int close() {
        int errCode = 0;
        if (this.fileInfo.strFilePath == null || "".equals(this.fileInfo.strFilePath)) {
            return errCode;
        }
        if (this.fileHandle != null && this.fileHandle.readHandle != null) {
            try {
                this.fileHandle.readHandle.close();
            }
            catch (IOException e) {
                DebugTracer.trace("Close file reader failed.");
            }
        }
        if (this.fileHandle != null && this.fileHandle.writeHandle != null) {
            try {
                this.fileHandle.writeHandle.close();
            }
            catch (IOException e) {
                DebugTracer.trace("Close file reader failed.");
            }
        }
        if (!this.fileInfo.isLocalOperate) {
            if (this.fileInfo.openOper == TEScriptDataConstants.FILE_OPERATION_TYPE.OPERATE_READ_WRITE || this.fileInfo.openOper == TEScriptDataConstants.FILE_OPERATION_TYPE.OPERATE_APPEND) {
                errCode = this.sendRemoteFile(this.fileInfo.strFilePath, this.fileInfo.procID);
            } else if (this.fileInfo.openOper == TEScriptDataConstants.FILE_OPERATION_TYPE.OPERATE_ONLY_READ) {
                errCode = this.deleteLocalFile(this.fileInfo.strFilePath);
            }
        }
        return errCode;
    }

    protected void init() {
        this.fileHandle = null;
        this.result = 0;
        this.fileInfo = new FileInfo();
        this.fileInfo.init();
    }

    protected void open(String strFilePath, TEScriptDataConstants.FILE_OPERATION_TYPE openOper, TEScriptDataConstants.FILE_OPEN_MODE openMode, TEProcID procID) {
        if (this.fileInfo.strFilePath != null && !this.fileInfo.strFilePath.equals("")) {
            DebugTracer.trace("ImapAppFile::file has be opened...");
            this.result = 1090646024;
            return;
        }
        this.fileInfo.setData(strFilePath, openOper, openMode, procID, this.isLocalOperate(procID));
        if (this.fileInfo.isLocalOperate || TEScriptDataConstants.FILE_OPERATION_TYPE.OPERATE_READ_WRITE == this.fileInfo.openOper) {
            this.result = this.openLocalFile(strFilePath, openOper, openMode);
        } else {
            this.result = this.getRemoteFile(strFilePath, procID);
            if (0 == this.result) {
                this.result = this.openLocalFile(strFilePath, openOper, openMode);
            }
        }
    }

    protected boolean isLocalOperate(TEProcID procID) {
        TEProcID localProcID = new TEProcID(SystemConfiguration.getProcID(), SystemConfiguration.getProcHandler());
        if (localProcID.equals((Object)procID)) {
            return true;
        }
        AsnNullReq req = new AsnNullReq();
        req.userID = BigInteger.valueOf(this.userID).intValue();
        AsnGetProcIPRsp rsp = new AsnGetProcIPRsp();
        int sended = TEASN1CommMgr.sendCommand(procID, (FStruct)req, (FStruct)rsp, 2171627);
        if (sended == 0 && rsp.result == 0) {
            String myIP = new String(rsp.ipAddress);
            String[] ips = IOStreamConvertor.getWebServerIPs();
            for (int i = 0; i < ips.length; ++i) {
                if (!ips[i].equals(myIP)) continue;
                return true;
            }
        }
        return false;
    }

    protected int openLocalFile(String strFilePath, TEScriptDataConstants.FILE_OPERATION_TYPE openOper, TEScriptDataConstants.FILE_OPEN_MODE openMode) {
        if (openMode == TEScriptDataConstants.FILE_OPEN_MODE.OPEN_WITH_FILE_HANDLE) {
            File folder;
            this.fileHandle = null;
            boolean isWriteOperate = false;
            switch (openOper) {
                case OPERATE_ONLY_READ: 
                case OPERATE_ONLY_READ_BINARY: {
                    break;
                }
                case OPERATE_READ_WRITE: 
                case OPERATE_READ_WRITE_BINARY: 
                case OPERATE_APPEND: 
                case OPERATE_APPEND_BINARY: {
                    isWriteOperate = true;
                    break;
                }
                default: {
                    return 1090646024;
                }
            }
            if (isWriteOperate && !(folder = new File(this.getParentPath(strFilePath))).exists() && !folder.mkdirs()) {
                return 1090646024;
            }
            if (this.createHandle(strFilePath, isWriteOperate) == -1) {
                return 1090646024;
            }
        } else {
            return 1090646024;
        }
        return 0;
    }

    protected String getParentPath(String strPath) {
        StringBuffer tmpBuf = new StringBuffer(strPath);
        if (0 != this.convertAbsolutePath(tmpBuf)) {
            return "";
        }
        int nPosSep = tmpBuf.lastIndexOf("/");
        if (nPosSep == tmpBuf.length() - 1) {
            tmpBuf.delete(nPosSep, nPosSep + 1);
        }
        if (-1 == (nPosSep = tmpBuf.lastIndexOf("/"))) {
            return SystemConfiguration.getIMapRootPath() + "server/script/tmp";
        }
        tmpBuf.delete(nPosSep + 1, tmpBuf.length());
        return tmpBuf.toString();
    }

    protected int convertAbsolutePath(StringBuffer strPath) {
        String tmpStr = this.convertPathtoUnixMode(strPath.toString());
        strPath.setLength(0);
        strPath.append(tmpStr);
        if (strPath.capacity() == 0) {
            return -1;
        }
        if ('.' == strPath.charAt(0)) {
            return -1;
        }
        int pos = -1;
        while (-1 != (pos = strPath.lastIndexOf("/../"))) {
            tmpStr = strPath.substring(0, pos);
            int posParent = tmpStr.lastIndexOf(47);
            if (posParent == -1) {
                return -1;
            }
            strPath.delete(posParent, pos + 3);
        }
        while (-1 != (pos = strPath.indexOf("/./"))) {
            strPath.delete(pos, pos + 2);
        }
        return 0;
    }

    String convertPathtoUnixMode(String strPath) {
        if ((strPath = strPath.trim()).length() == 0) {
            strPath = "";
            return strPath;
        }
        strPath.replaceAll("\\\\", "/");
        return strPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRemoteFile(String strFilePath, TEProcID procID) {
        AsnGetRemoteFileReq req = new AsnGetRemoteFileReq();
        AsnGetRemoteFileRsp rsp = new AsnGetRemoteFileRsp();
        req.filePath = strFilePath.getBytes();
        int errCode = TEASN1CommMgr.sendCommand(procID, (FStruct)req, (FStruct)rsp, 2171623);
        if (0 != errCode) {
            return errCode;
        }
        if (rsp.result != null && !rsp.result.isSuccess) {
            return rsp.result.getRetCode();
        }
        String zipFilePath = strFilePath + ".gz";
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(zipFilePath);
            out.write(rsp.fileContent);
        }
        catch (Exception e) {
            int n = 1090646024;
            return n;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("TEImapAppFile.getRemoteFile() close fail!", (Throwable)e);
                }
            }
        }
        String osName = System.getProperty("os.name").toLowerCase();
        String gzipCmd = osName.indexOf("windows") != -1 ? SystemConfiguration.getIMapRootPath() + File.separator + "/server/bin/gzip -d -q -N " : "gzip -d -q -N ";
        gzipCmd = gzipCmd + zipFilePath;
        try {
            Process process = Runtime.getRuntime().exec(gzipCmd);
            process.waitFor();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEImapAppFile.getRemoteFile() waitFor fail!", (Throwable)e);
        }
        return 0;
    }

    private int createHandle(String filePath, boolean isWriteOperate) {
        File file = new File(filePath);
        try {
            if (!isWriteOperate) {
                if (!file.exists()) {
                    return -1;
                }
            } else if (file.exists()) {
                file.delete();
                file.createNewFile();
            }
            this.fileHandle = new FileHandle(file, isWriteOperate);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEImapAppFile.createHandle() fail!", (Throwable)e);
            return -1;
        }
        return 0;
    }

    protected String relatPathToAbsPath(String relatPath) {
        return this.getParentPath(relatPath);
    }

    protected int sendRemoteFile(String strFilePath, TEProcID procID) {
        ByteArrayOutputStream buf;
        AsnSendRemoteFileRsp rsp;
        AsnSendRemoteFileReq req;
        String zipFilePath;
        int errCode = 0;
        String zipCmd = SystemConfiguration.getIMapRootPath() + "/server/bin/gzip -f -q -N " + strFilePath;
        try {
            Process process = Runtime.getRuntime().exec(zipCmd);
            process.waitFor();
            zipFilePath = strFilePath + ".gz";
            FileInputStream in = null;
            in = new FileInputStream(zipFilePath);
            req = new AsnSendRemoteFileReq();
            rsp = new AsnSendRemoteFileRsp();
            byte[] bytes = new byte[4096];
            int leng = 0;
            buf = new ByteArrayOutputStream();
            while ((leng = ((InputStream)in).read(bytes)) > 0) {
                buf.write(bytes, 0, leng);
            }
            ((InputStream)in).close();
        }
        catch (Exception e) {
            return 1090646024;
        }
        File file = new File(zipFilePath);
        file.delete();
        req.filePath = strFilePath.getBytes();
        req.fileContent = buf.toByteArray();
        try {
            buf.close();
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TEImapAppFile.sendRemoteFile() close fail!", (Throwable)e);
        }
        errCode = TEASN1CommMgr.sendCommand(procID, (FStruct)req, (FStruct)rsp, 2171624);
        if (errCode == 0) {
            return this.getErrCodeFromAsnRspRslt(rsp.result);
        }
        return errCode;
    }

    protected String relatPathConvToAbsPath(String relatPath) {
        return this.getParentPath(SystemConfiguration.getIMapRootPath()) + relatPath;
    }

    protected int getErrCodeFromAsnRspRslt(AsnSingleReturn result) {
        if (result != null && !result.isSuccess && result.getRetCode() != 0) {
            return result.getRetCode();
        }
        return 0;
    }

    public int deleteLocalFile(String strFilePath) {
        String delFilePatch = this.relatPathConvToAbsPath(strFilePath);
        File file = new File(delFilePatch);
        if (!file.exists()) {
            return -1;
        }
        file.delete();
        return 0;
    }

    protected class FileInfo {
        public String strFilePath;
        public TEScriptDataConstants.FILE_OPERATION_TYPE openOper;
        public TEScriptDataConstants.FILE_OPEN_MODE openMode;
        public TEProcID procID;
        public boolean isLocalOperate;

        protected FileInfo() {
        }

        protected void init() {
            this.strFilePath = "";
            this.openOper = TEScriptDataConstants.FILE_OPERATION_TYPE.OPERATE_ONLY_READ;
            this.openMode = TEScriptDataConstants.FILE_OPEN_MODE.OPEN_WITH_STREAM;
            this.isLocalOperate = true;
        }

        protected void setData(String strFilePath, TEScriptDataConstants.FILE_OPERATION_TYPE openOper, TEScriptDataConstants.FILE_OPEN_MODE openMode, TEProcID procID, boolean isLocalOperate) {
            this.strFilePath = strFilePath;
            this.openOper = openOper;
            this.openMode = openMode;
            this.procID = procID;
            this.isLocalOperate = isLocalOperate;
        }
    }

    public static class FileHandle {
        public String filePath;
        public File file;
        public FileReader readHandle;
        public FileWriter writeHandle;
        public boolean isWriteOperate;

        public FileHandle(String filePath, boolean isWriteOperate) {
            this.filePath = filePath;
            this.isWriteOperate = isWriteOperate;
            this.file = new File(filePath);
            this.openFile(isWriteOperate);
        }

        public FileHandle(File file, boolean isWriteOperate) {
            this.file = file;
            this.isWriteOperate = isWriteOperate;
            this.openFile(isWriteOperate);
        }

        protected void openFile(boolean isWriteOperate) {
            try {
                if (isWriteOperate) {
                    this.writeHandle = new FileWriter(this.file);
                } else {
                    this.readHandle = new FileReader(this.file);
                }
            }
            catch (FileNotFoundException e) {
                TELogFactory.getNormalLogger().error("TEImapAppFile.openFile() FileNotFoundException!", (Throwable)e);
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("TEImapAppFile.openFile() IOException!", (Throwable)e);
            }
        }

        public void reOpen() {
            if (this.isWriteOperate) {
                this.reOpenWriter();
            } else {
                this.reOpenReader();
            }
        }

        public void reOpenReader() {
            try {
                this.readHandle.close();
                this.readHandle = this.filePath == null ? new FileReader(this.file) : new FileReader(this.filePath);
            }
            catch (FileNotFoundException e) {
                TELogFactory.getNormalLogger().error("TEImapAppFile.openFile() IOException!", (Throwable)e);
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("TEImapAppFile.openFile() IOException!", (Throwable)e);
            }
        }

        public void reOpenWriter() {
            try {
                this.writeHandle.close();
                this.writeHandle = this.filePath == null ? new FileWriter(this.filePath) : new FileWriter(this.file);
            }
            catch (FileNotFoundException e) {
                TELogFactory.getNormalLogger().error("TEImapAppFile.reOpenWriter() IOException!", (Throwable)e);
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("TEImapAppFile.reOpenWriter() IOException!", (Throwable)e);
            }
        }
    }
}

