/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.script;

import com.huawei.nglct.cbb.script.TEBDName;
import com.huawei.nglct.cbb.script.TEDataMapKey;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.system.TESystemUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEDataMapXMLParser {
    public static String SCRIPT_ENUM_FILE_NAME = TESystemUtil.getIMAPPath() + "/../core/conf/xml/script/datamap.xml";
    public Map<TEDataMapKey, List<TEBDName>> dataMap = new HashMap<TEDataMapKey, List<TEBDName>>();

    public void connect(Map<TEDataMapKey, List<TEBDName>> dataMap) {
        this.dataMap = dataMap;
    }

    public void parse() {
        Document doc = TEParseXMLFile.parseFile(SCRIPT_ENUM_FILE_NAME);
        if (null == doc) {
            return;
        }
        NodeList cmds = doc.getElementsByTagName("Cmd");
        if (cmds == null || cmds.getLength() == 0) {
            return;
        }
        for (int i = 0; i < cmds.getLength(); ++i) {
            Element cmd = (Element)cmds.item(i);
            NodeList devs = cmd.getElementsByTagName("Devicetype");
            if (devs == null || devs.getLength() == 0) continue;
            int leng = devs.getLength();
            for (int j = 0; j < leng; ++j) {
                Node type;
                Element dev = (Element)devs.item(j);
                TEDataMapKey key = new TEDataMapKey();
                NamedNodeMap attrs = dev.getAttributes();
                Node num = attrs.getNamedItem("num");
                if (num != null) {
                    key.deviceID = Integer.parseInt(num.getNodeValue().trim());
                }
                if ((type = attrs.getNamedItem("type")) != null) {
                    key.cmdName = cmd.getNodeValue().trim();
                }
                ArrayList<TEBDName> value = new ArrayList<TEBDName>();
                this.dataMap.put(key, value);
                NodeList boards = dev.getElementsByTagName("Board");
                int kLeng = boards.getLength();
                for (int k = 0; k < kLeng; ++k) {
                    Node board = boards.item(k);
                    attrs = board.getAttributes();
                    TEBDName bdName = new TEBDName();
                    bdName.v1name = attrs.getNamedItem("v1name") == null ? "" : attrs.getNamedItem("v1name").getNodeValue();
                    bdName.v2name = attrs.getNamedItem("v2name") == null ? "" : attrs.getNamedItem("v2name").getNodeValue();
                    value.add(bdName);
                }
            }
        }
    }
}

