/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.pnp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;

public class TEPNPBundleLoadMgr {
    private Logger logger = TELogFactory.getNormalLogger();
    private static final String NEMGR_DIRNAME = "/nemgr";
    private static final String NE_STATICDATA_FLIENAME = "dev_staticdata.xml";
    private static final String CORE_DIRNAME = "/core";
    private static final String BOARD_FILE_REG = "^BDTYPE_.*\\.xml$";
    private static TEPNPBundleLoadMgr instance = null;

    public static synchronized TEPNPBundleLoadMgr getInstance() {
        if (null == instance) {
            instance = new TEPNPBundleLoadMgr();
        }
        return instance;
    }

    public void reloadAllPNPFile() {
        this.logger.info("TEPNPBundleLoadMgr.reloadAllPNPFile start");
        Bundle pnpBundle = TERWCfgFile.getBundleBySymbolicName("com.huawei.weblct.pnp");
        this.loadNEPNPFile(pnpBundle);
        this.loadBoardPNPFile(pnpBundle);
        this.logger.info("TEPNPBundleLoadMgr.reloadAllPNPFile end");
    }

    protected void loadNEPNPFile(Bundle pnpBundle) {
        int i;
        if (null == pnpBundle) {
            return;
        }
        this.logger.info("TEPNPBundleLoadMgr.loadNEPNPFile starting.");
        List<String> nemgrList = this.getFileList(pnpBundle, NEMGR_DIRNAME);
        String realBase = this.getRealBase(pnpBundle, NEMGR_DIRNAME);
        File file = null;
        ArrayList<String> pnpFile = new ArrayList<String>();
        TEResourceManager.clearPNPfileList();
        int len = nemgrList.size();
        for (i = 0; i < len; ++i) {
            file = new File(this.getRelativePath(realBase, nemgrList.get(i)));
            String filePathTmp = file.getPath();
            String filePath = filePathTmp.replace('\\', '/');
            int hash = TEStringUtils.hashString(filePath);
            TEResourceManager.addPNPfileList(hash);
            if (file.getName().equals(NE_STATICDATA_FLIENAME)) {
                pnpFile.add(filePath);
                continue;
            }
            if (!this.isFunctionOrQxFile(file.getName())) continue;
            TECreateObjectFactory.clearFuncDesFile(filePathTmp);
        }
        len = pnpFile.size();
        for (i = 0; i < len; ++i) {
            SDXMLInterpreterMgr.getInstance().parseXMLFile((String)pnpFile.get(i));
        }
        this.logger.info("TEPNPBundleLoadMgr.loadNEPNPFile finish.");
    }

    protected void loadBoardPNPFile(Bundle pnpBundle) {
        if (null == pnpBundle) {
            return;
        }
        this.logger.info("TEPNPBundleLoadMgr.loadBoardPNPFile starting.");
        List<String> coreList = this.getFileList(pnpBundle, CORE_DIRNAME);
        String realBase = this.getRealBase(pnpBundle, CORE_DIRNAME);
        File file = null;
        int len = coreList.size();
        for (int i = 0; i < len; ++i) {
            file = new File(this.getRelativePath(realBase, coreList.get(i)));
            String filePath = file.getPath().replace('\\', '/');
            int hash = TEStringUtils.hashString(filePath);
            TEResourceManager.addPNPfileList(hash);
            if (!file.getName().matches(BOARD_FILE_REG)) continue;
            SDXMLInterpreterMgr.getInstance().parseXMLFile(filePath);
        }
        this.logger.info("TEPNPBundleLoadMgr.loadBoardPNPFile finish.");
    }

    protected boolean isFunctionOrQxFile(String fileName) {
        return "functiondescrib.xml".equalsIgnoreCase(fileName) || "qxdescrib.xml".equals(fileName);
    }

    protected void getFileList(File file, List<String> fileLists) {
        if (file.isFile()) {
            fileLists.add(file.getAbsolutePath());
        } else {
            File[] subs;
            for (File sub : subs = file.listFiles()) {
                this.getFileList(sub, fileLists);
            }
        }
    }

    protected String getRealBase(Bundle bundle, String dirname) {
        String realBase = "";
        try {
            URL base = bundle.getResource(dirname);
            realBase = FileLocator.toFileURL((URL)base).getPath();
            File baseDir = new File(realBase);
            baseDir = new File(baseDir.getParent());
            realBase = baseDir.getAbsolutePath();
        }
        catch (Exception ex) {
            this.logger.error("getRealBase fail!", (Throwable)ex);
        }
        return realBase;
    }

    protected List<String> getFileList(Bundle bundle, String dirname) {
        ArrayList<String> fileLists = new ArrayList<String>();
        try {
            File[] subs;
            URL base = bundle.getResource(dirname);
            String realBase = FileLocator.toFileURL((URL)base).getPath();
            File baseDir = new File(realBase);
            realBase = baseDir.getAbsolutePath();
            for (File sub : subs = baseDir.listFiles()) {
                if (sub.isFile()) continue;
                this.getFileList(sub, fileLists);
            }
        }
        catch (Exception ex) {
            this.logger.error("getFileList fail!", (Throwable)ex);
        }
        return fileLists;
    }

    protected String getRelativePath(String basePath, String absPath) {
        if (absPath == null || "".equals(absPath)) {
            return null;
        }
        if (absPath.length() <= basePath.length()) {
            return "";
        }
        return absPath.substring(basePath.length());
    }
}

