/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.pnp;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.datamanage.integration.TEInteDataCfgMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.pnp.TEPNPBundleLoadMgr;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.nelist.TENEListInit;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEPathIDConverDescription;
import com.huawei.nglct.nelist.model.datamgr.TEBoardSpecialAttrDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TENESpecialAttrDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.pnp.boardmgr.TEPNPBDCfgDataMgr;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;

public class TENEPNPMgr {
    private static TENEPNPMgr instance = null;
    private Set<String> neFileList = new HashSet<String>();
    private Set<String> boardFileList = new HashSet<String>();
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    private TENEPNPMgr() {
        this.neFileList.add("core/conf/xml/model/ne.xml");
    }

    public static synchronized TENEPNPMgr getInstance() {
        if (null == instance) {
            instance = new TENEPNPMgr();
        }
        return instance;
    }

    private void clearAllData() {
        TEBoardSpecialAttrDataMgr.getInstance().clear();
        TENESpecialAttrDataMgr.getInstance().clear();
        TEGnlAttrMgr.getInstance().clear();
        TECircuitPackDescription.getInstance().clear();
        TEGetNEDomainVersion.getInstance().clear();
        TEEquipmentDescription.getInstance().clear();
        TEInteDataCfgMgr.getInstance().clear();
        TEPathIDConverDescription.getInstance().clear();
        TEAlarmDataMgr.getInstance().clear();
        TEGenCfgDataMgr.getInstance().clear();
        TEPNPBDCfgDataMgr.getInstance().clear();
        SDXMLInterpreterMgr.getInstance().clearLoadedFileList();
    }

    public void addNEFile(String file) {
        this.neFileList.add(file);
    }

    public void addBoardFile(String file) {
        this.boardFileList.add(file);
    }

    public void reload() {
        normalLogger.info("TENEPNPMgr Reload: begin!");
        this.clearAllData();
        normalLogger.info("TENEPNPMgr clearAllData end!");
        TEGnlAttrMgr.getInstance().initialize();
        normalLogger.info("TENEPNPMgr TEGnlAttrMgr.getInstance.initialize end!");
        TEPNPBundleLoadMgr.getInstance().reloadAllPNPFile();
        normalLogger.info("TENEPNPMgr PNPBundleReload end!");
        Iterator<String> iterator = this.boardFileList.iterator();
        while (iterator.hasNext()) {
            SDXMLInterpreterMgr.getInstance().parseXMLFile(iterator.next());
        }
        normalLogger.info("TENEPNPMgr boardFileList end!boardFileList size:" + this.boardFileList.size());
        iterator = this.neFileList.iterator();
        while (iterator.hasNext()) {
            SDXMLInterpreterMgr.getInstance().parseXMLFile(iterator.next());
        }
        normalLogger.info("TENEPNPMgr neFileList end!neFileList size:" + this.neFileList.size());
        TENEListMgr.getInstance().refreshInterNE();
        normalLogger.info("TENEPNPMgr refreshInterNE end!");
        TENEListInit.getInstance().loginNEOnI("");
        normalLogger.info("TENEPNPMgr Reload: end!");
    }
}

