/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.objselect;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.objselect.TEDevInfo;
import com.huawei.nglct.cbb.objselect.TEDevVA;
import com.huawei.nglct.cbb.objselect.TEFuncRecord;
import com.huawei.nglct.cbb.objselect.TEImplRecord;
import com.huawei.nglct.cbb.objselect.TEVACurState;
import com.huawei.nglct.cbb.objselect.TEVerAdapterInfo;
import com.huawei.nglct.cbb.objselect.TEVerInfo;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.system.TESystemUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEVAXMLParser {
    public static final int MAX_NE_VER_SIZE = 4;
    public static final int BIT_OF_BYTE = 8;
    public static final String BOARD_TYPE = "bdType";
    public static final String OBJ_SEL_IMPL = "objsel_impl";
    public static final String NE_CONFIG_STATE = "neConfigState";
    public static final String NE_VERSION = "neVersion";
    public static final String NAME = "name";
    public static final String NE_TYPE = "neType";
    public static final String SEPERATOR = ".";
    public static final String NULL_IP = "0.0.0.0";
    public static final String NULL_STRING = "";
    private TEVerAdapterInfo verAdapterInfo;
    private TEVACurState vaCurState;

    public TEVAXMLParser(TEVerAdapterInfo verAdapterInfo, TEVACurState vaCurState) {
        this.verAdapterInfo = verAdapterInfo;
        this.vaCurState = vaCurState;
    }

    protected boolean parseFile(String fileName) {
        if (!this.verAdapterInfo.getInitResult()) {
            return false;
        }
        Document doc = TEParseXMLFile.parseFile(fileName);
        if (doc == null) {
            return false;
        }
        NodeList nodes = doc.getChildNodes();
        if (nodes != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                if ("root".equals(element.getNodeName())) {
                    NodeList subElements = element.getChildNodes();
                    if (subElements == null) continue;
                    for (int j = 0; j < subElements.getLength(); ++j) {
                        if (!"include".equals(subElements.item(j).getNodeName())) continue;
                        String itemFile = ((Element)subElements.item(j)).getAttribute("file");
                        itemFile = TESystemUtil.getIMAPPath() + "../" + itemFile;
                        TEVerAdapterInfo.parseVAXMLFile(itemFile, this.verAdapterInfo, this.vaCurState);
                    }
                    continue;
                }
                this.parseNode(element);
            }
        }
        return this.verAdapterInfo.getInitResult();
    }

    protected boolean parseNode(Node element) {
        NodeList nodes;
        if (element == null) {
            return true;
        }
        Map<String, Integer> funcIDMap = this.verAdapterInfo.getFuncIDMap();
        Map<TEDevInfo, TEDevVA> devVAMap = this.verAdapterInfo.getDevVAMap();
        if ("funcid_def".equals(element.getNodeName())) {
            NamedNodeMap attrs = element.getAttributes();
            if (attrs != null) {
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Attr attr = (Attr)attrs.item(j);
                    funcIDMap.put(attr.getName(), Integer.parseInt(attr.getValue()));
                }
            }
        } else if ("device".equals(element.getNodeName())) {
            if (!this.parseDevice(element.getAttributes())) {
                return false;
            }
        } else if ("function".equals(element.getNodeName())) {
            TEDevVA devVA = devVAMap.get(this.vaCurState.curDevInfo);
            if (devVA == null) {
                devVA = new TEDevVA();
                devVAMap.put((TEDevInfo)this.vaCurState.curDevInfo.clone(), devVA);
            }
            Map<Integer, TEFuncRecord> funcMap = devVA.getFuncMap();
            if (!this.parseFunction(element.getAttributes(), funcMap)) {
                return false;
            }
        } else if ("objsel_if".equals(element.getNodeName()) || "mgr_if".equals(element.getNodeName()) || "datamanage_if".equals(element.getNodeName()) || "script_if".equals(element.getNodeName()) || "interface".equals(element.getNodeName()) ? !this.parseIF(element, devVAMap) : ("implement".equals(element.getNodeName()) ? !this.parseImplement(element, devVAMap) : ("not_supported_by".equals(element.getNodeName()) ? !this.parseNotSupportedBy(element, devVAMap) : "supported_by".equals(element.getNodeName()) && !this.parseSupportedBy(element, devVAMap)))) {
            return false;
        }
        if ((nodes = element.getChildNodes()) != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (this.parseNode(nodes.item(i))) continue;
                return false;
            }
        }
        if ("device".equals(element.getNodeName())) {
            this.vaCurState.curDevInfo.neType = -1;
        } else if ("function".equals(element.getNodeName())) {
            Map<Integer, TEFuncRecord> funcMap = devVAMap.get(this.vaCurState.curDevInfo).getFuncMap();
            TEFuncRecord funcRecord = funcMap.get(this.vaCurState.curFuncID);
            if (!this.vaCurState.curFuncHasSupportRecord) {
                TEVerInfo verInfo = new TEVerInfo();
                verInfo.minNEVer = this.vaCurState.curDevInfo.minNEVer;
                verInfo.maxNEVer = this.vaCurState.curDevInfo.maxNEVer;
                verInfo.neConfigState = 0;
                funcRecord.supportVerInfos.add(verInfo);
            }
            this.vaCurState.curFuncID = 0;
            this.vaCurState.curFuncHasSupportRecord = false;
        } else if ("objsel_if".equals(element.getNodeName()) || "mgr_if".equals(element.getNodeName()) || "datamanage_if".equals(element.getNodeName()) || "script_if".equals(element.getNodeName()) || "interface".equals(element.getNodeName())) {
            this.vaCurState.curIFName = NULL_STRING;
        } else if ("implement".equals(element.getNodeName())) {
            Map<String, List<TEImplRecord>> interfaceMap = devVAMap.get(this.vaCurState.curDevInfo).getInterfaceMap();
            List<TEImplRecord> implRecords = interfaceMap.get(this.vaCurState.curIFName);
            for (TEImplRecord implRecord : implRecords) {
                if (!this.vaCurState.curImplName.equals(implRecord.implClassName) || this.vaCurState.curImplHasSupportRecord) continue;
                TEVerInfo verInfo = new TEVerInfo();
                verInfo.minNEVer = this.vaCurState.curDevInfo.minNEVer;
                verInfo.maxNEVer = this.vaCurState.curDevInfo.maxNEVer;
                verInfo.neConfigState = 0;
                implRecord.implVerInfos.add(verInfo);
            }
            this.vaCurState.curImplName = NULL_STRING;
            this.vaCurState.curImplHasSupportRecord = false;
        }
        return true;
    }

    protected boolean parseDevice(NamedNodeMap attrs) {
        ArrayList<Integer> minBuf = new ArrayList<Integer>(1);
        ArrayList<Integer> maxBuf = new ArrayList<Integer>(1);
        this.convertNEVerRange(attrs, NE_VERSION, minBuf, maxBuf);
        this.vaCurState.curDevInfo.minNEVer = (Integer)minBuf.get(0);
        this.vaCurState.curDevInfo.maxNEVer = (Integer)maxBuf.get(0);
        ArrayList<Integer> neType = new ArrayList<Integer>(1);
        if (this.vaCurState.curDevInfo.minNEVer == 0 || this.vaCurState.curDevInfo.maxNEVer == 0 || this.vaCurState.curDevInfo.minNEVer > this.vaCurState.curDevInfo.maxNEVer || !this.convertNEType(attrs, neType)) {
            this.verAdapterInfo.setInitResult(false);
            return false;
        }
        this.vaCurState.curDevInfo.neType = (Integer)neType.get(0);
        return true;
    }

    protected boolean parseFunction(NamedNodeMap attrs, Map<Integer, TEFuncRecord> funcMap) {
        if (this.vaCurState.curDevInfo.neType == -1) {
            TELogFactory.getNormalLogger().error("A <function> tag must be included in a <device> tag!\n");
            this.verAdapterInfo.setInitResult(false);
            return false;
        }
        ArrayList<Integer> funcid = new ArrayList<Integer>(1);
        if (!this.convertFuncID(attrs, funcid)) {
            this.verAdapterInfo.setInitResult(false);
            return false;
        }
        this.vaCurState.curFuncID = (Integer)funcid.get(0);
        this.vaCurState.curFuncHasSupportRecord = false;
        if (funcMap.get(this.vaCurState.curFuncID) == null) {
            TEFuncRecord nullFuncRecord = new TEFuncRecord();
            funcMap.put(this.vaCurState.curFuncID, nullFuncRecord);
        }
        return true;
    }

    protected void convertNEVerRange(NamedNodeMap attrs, String attrName, List<Integer> arg3, List<Integer> arg4) {
        StringBuffer minVer = new StringBuffer();
        minVer.append(NULL_STRING);
        StringBuffer maxVer = new StringBuffer();
        maxVer.append(NULL_STRING);
        this.xmlGetAttrValueStrRange(attrs, attrName, minVer, maxVer);
        if (NULL_STRING.equals(minVer.toString())) {
            minVer.append(NULL_IP);
        }
        if (NULL_STRING.equals(maxVer.toString())) {
            maxVer.append(NULL_IP);
        }
        arg3.add(this.convertNEVer(minVer.toString()));
        arg4.add(this.convertNEVer(maxVer.toString()));
    }

    protected boolean parseNotSupportedBy(Node element, Map<TEDevInfo, TEDevVA> devVAMap) {
        if (this.vaCurState.curFuncID != 0) {
            Map<Integer, TEFuncRecord> funcMap = devVAMap.get(this.vaCurState.curDevInfo).getFuncMap();
            TEFuncRecord funcRecord = funcMap.get(this.vaCurState.curFuncID);
            TEVerInfo supportVerInfo = new TEVerInfo();
            if (!this.getVerInfo(element.getAttributes(), supportVerInfo)) {
                this.verAdapterInfo.setInitResult(false);
                return false;
            }
            funcRecord.notSupportVerInfos.add(supportVerInfo);
            return true;
        }
        TELogFactory.getNormalLogger().error("A <supported_by> tag must be included in a <function> or <implement> tag!\n");
        this.verAdapterInfo.setInitResult(false);
        return false;
    }

    protected boolean parseSupportedBy(Node element, Map<TEDevInfo, TEDevVA> devVAMap) {
        if (this.vaCurState.curFuncID != 0) {
            Map<Integer, TEFuncRecord> funcMap = devVAMap.get(this.vaCurState.curDevInfo).getFuncMap();
            TEFuncRecord funcRecord = funcMap.get(this.vaCurState.curFuncID);
            TEVerInfo supportVerInfo = new TEVerInfo();
            if (!this.getVerInfo(element.getAttributes(), supportVerInfo)) {
                this.verAdapterInfo.setInitResult(false);
                return false;
            }
            funcRecord.supportVerInfos.add(supportVerInfo);
            this.vaCurState.curFuncHasSupportRecord = true;
        } else if (!NULL_STRING.equals(this.vaCurState.curImplName)) {
            Map<String, List<TEImplRecord>> interfaceMap = devVAMap.get(this.vaCurState.curDevInfo).getInterfaceMap();
            TEVerInfo implVerInfo = new TEVerInfo();
            if (!this.getVerInfo(element.getAttributes(), implVerInfo)) {
                this.verAdapterInfo.setInitResult(false);
                return false;
            }
            for (TEImplRecord implRecord : interfaceMap.get(this.vaCurState.curIFName)) {
                if (!this.vaCurState.curImplName.equals(implRecord.implClassName)) continue;
                implRecord.implVerInfos.add(implVerInfo);
            }
            this.vaCurState.curImplHasSupportRecord = true;
        } else {
            TELogFactory.getNormalLogger().error("A <supported_by> tag must be included in a <function> or <implement> tag!\n");
            this.verAdapterInfo.setInitResult(false);
            return false;
        }
        return true;
    }

    protected boolean parseIF(Node element, Map<TEDevInfo, TEDevVA> devVAMap) {
        if (this.vaCurState.curDevInfo.neType == -1) {
            TELogFactory.getNormalLogger().error("A <*_if> tag must be included in a <device> tag!\n");
            this.verAdapterInfo.setInitResult(false);
            return false;
        }
        TEDevVA devVA = devVAMap.get(this.vaCurState.curDevInfo);
        if (devVA == null) {
            devVA = new TEDevVA();
            devVAMap.put((TEDevInfo)this.vaCurState.curDevInfo.clone(), devVA);
        }
        Map<String, List<TEImplRecord>> interfaceMap = devVA.getInterfaceMap();
        this.vaCurState.curIFName = element.getAttributes().getNamedItem(NAME).getNodeValue();
        if (interfaceMap.get(this.vaCurState.curIFName) == null) {
            ArrayList nullImplList = new ArrayList();
            interfaceMap.put(this.vaCurState.curIFName, nullImplList);
        }
        return true;
    }

    protected boolean parseImplement(Node element, Map<TEDevInfo, TEDevVA> devVAMap) {
        if (NULL_STRING.equals(this.vaCurState.curIFName)) {
            TELogFactory.getNormalLogger().error("A <implement> tag must be included in a <*_if> tag!\n");
            this.verAdapterInfo.setInitResult(false);
            return false;
        }
        Map<String, List<TEImplRecord>> interfaceMap = devVAMap.get(this.vaCurState.curDevInfo).getInterfaceMap();
        this.vaCurState.curImplName = element.getAttributes().getNamedItem(NAME).getNodeValue();
        this.vaCurState.curImplHasSupportRecord = false;
        List<TEImplRecord> implRecords = interfaceMap.get(this.vaCurState.curIFName);
        Iterator<TEImplRecord> it = implRecords.iterator();
        boolean found = false;
        while (it.hasNext()) {
            if (!this.vaCurState.curImplName.equals(it.next().implClassName)) continue;
            found = true;
            break;
        }
        if (!found) {
            TEImplRecord implRecord = new TEImplRecord();
            implRecord.implClassName = this.vaCurState.curImplName;
            implRecords.add(implRecord);
        }
        return true;
    }

    protected int convertNEVer(String neVer) {
        int result = 0;
        int bytePos = 4;
        String sep = SEPERATOR;
        StringTokenizer tokens = new StringTokenizer(neVer, sep);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            result += Integer.parseInt(token) << 8 * (bytePos - 1);
            --bytePos;
        }
        return result;
    }

    protected boolean convertNEType(NamedNodeMap attrs, List<Integer> neType) {
        String neTypeName = ((Attr)attrs.getNamedItem(NE_TYPE)).getValue();
        neType.add(SDXMLInterpreterMgr.getInstance().getMacroValueByName(neTypeName));
        return true;
    }

    public boolean convertFuncID(NamedNodeMap attrs, List<Integer> funcid) {
        String funcIDName;
        Map<String, Integer> funcIDMap = this.verAdapterInfo.getFuncIDMap();
        if (funcIDMap.get(funcIDName = ((Attr)attrs.getNamedItem(NAME)).getValue()) == null) {
            TELogFactory.getNormalLogger().error("Func ID Name \"" + funcIDName + "\" is not defined in <funcid_def> tag!");
            return false;
        }
        funcid.add(funcIDMap.get(funcIDName));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean getVerInfo(NamedNodeMap attrs, TEVerInfo verInfo) {
        Node objSel;
        block14: {
            block15: {
                ArrayList<Integer> minBuf = new ArrayList<Integer>(1);
                ArrayList<Integer> maxBuf = new ArrayList<Integer>(1);
                this.convertNEVerRange(attrs, NE_VERSION, minBuf, maxBuf);
                verInfo.minNEVer = (Integer)minBuf.get(0);
                verInfo.maxNEVer = (Integer)maxBuf.get(0);
                if (verInfo.minNEVer == 0) {
                    verInfo.minNEVer = this.vaCurState.curDevInfo.minNEVer;
                }
                if (verInfo.maxNEVer == 0) {
                    verInfo.maxNEVer = this.vaCurState.curDevInfo.maxNEVer;
                }
                if (verInfo.minNEVer > verInfo.maxNEVer || verInfo.minNEVer < this.vaCurState.curDevInfo.minNEVer || verInfo.maxNEVer > this.vaCurState.curDevInfo.maxNEVer) {
                    TELogFactory.getNormalLogger().error("Invalid version info: [" + verInfo.minNEVer + ", " + verInfo.maxNEVer + "]");
                    return false;
                }
                Node cfgState = attrs.getNamedItem(NE_CONFIG_STATE);
                String neConfigState = NULL_STRING;
                if (cfgState != null) {
                    neConfigState = cfgState.getNodeValue();
                }
                if (NULL_STRING.equals(neConfigState)) break block15;
                if ("yes".equals(neConfigState)) {
                    verInfo.neConfigState = 1;
                    break block14;
                } else if ("na" == neConfigState) {
                    verInfo.neConfigState = 0;
                    break block14;
                } else {
                    if ("no" != neConfigState) {
                        TELogFactory.getNormalLogger().error("NE Config State \"" + neConfigState + "\" is invalid value!");
                        return false;
                    }
                    verInfo.neConfigState = 2;
                }
                break block14;
            }
            verInfo.neConfigState = 0;
        }
        Node bdTypes = attrs.getNamedItem(BOARD_TYPE);
        String attrValue = null;
        if (bdTypes != null) {
            attrValue = bdTypes.getNodeValue().trim();
        }
        if (attrValue != null && attrValue.length() > 2) {
            StringTokenizer token = new StringTokenizer(attrValue.substring(1, attrValue.length() - 1), ",");
            ArrayList<String> boardTypeNames = new ArrayList<String>();
            while (token.hasMoreTokens()) {
                boardTypeNames.add(token.nextToken().trim());
            }
            Iterator it = boardTypeNames.iterator();
            while (it.hasNext()) {
                verInfo.bdTypes.add(SDXMLInterpreterMgr.getInstance().getMacroValueByName((String)it.next()));
            }
        }
        if ((objSel = attrs.getNamedItem(OBJ_SEL_IMPL)) != null) {
            verInfo.supportObjSelImplName = objSel.getNodeValue();
        }
        return true;
    }

    protected void xmlGetAttrValueStrRange(NamedNodeMap attrs, String attrName, StringBuffer minVer, StringBuffer maxVer) {
        Node verAttr = attrs.getNamedItem(attrName);
        if (verAttr == null) {
            return;
        }
        String neVersions = verAttr.getNodeValue().trim();
        if (neVersions == null || neVersions.length() <= 2) {
            return;
        }
        String[] splited = neVersions.substring(1, neVersions.length() - 1).split(",");
        if (splited == null || splited.length < 2) {
            return;
        }
        minVer.append(splited[0].trim());
        maxVer.append(splited[1].trim());
    }
}

