/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.objselect;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.objselect.TEDevInfo;
import com.huawei.nglct.cbb.objselect.TEDevVA;
import com.huawei.nglct.cbb.objselect.TEFuncRecord;
import com.huawei.nglct.cbb.objselect.TEImplRecord;
import com.huawei.nglct.cbb.objselect.TEObjSelIF;
import com.huawei.nglct.cbb.objselect.TEVerAdapterInfo;
import com.huawei.nglct.cbb.objselect.TEVerInfo;
import com.huawei.nglct.core.startup.SystemConfiguration;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.gencfg.TEGnlcfgMgrImpl;
import com.huawei.nglct.po.TECircuitPack;
import com.huawei.nglct.po.TENEPO;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEVAMgr {
    protected TEVerAdapterInfo verAdapterInfo = new TEVerAdapterInfo();
    protected static TEVAMgr instance;

    private TEVAMgr() {
        String path = SystemConfiguration.getIMapRootPath();
        this.loadFile(path + "/server/common/trans_core/conf/xml/veradapter/veradapter.xml");
        this.loadFile(path + "/server/nemgr/nemgr_rtn/conf/xml/devrtn605/devrtn605.xml");
        this.loadFile(path + "/server/nemgr/nemgr_rtn/conf/xml/devrtn610/devrtn610.xml");
        this.loadFile(path + "/server/nemgr/nemgr_rtn/conf/xml/devrtn620/devrtn620.xml");
        this.register("TEGnlcfgMgrImpl", new TEGnlcfgMgrImpl());
    }

    public static synchronized TEVAMgr getInstance() {
        if (instance == null) {
            instance = new TEVAMgr();
        }
        return instance;
    }

    public void register(String implClassName, TEObjSelIF implClass) {
        if (implClass == null) {
            return;
        }
        Map<String, TEObjSelIF> implMap = this.verAdapterInfo.getImplPtrMap();
        if (implMap.get(implClassName) != null) {
            TELogFactory.getNormalLogger().debug(String.format("VA: The interface implement \" %s \" has been registered more than once!\n", implClassName));
        }
        implMap.put(implClassName, implClass);
    }

    public boolean isFuncSupported(int funcID, TENEPO ne, TECircuitPack bd) {
        if (ne == null) {
            return false;
        }
        TEDevVA devVA = new TEDevVA();
        Map<Integer, TEFuncRecord> funcMap = devVA.getFuncMap();
        TEFuncRecord funcVerInfo = funcMap.get(funcID);
        if (funcVerInfo == null) {
            return false;
        }
        if (this.isMatch(funcID, funcVerInfo.notSupportVerInfos, ne, bd)) {
            return false;
        }
        return this.isMatch(funcID, funcVerInfo.supportVerInfos, ne, bd);
    }

    public int loadFile(String fileName) {
        return this.verAdapterInfo.loadFile(fileName);
    }

    public int getBestDevVA(TEDevVA devVA, TENEPO ne) {
        Map<TEDevInfo, TEDevVA> devVAMap = this.verAdapterInfo.getDevVAMap();
        Iterator<Map.Entry<TEDevInfo, TEDevVA>> it = devVAMap.entrySet().iterator();
        Map.Entry<TEDevInfo, TEDevVA> theBest = null;
        while (it.hasNext()) {
            Map.Entry<TEDevInfo, TEDevVA> entry = it.next();
            if (ne.getType() != entry.getKey().neType || entry.getKey().minNEVer > ne.getVersion() || ne.getVersion() > entry.getKey().maxNEVer || theBest != null && entry.getKey().minNEVer <= theBest.getKey().minNEVer) continue;
            theBest = entry;
        }
        if (theBest == null) {
            TELogFactory.getNormalLogger().debug(String.format("VA: can't find the device VerAdapter, ne:%x, type:%d, ver:%x\n", ne.getNeid(), ne.getType(), ne.getVersion()));
            return 1090613250;
        }
        devVA.setFuncMap(((TEDevVA)theBest.getValue()).getFuncMap());
        devVA.setInterfaceMap(((TEDevVA)theBest.getValue()).getInterfaceMap());
        return 0;
    }

    public int getInterface(TEObjSelIF[] pIF, String interfaceName, int neID, int slotID) {
        TENEPO ne = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(neID));
        if (slotID != 0) {
            TECircuitPack bd = new TECircuitPack(neID, slotID);
            bd = (TECircuitPack)CommonDaoService.getById(TECircuitPack.class, bd);
            return this.getInterface(pIF, interfaceName, ne, bd);
        }
        return this.getInterface(pIF, interfaceName, ne, null);
    }

    public int getInterface(TEObjSelIF[] pIF, String interfaceName, TENEPO ne, TECircuitPack bd) {
        int errCode = 0;
        TEDevVA devVA = new TEDevVA();
        errCode = this.getBestDevVA(devVA, ne);
        if (0 != errCode) {
            return errCode;
        }
        Map<String, List<TEImplRecord>> interfaceMap = devVA.getInterfaceMap();
        if (interfaceMap.get(interfaceName) == null) {
            TELogFactory.getNormalLogger().debug(String.format("VA: can't find the interface, ne:%x, type:%d, interface:\"%s\"\n", ne.getNeid(), ne.getType(), interfaceName));
            return 1090613252;
        }
        Map<String, TEObjSelIF> implPtrMap = this.verAdapterInfo.getImplPtrMap();
        for (TEImplRecord implRecord : interfaceMap.get(interfaceName)) {
            List<TEVerInfo> implVerInfos = implRecord.implVerInfos;
            for (TEVerInfo verInfo : implVerInfos) {
                if (verInfo.minNEVer > ne.getVersion() || ne.getVersion() > verInfo.maxNEVer || bd != null && !verInfo.bdTypes.isEmpty() && !verInfo.bdTypes.contains(bd.getTypeId())) continue;
                if (implPtrMap.get(implRecord.implClassName) != null) {
                    pIF[0] = implPtrMap.get(implRecord.implClassName);
                    if (interfaceName.equals(pIF[0].getName())) {
                        return 1090613253;
                    }
                    return 0;
                }
                TELogFactory.getNormalLogger().debug(String.format("VA: The interface implement \"%s\" has not been registered! neid:%x, netype:%d, Ver:%x\n", implRecord.implClassName, ne.getNeid(), ne.getType(), ne.getVersion()));
                return 1090613251;
            }
        }
        return 1090613252;
    }

    protected boolean isMatch(int funcID, List<TEVerInfo> verInfos, TENEPO ne, TECircuitPack cp) {
        if (ne == null) {
            return false;
        }
        for (TEVerInfo verInfo : verInfos) {
            TEObjSelIF inter;
            if (verInfo.minNEVer > ne.getVersion() || ne.getVersion() > verInfo.maxNEVer || verInfo.neConfigState != 0 && (verInfo.neConfigState != 1 || ne.getConfigState() != 2) && (verInfo.neConfigState != 2 || ne.getConfigState() != 0) || cp != null && !verInfo.bdTypes.isEmpty() && !verInfo.bdTypes.contains(cp.getTypeId()) || verInfo.supportObjSelImplName != null && !"".equals(verInfo.supportObjSelImplName) && (inter = this.getImpl(verInfo.supportObjSelImplName)) != null && "TEObjSelIF".equals(inter.getName()) && !inter.isSupported(funcID, ne, cp)) continue;
            return true;
        }
        return false;
    }

    public TEObjSelIF getImpl(String implClassName) {
        Map<String, TEObjSelIF> implMap = this.verAdapterInfo.getImplPtrMap();
        TEObjSelIF inter = implMap.get(implClassName);
        if (inter == null) {
            TELogFactory.getNormalLogger().debug(String.format("VA: The interface implement \"%s\" has not been registered!\n", implClassName));
        }
        return inter;
    }
}

