/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.objselect;

import com.huawei.nglct.cbb.objselect.TEAutoRegisterObjSel_Default;
import com.huawei.nglct.cbb.objselect.TEDataMgrObjSel;
import com.huawei.nglct.cbb.objselect.TEFuncSuppStru;
import com.huawei.nglct.cbb.objselect.TEObjSelIF;
import com.huawei.nglct.cbb.objselect.TEObjSelectBoard;
import com.huawei.nglct.cbb.objselect.TEObjSelectItems;
import com.huawei.nglct.cbb.objselect.TEObjSelectNE;
import com.huawei.nglct.core.communication.DebugTracer;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.po.TECircuitPack;
import com.huawei.nglct.po.TENEPO;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEObjSelMgr {
    private static TEObjSelMgr instance;
    private Map<Integer, TEFuncSuppStru> funcSuppTable = new HashMap<Integer, TEFuncSuppStru>();

    private TEObjSelMgr() {
        this.register(8299, 1, new TEAutoRegisterObjSel_Default());
        this.register(4176, 2, new TEDataMgrObjSel(4176, 2));
        this.register(4112, 1, new TEDataMgrObjSel(4112, 1));
        this.register(4144, 2, new TEDataMgrObjSel(4144, 2));
        this.register(4178, 2, new TEDataMgrObjSel(4178, 2));
        this.register(4179, 2, new TEDataMgrObjSel(4179, 2));
    }

    public static synchronized TEObjSelMgr getInstance() {
        if (instance == null) {
            instance = new TEObjSelMgr();
        }
        return instance;
    }

    public int getSelectableItems(int funcID, List<Integer> neIDs, List<Integer> minLevel, TEObjSelectItems items) {
        TEFuncSuppStru suppStru = this.funcSuppTable.get(funcID);
        if (suppStru == null || suppStru.objSelIF == null) {
            return 1090613254;
        }
        minLevel.add(suppStru.minLevel);
        if (suppStru.minLevel == 1) {
            this.getSelectableNEs(funcID, neIDs, suppStru.objSelIF, items);
        } else {
            this.getSelectableBoards(funcID, neIDs, suppStru.objSelIF, items);
        }
        return 0;
    }

    public void getSelectableNEs(int funcID, List<Integer> neIDs, TEObjSelIF objSelIF, TEObjSelectItems items) {
        items.nes.clear();
        int size = neIDs.size();
        for (int i = 0; i < size; ++i) {
            int neID = neIDs.get(i);
            TENEPO ne = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(neID));
            if (!objSelIF.isSupported(funcID, ne, null)) continue;
            TEObjSelectNE selNe = new TEObjSelectNE();
            selNe.neID = neID;
            items.nes.add(selNe);
        }
    }

    public void getSelectableBoards(int funcID, List<Integer> neIDs, TEObjSelIF objSelIF, TEObjSelectItems items) {
        items.nes.clear();
        int size = neIDs.size();
        for (int i = 0; i < size; ++i) {
            int neID = neIDs.get(i);
            TEObjSelectNE selNe = new TEObjSelectNE();
            selNe.neID = neID;
            TENEPO ne = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(neID));
            Set<TECircuitPack> boards = ne.getBoardSet();
            for (TECircuitPack boardPO : boards) {
                if (!objSelIF.isSupported(funcID, ne, boardPO)) continue;
                TEObjSelectBoard selBoard = new TEObjSelectBoard();
                selBoard.slotID = boardPO.getSlotId();
                selBoard.boardType = boardPO.getTypeId();
                selNe.boards.add(selBoard);
            }
            if (selNe.boards.size() <= 0) continue;
            Collections.sort(selNe.boards);
            items.nes.add(selNe);
        }
    }

    public void register(int funcID, int minLevel, TEObjSelIF objSelIF) {
        if (objSelIF == null) {
            return;
        }
        TEFuncSuppStru funcSuppStru = new TEFuncSuppStru(minLevel, objSelIF);
        if (this.funcSuppTable.get(funcID) != null) {
            DebugTracer.trace(String.format("VA: Function: %d have registered more than once!\n", funcID));
        }
        this.funcSuppTable.put(funcID, funcSuppStru);
    }
}

