/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.mml.helper;

import com.huawei.nglct.cbb.mml.ParseException;
import com.huawei.nglct.cbb.mml.helper.MMLParserHelperConstants;
import java.util.StringTokenizer;

public class MMLParameter {
    private static final String SEPERATOR = "&";
    private String name;
    private Object value;
    private MMLParserHelperConstants.ParamType type;
    private String strValue;

    public MMLParameter(String paramName, String valueStr, MMLParserHelperConstants.ParamType paramType) throws ParseException {
        this.name = paramName;
        this.type = paramType;
        this.strValue = valueStr;
        switch (paramType) {
            case IDENTIFIER: 
            case KEYBOARD_NUM: 
            case STRING: 
            case IPADDRESS: 
            case ENUM: 
            case BITWISE: 
            case URI: {
                this.value = this.strValue;
                break;
            }
            case DECIMAL_NUM: {
                this.value = new Integer(this.strValue);
                break;
            }
            case HEX_NUM: {
                valueStr = valueStr.trim().substring(2);
                this.value = Integer.parseInt(valueStr, 16);
                break;
            }
            case OCTAL_NUM: {
                valueStr = valueStr.trim().substring(2);
                this.value = Integer.parseInt(valueStr, 8);
                break;
            }
            case BINARY_NUM: {
                valueStr = valueStr.trim().substring(2);
                this.value = Integer.parseInt(valueStr, 2);
                break;
            }
            case GROUP: {
                this.value = this.strValue;
                break;
            }
            default: {
                throw new ParseException("Unsupported MML data type.");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String stringValue() {
        return this.strValue;
    }

    public Object[] getGroupItems() throws ParseException {
        if (this.type == MMLParserHelperConstants.ParamType.GROUP && this.value != null) {
            StringTokenizer st = new StringTokenizer((String)this.value, SEPERATOR);
            Object[] items = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                items[i++] = st.nextToken();
            }
            return items;
        }
        return new Object[]{this.value};
    }

    public MMLParserHelperConstants.ParamType getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Parameter name is : ");
        buf.append(this.name);
        buf.append(", type is : ");
        buf.append((Object)this.type);
        buf.append(", value is ");
        buf.append(this.stringValue());
        return buf.toString();
    }
}

