/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log.zip;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.zip.FileScanResult;
import com.huawei.nglct.cbb.log.zip.FileZipResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipLogTask
extends TimerTask {
    private String logRoot = null;
    private int maxFileNumber = -1;
    private int maxZipNumber = -1;
    private static String regularExp = "(.)*\\.(\\d)+$";
    private static String dirSeperator = "/";

    public ZipLogTask(String logRoot, int maxFileNumber, int maxZipNumber) {
        this.logRoot = logRoot;
        this.maxFileNumber = maxFileNumber;
        this.maxZipNumber = maxZipNumber;
    }

    @Override
    public void run() {
        TELogFactory.getNormalLogger().debug("Running timer task...at " + new Date());
        try {
            this.scanLogFiles(this.logRoot);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("scanLogFiles failed!", (Throwable)e);
        }
        TELogFactory.getNormalLogger().debug("Finish timer task....at " + new Date());
    }

    private void scanLogFiles(String dir) throws IOException {
        File file = new File(dir);
        if (file.isDirectory()) {
            int i;
            String[] list = file.list();
            FileScanResult result = new FileScanResult(this.maxFileNumber);
            FileZipResult resultZip = new FileZipResult(this.maxZipNumber);
            String fileName2 = null;
            File tempFile = null;
            for (String fileName2 : list) {
                if (Pattern.matches(regularExp, fileName2)) {
                    tempFile = new File(dir + dirSeperator + fileName2);
                    if (!tempFile.isFile()) continue;
                    result.insert(fileName2);
                    continue;
                }
                if (fileName2.split("_").length < 2 || !(tempFile = new File(dir + dirSeperator + fileName2)).isFile()) continue;
                resultZip.insert(fileName2);
            }
            ArrayList<String> zipList = result.getZipList();
            int len = zipList.size();
            for (i = 0; i < len; ++i) {
                fileName2 = zipList.get(i);
                this.zipLogFiles(dir, fileName2, result.getFileSet(fileName2));
            }
            zipList = resultZip.getZipList();
            len = zipList.size();
            for (i = 0; i < len; ++i) {
                fileName2 = zipList.get(i);
                this.zipDelFiles(dir, fileName2, resultZip.getFileSet(fileName2));
            }
        }
    }

    private void zipDelFiles(String dir, String fileName, Set<String> set) {
        int count = 0;
        Iterator<String> i = set.iterator();
        while (true) {
            File f;
            if ((f = new File(dir + dirSeperator + i.next())).exists()) {
                f.delete();
            }
            if (++count >= set.size() - this.maxZipNumber) break;
            i.hasNext();
        }
    }

    private void zipLogFiles(String dir, String fileName, Set<String> set) throws IOException {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
        File zipFile = new File(dir + dirSeperator + fileName + "_" + format.format(new Date()) + ".zip");
        System.out.println("...create a new zip file " + zipFile.getName());
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        int count = 0;
        int sameZipNameMark = 0;
        Iterator<String> i = set.iterator();
        while (true) {
            File f = new File(dir + dirSeperator + i.next());
            FileInputStream fis = new FileInputStream(f);
            ZipEntry ze = new ZipEntry(f.getName());
            zos.putNextEntry(ze);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = fis.read(buf)) != -1) {
                zos.write(buf, 0, len);
                zos.flush();
            }
            System.out.println("successfully zip file " + f.getName());
            fis.close();
            f.delete();
            if (++count % this.maxFileNumber == 0) {
                zos.close();
                fos.close();
                if (set.size() - count < this.maxFileNumber) break;
                String zipFileName = fileName + "_" + format.format(new Date()) + ".zip";
                if (zipFileName.equals(zipFile.getName())) {
                    zipFileName = fileName + "_" + format.format(new Date()) + "_" + ++sameZipNameMark + ".zip";
                }
                zipFile = new File(dir + dirSeperator + zipFileName);
                System.out.println("...create a new zip file " + zipFile.getName());
                fos = new FileOutputStream(zipFile);
                zos = new ZipOutputStream(fos);
            }
            i.hasNext();
        }
    }
}

