/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log.t2kinterface;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TEOperCmdType;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnGetCmdcodeRightMapRsp;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnNullReq;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnRightInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import net.commustru.fstru.FStruct;

public class TEInterfaceProcess {
    private static TIntObjectHashMap<TEOperCmdType> cmdIDToCmdSIDMap;
    private static final int m2000;
    private static final String LOG_ZH = "\u00cd\u00f8\u00d4\u00aa\u00c5\u00e4\u00d6\u00c3\u00b9\u00dc\u00c0\u00ed";
    private static final String LOG_EN = "NE Configuration management";
    private static final int QUERY_TIMEOUT_SECONDS = 60;

    public static void iniTEDataBaseParam() {
        cmdIDToCmdSIDMap = new TIntObjectHashMap();
        TEInterfaceProcess.loadCmdIDToSecIDMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeLog(TELogInfo logInfo) {
        boolean bexcuteresult;
        block9: {
            bexcuteresult = false;
            int userID = logInfo.getUserID();
            String userName = logInfo.getUserName();
            int errCode = logInfo.getErrCode();
            int result = logInfo.getResult();
            String strIPAddr = logInfo.getLocation();
            String operateObject = logInfo.getOperateObject();
            String operateDesc = logInfo.getOperateDesc();
            String category = LOG_ZH;
            if (TESysManagerBean.getInstance().getlanguage().equalsIgnoreCase("en")) {
                category = LOG_EN;
            }
            Calendar locCal = Calendar.getInstance();
            long time = locCal.getTimeInMillis() / 1000L;
            int dbtime = new Long(time).intValue();
            Connection logConn = null;
            PreparedStatement preStat = null;
            ResultSet rs = null;
            logConn = TECommonDaoService.getLogConn();
            if (null == logConn) {
                TELogFactory.getNormalLogger().error("get connection failed!");
                return false;
            }
            try {
                if (m2000 == 0) {
                    userName = TEInterfaceProcess.getUserName(userID);
                }
                String sqlCount = "select max(recordId) from tbl_Audit";
                String sql = "insert into tbl_Audit values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                TELogFactory.getNormalLogger().info("sql write log = " + sql);
                int count = 0;
                preStat = logConn.prepareStatement(sqlCount);
                rs = preStat.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1) + 1;
                }
                rs.close();
                int i = 1;
                preStat = logConn.prepareStatement(sql);
                preStat.setInt(i++, count);
                preStat.setInt(i++, userID);
                preStat.setString(i++, userName);
                preStat.setInt(i++, 1);
                preStat.setString(i++, strIPAddr);
                preStat.setInt(i++, dbtime);
                preStat.setString(i++, category);
                preStat.setString(i++, logInfo.getOperateName());
                preStat.setString(i++, operateObject);
                preStat.setInt(i++, result);
                preStat.setString(i++, operateDesc);
                preStat.setInt(i++, dbtime);
                preStat.setInt(i++, 1);
                preStat.setString(i++, "");
                preStat.setInt(i++, errCode);
                preStat.setInt(i++, 0);
                bexcuteresult = preStat.execute();
                TEInterfaceProcess.closeResultSet(rs, preStat);
            }
            catch (SQLException ex) {
                TELogFactory.getNormalLogger().error("write log[" + logInfo.getOperateName() + "] faied ", (Throwable)ex);
                break block9;
            }
            finally {
                TEInterfaceProcess.closeResultSet(rs, preStat);
                TEInterfaceProcess.closeConnection(logConn);
            }
            TEInterfaceProcess.closeConnection(logConn);
        }
        return bexcuteresult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getCmdInfo(int cmdID) {
        int[] objType;
        Connection securityConn;
        ResultSet rs;
        PreparedStatement preStat;
        block4: {
            preStat = null;
            rs = null;
            securityConn = null;
            objType = new int[3];
            String sql = " select ObjectTID,ObjectSubTID,PerilLevel from tbl_CmdInfo where CmdID = ?";
            try {
                securityConn = TECommonDaoService.getSecurityConn();
                if (null == securityConn) break block4;
                preStat = securityConn.prepareStatement(sql);
                preStat.setQueryTimeout(60);
                preStat.setInt(1, cmdID);
                rs = preStat.executeQuery();
                if (!rs.next()) break block4;
                objType[0] = rs.getInt("ObjectTID");
                objType[1] = rs.getInt("ObjectSubTID");
                objType[2] = rs.getInt("PerilLevel");
            }
            catch (SQLException ex) {
                try {
                    TELogFactory.getNormalLogger().error("query cmd operlevel failed", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    TEInterfaceProcess.closeResultSet(rs, preStat);
                    TEInterfaceProcess.closeConnection(securityConn);
                    throw throwable;
                }
                TEInterfaceProcess.closeResultSet(rs, preStat);
                TEInterfaceProcess.closeConnection(securityConn);
            }
        }
        TEInterfaceProcess.closeResultSet(rs, preStat);
        TEInterfaceProcess.closeConnection(securityConn);
        return objType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserName(int userID) {
        String userName;
        block7: {
            userName = "";
            Connection securityConn = TECommonDaoService.getSecurityConn();
            PreparedStatement preStat = null;
            ResultSet rs = null;
            if (null == securityConn) {
                TELogFactory.getNormalLogger().info("connect to security database fail!");
                return userName;
            }
            String sql = "select UserName from tbl_SMUser where UserID = ?";
            try {
                preStat = securityConn.prepareStatement(sql);
                preStat.setQueryTimeout(60);
                preStat.setInt(1, userID);
                rs = preStat.executeQuery();
                if (rs.next()) {
                    userName = rs.getString(1);
                }
                TEInterfaceProcess.closeResultSet(rs, preStat);
            }
            catch (SQLException ex) {
                TELogFactory.getNormalLogger().error("database query user name exception", (Throwable)ex);
                break block7;
            }
            finally {
                TEInterfaceProcess.closeResultSet(rs, preStat);
                TEInterfaceProcess.closeConnection(securityConn);
            }
            TEInterfaceProcess.closeConnection(securityConn);
        }
        return userName;
    }

    private static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeResultSet(ResultSet rs, PreparedStatement preStat) {
        try {
            if (null != rs) {
                rs.close();
            }
            if (null != preStat) {
                preStat.close();
            }
        }
        catch (SQLException e) {
            TELogFactory.getNormalLogger().error("database close exception", (Throwable)e);
        }
    }

    private static void loadCmdIDToSecIDMap() {
        try {
            AsnNullReq req = new AsnNullReq();
            req.userID = 0;
            AsnGetCmdcodeRightMapRsp rsp = new AsnGetCmdcodeRightMapRsp();
            int result = TEASN1CommMgr.sendCommand(TEASN1CommMgr.UNITE_PROCID, (FStruct)req, (FStruct)rsp, 2256916);
            if (result != 0 || rsp.errCode != 0) {
                TELogFactory.getNormalLogger().error("---loading security data failed--- result=" + result + ",rsp.errCode=" + rsp.errCode);
                return;
            }
            int size = rsp.rightList.size();
            for (int i = 0; i < size; ++i) {
                AsnRightInfo rightInfo = (AsnRightInfo)rsp.rightList.get(i);
                int count = rightInfo.cmdList.size();
                for (int j = 0; j < count; ++j) {
                    TEOperCmdType operType = new TEOperCmdType();
                    operType.cmd = rightInfo.cmdList.get(j);
                    operType.cmdSID = String.valueOf(rightInfo.rightCode);
                    operType.objectTID = rightInfo.objectTID;
                    operType.objectSubTID = rightInfo.objectSTID;
                    cmdIDToCmdSIDMap.put(operType.cmd, (Object)operType);
                }
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("database query user cmdset exception", (Throwable)ex);
        }
    }

    public static synchronized TEOperCmdType getCmdType(String cmdString) {
        if (cmdIDToCmdSIDMap == null || cmdIDToCmdSIDMap.isEmpty()) {
            TEInterfaceProcess.loadCmdIDToSecIDMap();
        }
        return (TEOperCmdType)cmdIDToCmdSIDMap.get(Integer.parseInt(cmdString));
    }

    public static synchronized TEOperCmdType getCmdSIDFromCmdID(String cmdID) {
        TEOperCmdType type = TEInterfaceProcess.getCmdType(String.valueOf(cmdID));
        return type;
    }

    public static synchronized int getTIDFromCmdID(String cmdID) {
        int otid = 4;
        TEOperCmdType type = TEInterfaceProcess.getCmdType(String.valueOf(cmdID));
        if (null != type) {
            otid = type.objectTID;
        }
        return otid;
    }

    public static synchronized int getSubTIDFromCmdID(String cmdID) {
        int ostid = 1;
        TEOperCmdType type = TEInterfaceProcess.getCmdType(String.valueOf(cmdID));
        if (null != type) {
            ostid = type.objectSubTID;
        }
        return ostid;
    }

    public static int querySuperUserID() {
        return 0;
    }

    static {
        m2000 = TESysManagerBean.getInstance().getM2000();
    }
}

