/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log.t2kinterface;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEDBConnMgr {
    private final int MSSQL_SERVER = 1;
    private final int SYBASE = 0;
    private int databaseType = 1;
    private String ssdbName = "smdb";
    private String logdbName = "logdb";
    private String mcdbName = "MCDB";
    private String userName = "sa";
    private byte[] password = null;
    private String mssqlURL = "jdbc:jtds:sqlserver://localhost:1433/";
    private String sybaseURL = "jdbc:sybase:Tds:127.0.0.1:5100/";
    private String oracleURL = "jdbc:oracle:thin:@127.0.0.1:1521:";
    private String mssqlDriver = "net.sourceforge.jtds.jdbc.Driver";
    private String sybaseDriver = "com.sybase.jdbc3.jdbc.SybDriver";
    private String oracleDriver = "oracle.jdbc.driver.OracleDriver";
    private int maxActive = 10;
    private int maxIdle = 5;
    private final String dataConf = TEResourceManager.getPath() + File.separator + "conf" + File.separator + "database.properties";
    private ComboPooledDataSource securityConnDS = null;
    private ComboPooledDataSource logConnDS = null;
    private ComboPooledDataSource mcdbConnDS = null;
    private Connection securityConn = null;
    private Connection logConn = null;
    private Connection mcdbConn = null;
    private static final String VALIDATE_QUERY_STR_WIN_SO = "SELECT 1";
    private static final String VALIDATE_QUERY_STR_LINUX = "SELECT 1 FROM dual";
    private Properties databasePro = null;
    private static final String sysconfigureFileName = "sysconfigure.xml";
    private String dbNameType = "";
    public final boolean WINDOWS_OS = System.getProperty("os.name").indexOf("Windows") != -1;
    private static TEDBConnMgr dbConnMgr = new TEDBConnMgr();

    private TEDBConnMgr() {
        try {
            if (TESysManagerBean.getInstance().getM2000() == 0) {
                this.loadU2000Configure();
            }
        }
        catch (Throwable e) {
            TELogFactory.getNormalLogger().error("init datesource fail", e);
        }
    }

    public Connection getDBConn(String strDBName) {
        Connection dbConn = null;
        String dbName = strDBName;
        dbName = dbName.trim();
        ComboPooledDataSource dbConnDS = new ComboPooledDataSource();
        if (0 == this.databaseType) {
            dbConnDS.setJdbcUrl(this.sybaseURL + dbName);
            try {
                dbConnDS.setDriverClass(this.sybaseDriver);
            }
            catch (PropertyVetoException e) {
                TELogFactory.getNormalLogger().error("get DataBase Connect Fail!", (Throwable)e);
            }
        } else if (1 == this.databaseType) {
            dbConnDS.setJdbcUrl(this.mssqlURL + dbName);
            try {
                dbConnDS.setDriverClass(this.mssqlDriver);
            }
            catch (PropertyVetoException e) {
                TELogFactory.getNormalLogger().error("get DataBase Connect Fail!", (Throwable)e);
            }
        }
        dbConnDS.setUser(this.userName);
        if (this.password != null) {
            dbConnDS.setPassword(new String(this.password));
        } else {
            dbConnDS.setPassword("");
        }
        dbConnDS.setMaxPoolSize(this.maxActive);
        dbConnDS.setMinPoolSize(this.maxIdle);
        dbConnDS.setTestConnectionOnCheckout(true);
        dbConnDS.setTestConnectionOnCheckin(true);
        dbConnDS.setPreferredTestQuery(VALIDATE_QUERY_STR_WIN_SO);
        dbConnDS.setCheckoutTimeout(5000);
        try {
            dbConn = dbConnDS.getConnection();
        }
        catch (SQLException e) {
            TELogFactory.getNormalLogger().error("get DataBase Connect Fail!", (Throwable)e);
        }
        return dbConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadU2000Configure() {
        this.databasePro = new Properties();
        FileInputStream dataConfInputStream = null;
        try {
            dataConfInputStream = new FileInputStream(TEResourceManager.getFileByName(this.dataConf));
            this.databasePro.load(dataConfInputStream);
            this.mssqlDriver = this.databasePro.getProperty("MSSQL_SERVER.JDBC.DRIVER").trim();
            this.sybaseDriver = this.databasePro.getProperty("SYBASE.JDBC.DRIVER").trim();
            this.maxActive = Integer.parseInt(this.databasePro.getProperty("maxActive"));
            this.maxIdle = Integer.parseInt(this.databasePro.getProperty("maxIdle"));
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("initial DataSource Fail!", (Throwable)ex);
        }
        finally {
            try {
                if (null != dataConfInputStream) {
                    ((InputStream)dataConfInputStream).close();
                }
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("Close dataBase config file failed!", (Throwable)e);
            }
        }
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        String u2000sysconfigurepath = System.getenv("IMAP_CONFIG_PATH");
        if (u2000sysconfigurepath == null || u2000sysconfigurepath.equals("")) {
            return;
        }
        StringBuffer filePath = new StringBuffer(u2000sysconfigurepath).append(File.separator).append(sysconfigureFileName);
        TELogFactory.getNormalLogger().info("IMAP_CONFIG_PATH=" + filePath.toString());
        Document doc = null;
        try {
            builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setIgnoringComments(true);
            builderFactory.setIgnoringElementContentWhitespace(true);
            builderFactory.setCoalescing(true);
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(new File(filePath.toString()));
        }
        catch (Exception e) {
            TELogFactory.getStartupLogger().error("Parse System Config File Fail\u00a3\u00a1", (Throwable)e);
            return;
        }
        Node childNode = doc.getFirstChild();
        Element element = (Element)childNode;
        NodeList nodeList = element.getElementsByTagName("dbServers");
        if (nodeList != null && nodeList.getLength() >= 0 && (nodeList = ((Element)nodeList.item(0)).getElementsByTagName("dbServer")) != null && nodeList.getLength() >= 0) {
            NodeList nodeListTmp = nodeList.item(0).getChildNodes();
            String serverPort = "";
            String serverIP = "";
            String serviceName = null;
            if (nodeListTmp != null && nodeListTmp.getLength() >= 0) {
                int m = nodeListTmp.getLength();
                for (int i = 0; i < m; ++i) {
                    Node nodeTmp = nodeListTmp.item(i);
                    if (!nodeTmp.getNodeName().equals("param")) continue;
                    element = (Element)nodeTmp;
                    String name = element.getAttribute("name");
                    if (name.equalsIgnoreCase("type")) {
                        this.dbNameType = element.getChildNodes().item(0).getNodeValue();
                        continue;
                    }
                    if (name.equals("serverPort")) {
                        serverPort = element.getChildNodes().item(0).getNodeValue();
                        continue;
                    }
                    if (name.equals("serverName")) {
                        serverIP = element.getChildNodes().item(0).getNodeValue();
                        continue;
                    }
                    if (!name.equals("serviceName")) continue;
                    serviceName = element.getChildNodes().item(0).getNodeValue();
                }
            }
            if ((nodeListTmp = ((Element)nodeList.item(0)).getElementsByTagName("dbInfos")) != null && nodeListTmp.getLength() >= 0) {
                try {
                    this.dealDBInfos(serviceName, serverIP, serverPort, (Element)nodeListTmp.item(0));
                }
                catch (PropertyVetoException e) {
                    TELogFactory.getNormalLogger().error("dealDBInfos failed!", (Throwable)e);
                }
            }
        }
    }

    private void dealDBInfos(String serviceName, String serverIP, String serverPort, Element element) throws PropertyVetoException {
        NodeList nodeList = element.getElementsByTagName("dbInfo");
        Element elementTmp = null;
        String[] loginInfo = null;
        this.securityConnDS = new ComboPooledDataSource();
        this.logConnDS = new ComboPooledDataSource();
        this.mcdbConnDS = new ComboPooledDataSource();
        String validationQueryStr = null;
        if (this.dbNameType.equalsIgnoreCase("SQLSERVER")) {
            this.mssqlURL = "jdbc:jtds:sqlserver://" + serverIP.trim() + ":" + serverPort.trim() + "/";
            this.securityConnDS.setJdbcUrl(this.mssqlURL + this.ssdbName);
            this.securityConnDS.setDriverClass(this.mssqlDriver);
            this.logConnDS.setJdbcUrl(this.mssqlURL + this.logdbName);
            this.logConnDS.setDriverClass(this.mssqlDriver);
            this.mcdbConnDS.setJdbcUrl(this.mssqlURL + this.mcdbName);
            this.mcdbConnDS.setDriverClass(this.mssqlDriver);
            validationQueryStr = VALIDATE_QUERY_STR_WIN_SO;
        } else if (this.dbNameType.equalsIgnoreCase("SYBASE")) {
            this.sybaseURL = "jdbc:sybase:Tds:" + serverIP.trim() + ":" + serverPort.trim() + "/";
            this.securityConnDS.setJdbcUrl(this.sybaseURL + this.ssdbName);
            this.securityConnDS.setDriverClass(this.sybaseDriver);
            this.logConnDS.setJdbcUrl(this.sybaseURL + this.logdbName);
            this.logConnDS.setDriverClass(this.sybaseDriver);
            this.mcdbConnDS.setJdbcUrl(this.sybaseURL + this.mcdbName);
            this.mcdbConnDS.setDriverClass(this.sybaseDriver);
            validationQueryStr = VALIDATE_QUERY_STR_WIN_SO;
        } else if (this.dbNameType.equalsIgnoreCase("ORACLE")) {
            this.oracleURL = "jdbc:oracle:thin:@" + serverIP.trim() + ":" + serverPort.trim() + ":";
            this.securityConnDS.setJdbcUrl(this.oracleURL + serviceName);
            this.securityConnDS.setDriverClass(this.oracleDriver);
            this.logConnDS.setJdbcUrl(this.oracleURL + serviceName);
            this.logConnDS.setDriverClass(this.oracleDriver);
            this.mcdbConnDS.setJdbcUrl(this.oracleURL + serviceName);
            this.mcdbConnDS.setDriverClass(this.oracleDriver);
            validationQueryStr = VALIDATE_QUERY_STR_LINUX;
        }
        this.securityConnDS.setMaxPoolSize(this.maxActive);
        this.securityConnDS.setMinPoolSize(this.maxIdle);
        this.securityConnDS.setTestConnectionOnCheckout(true);
        this.securityConnDS.setTestConnectionOnCheckin(true);
        this.securityConnDS.setPreferredTestQuery(validationQueryStr);
        this.securityConnDS.setCheckoutTimeout(5000);
        this.logConnDS.setMaxPoolSize(this.maxActive);
        this.logConnDS.setMinPoolSize(this.maxIdle);
        this.logConnDS.setTestConnectionOnCheckout(true);
        this.logConnDS.setTestConnectionOnCheckin(true);
        this.logConnDS.setPreferredTestQuery(validationQueryStr);
        this.logConnDS.setCheckoutTimeout(5000);
        this.mcdbConnDS.setMaxPoolSize(this.maxActive);
        this.mcdbConnDS.setMinPoolSize(this.maxIdle);
        this.mcdbConnDS.setTestConnectionOnCheckout(true);
        this.mcdbConnDS.setTestConnectionOnCheckin(true);
        this.mcdbConnDS.setPreferredTestQuery(validationQueryStr);
        this.mcdbConnDS.setCheckoutTimeout(5000);
        if (nodeList != null && nodeList.getLength() >= 0) {
            int m = nodeList.getLength();
            for (int i = 0; i < m; ++i) {
                elementTmp = (Element)nodeList.item(i);
                String name = elementTmp.getAttribute("name");
                if (name.equalsIgnoreCase(this.ssdbName)) {
                    loginInfo = this.getLoginInfo(elementTmp);
                    this.securityConnDS.setUser(loginInfo[0]);
                    this.securityConnDS.setPassword(loginInfo[1]);
                    continue;
                }
                if (name.equals(this.logdbName)) {
                    loginInfo = this.getLoginInfo(elementTmp);
                    this.logConnDS.setUser(loginInfo[0]);
                    this.logConnDS.setPassword(loginInfo[1]);
                    continue;
                }
                if (!this.mcdbName.equals(name)) continue;
                loginInfo = this.getLoginInfo(elementTmp);
                this.mcdbConnDS.setUser(loginInfo[0]);
                this.mcdbConnDS.setPassword(loginInfo[1]);
            }
        }
    }

    private String[] getLoginInfo(Element element) {
        NodeList nodeList = element.getElementsByTagName("param");
        Element elementTmp = null;
        String[] logininfo = new String[2];
        if (nodeList != null && nodeList.getLength() >= 0) {
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                elementTmp = (Element)nodeList.item(i);
                String name = elementTmp.getAttribute("name");
                if (name.equalsIgnoreCase("user")) {
                    logininfo[0] = elementTmp.getChildNodes().item(0).getNodeValue();
                    continue;
                }
                if (!name.equalsIgnoreCase("password")) continue;
                String type = elementTmp.getAttribute("type");
                logininfo[1] = type != null && type.equalsIgnoreCase("encrypt") ? EncryptUtils.decryptAES(elementTmp.getChildNodes().item(0).getNodeValue()) : elementTmp.getChildNodes().item(0).getNodeValue();
            }
        }
        return logininfo;
    }

    public Connection getMCDBConn() {
        try {
            if (null != this.mcdbConnDS) {
                this.mcdbConn = this.mcdbConnDS.getConnection();
            } else {
                TELogFactory.getNormalLogger().error("mcdbConnDS is null...");
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get MCDB DataBse Connect Fail!", (Throwable)e);
        }
        return this.mcdbConn;
    }

    public Connection getSecurityConn() {
        try {
            if (null != this.securityConnDS) {
                this.securityConn = this.securityConnDS.getConnection();
            } else {
                TELogFactory.getNormalLogger().error("securityConnDS is null...");
            }
        }
        catch (SQLException e) {
            TELogFactory.getNormalLogger().error("get security DataBse Connect Fail!", (Throwable)e);
        }
        return this.securityConn;
    }

    public Connection getLogConn() {
        try {
            if (null != this.logConnDS) {
                this.logConn = this.logConnDS.getConnection();
            } else {
                TELogFactory.getNormalLogger().error("log connection datasource is null...");
            }
        }
        catch (SQLException e) {
            TELogFactory.getNormalLogger().error("get Log DataBse Connect Fail!", (Throwable)e);
        }
        return this.logConn;
    }

    public static synchronized TEDBConnMgr getInstance() {
        if (null == dbConnMgr) {
            dbConnMgr = new TEDBConnMgr();
        }
        return dbConnMgr;
    }

    public String getStrType() {
        return this.dbNameType;
    }
}

