/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.cbb.log.TEWriteLogInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public abstract class TEWriteLogCommonImpl
implements TEWriteLogInterface {
    @Override
    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            if (errorCode == 0) {
                loginfo = new TELogInfo();
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                loginfoList.add(loginfo);
            } else if (errorCode == 2 || errorCode == 1) {
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    int size = rowErrors.length;
                    for (int j = 0; j < size; ++j) {
                        loginfo = new TELogInfo();
                        loginfo.setResult(2);
                        loginfo.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                        loginfo.setErrInfo(rowErrors[j].getErrorMessage().getErrorinfo());
                        if (loginfoList.contains(loginfo)) continue;
                        loginfoList.add(loginfo);
                    }
                }
            } else {
                loginfo = new TELogInfo();
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                loginfo = (TELogInfo)loginfoList.get(i);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(this.getOperationName(neid, subfunc));
                loginfo.setOperateObject(operObj);
                loginfo.setOperateDesc(this.getOperationDescribtion());
                TELogMgr.writeLog((TELogInfo)loginfoList.get(i));
            }
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public abstract String getOperationDescribtion();

    public String getOperationName(int neid, SubFunc subfunc) {
        return subfunc.getSubFuncDes(neid);
    }
}

