/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.command.CommandReflection;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEParseWriteLogFile {
    private static TEParseWriteLogFile instance = new TEParseWriteLogFile();
    private static Map<String, Map<String, Node>> logFuncNodeMap = new Hashtable<String, Map<String, Node>>();
    private static final String FILE_NAME = "writelog.xml";

    private TEParseWriteLogFile() {
    }

    public static TEParseWriteLogFile getInstance() {
        return instance;
    }

    private static void parseXMLFile(int neid) {
        Document doc = null;
        try {
            int neType = TENEListMgr.getInstance().getNE(neid).getNEType();
            String domain = TEGetNEDomainVersion.getInstance().getDomain(neType);
            String filePath = TEResourceManager.getPath() + "nemgr" + File.separator + "device" + File.separator + domain + File.separator + "conf" + File.separator + FILE_NAME;
            doc = TEParseXMLFile.parseFile(filePath);
            if (null == doc) {
                TELogFactory.getNormalLogger().info("Parse log file fail!");
                return;
            }
            Hashtable<String, Node> funcMap = new Hashtable<String, Node>();
            Element root = doc.getDocumentElement();
            NodeList children = root.getChildNodes();
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node aNode = children.item(i);
                if (!(aNode instanceof Element)) continue;
                String nodeName = aNode.getNodeName();
                if (nodeName.contains("fun_")) {
                    funcMap.put(nodeName, aNode);
                    continue;
                }
                funcMap.put(String.valueOf(CommandReflection.getCode(nodeName)), aNode);
            }
            logFuncNodeMap.put(domain, funcMap);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Get log info failed", (Throwable)e);
        }
    }

    public Node getNodeByFuncCode(int neid, int funcCode) {
        int neType = TENEListMgr.getInstance().getNE(neid).getNEType();
        String domain = TEGetNEDomainVersion.getInstance().getDomain(neType);
        if (!logFuncNodeMap.containsKey(domain)) {
            TEParseWriteLogFile.parseXMLFile(neid);
        }
        Map<String, Node> funcMap = logFuncNodeMap.get(domain);
        Node returnNode = null;
        if (funcMap != null) {
            returnNode = funcMap.get(String.valueOf(funcCode));
        }
        return returnNode;
    }

    public Node getNodeByFuncCode(int neid, int funID, int funcCode) {
        if (funID == 0) {
            return this.getNodeByFuncCode(neid, funcCode);
        }
        int neType = TENEListMgr.getInstance().getNE(neid).getNEType();
        String domain = TEGetNEDomainVersion.getInstance().getDomain(neType);
        if (!logFuncNodeMap.containsKey(domain)) {
            TEParseWriteLogFile.parseXMLFile(neid);
        }
        Map<String, Node> funcMap = logFuncNodeMap.get(domain);
        Node returnNode = null;
        if (funcMap != null) {
            String key = "fun_" + funID + "_" + funcCode;
            returnNode = funcMap.get(key);
        }
        return returnNode;
    }
}

