/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.cbb.log.TEWriteLogInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public abstract class TEMultiWriteLogCommonImpl
implements TEWriteLogInterface {
    @Override
    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            RowParams rowparams = null;
            RowParams errorRowParams = null;
            int tmpErrorCode = 0;
            int len = inputData.getBussinessParams().getRowParamsCount();
            for (i = 1; i < len; ++i) {
                loginfo = new TELogInfo();
                rowparams = inputData.getBussinessParams().getRowParams(i);
                loginfo.setOperateDesc(this.getOperationDescribtion(rowparams));
                if (errorCode != 0 && errorCode != 2 && errorCode != 1) {
                    loginfo.setResult(2);
                    loginfo.setErrCode(errorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                } else if (errorCode == 0) {
                    loginfo.setResult(0);
                    loginfo.setErrCode(errorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                } else {
                    int outputRowCount = outputData.getBussinessParams().getRowParamsCount();
                    if (outputRowCount == 0) {
                        TELogFactory.getNormalLogger().error("outputData.getBussinessParams().getRowParamsCount() == 0");
                        continue;
                    }
                    errorRowParams = outputData.getBussinessParams().getRowParams(outputRowCount - 1);
                    tmpErrorCode = this.getOperationResult(rowparams, errorRowParams);
                    if (tmpErrorCode != 0) {
                        loginfo.setResult(2);
                    } else {
                        loginfo.setResult(0);
                    }
                    loginfo.setErrCode(tmpErrorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(tmpErrorCode));
                }
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                loginfo = (TELogInfo)loginfoList.get(i);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(subfunc.getSubFuncDes(neid));
                loginfo.setOperateObject(operObj);
                TELogMgr.writeLog((TELogInfo)loginfoList.get(i));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public abstract String getOperationDescribtion(RowParams var1);

    public abstract int getOperationResult(RowParams var1, RowParams var2);

    public String getOperationName(int neid, SubFunc subfunc) {
        return subfunc.getSubFuncDes(neid);
    }
}

