/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TEOperCmdType;
import com.huawei.nglct.cbb.log.TEStaticLogCmd;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.platformadapter.asn.AsnBatchWriteLog;
import com.huawei.uflight.platformadapter.asn.AsnBatchWriteLogSeqOf;
import com.huawei.uflight.platformadapter.asn.AsnLogInfo;
import com.huawei.uflight.platformadapter.asn.DateTimeType;
import com.huawei.uflight.platformadapter.asn.SessionUserID;
import com.huawei.uflight.security.operlogmgr.api.OperLogInfo;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SimpleTimeZone;
import net.commustru.fstru.FStruct;

public class TELogUtil {
    private static Set<Integer> SFID_IN_OR_OUT_XML_CONTAINS_PWD = new HashSet<Integer>();
    private static Set<Integer> SFID_IMPORTANCE = new HashSet<Integer>();
    private static final int LOG_CMD_BATCH_WRITE_LOG = 1204;
    private static final int EI_SUCCESS = 0;
    private static final int LOG_CLASS = 1;
    private static final int PROC_ID_SEC = 52;

    protected static int writeLogOfIntegeration(TELogInfo logInfo) {
        int succeed = 0;
        if (1 != TELogUtil.batchWriteLogUseAsn(logInfo)) {
            succeed = 1;
        }
        return succeed;
    }

    protected static void batchWriteLogListUseAsn(ArrayList<TELogInfo> logInfoList) {
        List<OperLogInfo> operLogInfoList = TELogUtil.handleLogInfoList(logInfoList);
        AsnBatchWriteLog asnReqLog = new AsnBatchWriteLog();
        AsnBatchWriteLogSeqOf asnSeqOf = new AsnBatchWriteLogSeqOf();
        int size = operLogInfoList.size();
        for (int i = 0; i < size; ++i) {
            OperLogInfo logInfo = operLogInfoList.get(i);
            AsnLogInfo asnLogInfo = TELogUtil.getAsnLogInfo(logInfo);
            if (i == 0) {
                SessionUserID reqSessionID = new SessionUserID();
                reqSessionID.userID = BigInteger.valueOf(logInfo.getUserID());
                reqSessionID.sessionID = BigInteger.valueOf(0L);
                asnReqLog.sessionUserID = reqSessionID;
            }
            asnSeqOf.add((Object)asnLogInfo);
        }
        asnReqLog.logList = asnSeqOf;
        try {
            int result = TELogUtil.sendAsyncMessageUseCmdCode(1204, (FStruct)asnReqLog, 10000);
            if (0 == result) {
                TELogFactory.getNormalLogger().info("Batch write log success.result=" + result);
            } else {
                TELogFactory.getNormalLogger().info("Batch write log fail. There is no response message.result=" + result);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
    }

    private static AsnLogInfo getAsnLogInfo(OperLogInfo logInfo) {
        AsnLogInfo asnLogInfo = new AsnLogInfo();
        asnLogInfo.userID = BigInteger.valueOf(logInfo.getUserID());
        asnLogInfo.ipAddr = BigInteger.valueOf(IPAddressUtil.convertIPStrToLong(logInfo.getLocation()));
        asnLogInfo.oTID = new BigInteger(Integer.toString(logInfo.getTid()));
        asnLogInfo.oTSID = BigInteger.valueOf(logInfo.getSid());
        asnLogInfo.cmdID = BigInteger.valueOf(logInfo.getCmdID());
        if (logInfo.getOperateDesc() == null) {
            logInfo.setOperateDesc("");
        }
        asnLogInfo.operDesc = logInfo.getOperateDesc().getBytes(Charset.forName("UTF-8"));
        if (logInfo.getOperateObject() == null) {
            logInfo.setOperateObject("");
        }
        asnLogInfo.operteObject = logInfo.getOperateObject().getBytes(Charset.forName("UTF-8"));
        asnLogInfo.result = new BigInteger(Integer.toString(logInfo.getResult()));
        asnLogInfo.errorcode = new BigInteger(Integer.toString(logInfo.getErrCode()));
        asnLogInfo.nLogType = new BigInteger(Integer.toString(0));
        asnLogInfo.nLogGroupID = new BigInteger(Integer.toString(0));
        DateTimeType operateTime = new DateTimeType();
        Calendar todaysDate = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        operateTime.year = BigInteger.valueOf(todaysDate.get(1));
        operateTime.month = BigInteger.valueOf(todaysDate.get(2) + 1);
        operateTime.day = BigInteger.valueOf(todaysDate.get(5));
        operateTime.hour = BigInteger.valueOf(todaysDate.get(11));
        operateTime.minute = BigInteger.valueOf(todaysDate.get(12));
        operateTime.second = BigInteger.valueOf(todaysDate.get(13));
        asnLogInfo.operateTime = operateTime;
        asnLogInfo.nLogClass = new BigInteger(Integer.toString(1));
        return asnLogInfo;
    }

    private static List<OperLogInfo> handleLogInfoList(ArrayList<TELogInfo> logInfoList) {
        ArrayList<OperLogInfo> operLogInfoList = new ArrayList<OperLogInfo>();
        int size = logInfoList.size();
        for (int i = 0; i < size; ++i) {
            TELogInfo logInfo = logInfoList.get(i);
            TEOperCmdType cmdType = TEStaticLogCmd.getInstance().getCmdType(logInfo.getCmdID());
            if (cmdType == null) {
                logInfo.setOTID(4);
                logInfo.setOSTID(1);
            } else {
                logInfo.setOTID(cmdType.objectTID);
                logInfo.setOSTID(cmdType.objectSubTID);
            }
            operLogInfoList.add(TELogUtil.convertTELogToOperLog(logInfo));
        }
        return operLogInfoList;
    }

    public static int batchWriteLogUseAsn(TELogInfo logInfo) {
        TEOperCmdType cmdType = TEStaticLogCmd.getInstance().getCmdType(logInfo.getCmdID());
        if (cmdType == null) {
            logInfo.setOTID(4);
            logInfo.setOSTID(1);
        } else {
            logInfo.setOTID(cmdType.objectTID);
            logInfo.setOSTID(cmdType.objectSubTID);
        }
        OperLogInfo operLogInfo = TELogUtil.convertTELogToOperLog(logInfo);
        return TELogUtil.batchWriteLogUseAsn(operLogInfo);
    }

    public static int batchWriteLogUseAsn(OperLogInfo logInfo) {
        int writeLogResult = 1;
        try {
            AsnBatchWriteLog asnReqLog = new AsnBatchWriteLog();
            AsnBatchWriteLogSeqOf asnSeqOf = new AsnBatchWriteLogSeqOf();
            AsnLogInfo asnLogInfo = TELogUtil.getAsnLogInfo(logInfo);
            SessionUserID reqSessionID = new SessionUserID();
            reqSessionID.userID = BigInteger.valueOf(logInfo.getUserID());
            reqSessionID.sessionID = BigInteger.valueOf(0L);
            asnReqLog.sessionUserID = reqSessionID;
            asnSeqOf.add((Object)asnLogInfo);
            asnReqLog.logList = asnSeqOf;
            int result = TELogUtil.sendAsyncMessageUseCmdCode(1204, (FStruct)asnReqLog, 5000);
            if (0 == result) {
                TELogFactory.getNormalLogger().info("batchWriteLogMDP start batchWriteLogMDP sucess");
                writeLogResult = 0;
            } else {
                TELogFactory.getNormalLogger().info("batchWriteLogMDP start batchWriteLogMDP error. There is no response message.");
                writeLogResult = 1;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
        return writeLogResult;
    }

    public static int sendAsyncMessageUseCmdCode(int cmdCode, FStruct req, int timeOut) {
        MSGHead msgHead = MSGHeadBuilder.createMSGHead((int)cmdCode);
        msgHead.receiverProcID = (char)52;
        msgHead.receiverProcHandle = '\u0000';
        msgHead.receiverModule = 0;
        return TEASN1CommMgr.sendAsyncRequest(msgHead, req, timeOut);
    }

    public static OperLogInfo convertTELogToOperLog(TELogInfo logInfo) {
        if (null == logInfo) {
            return null;
        }
        int errCode = logInfo.getResult();
        OperLogInfo operLog = new OperLogInfo();
        operLog.setCmdID(logInfo.getCmdID());
        operLog.setUserID(logInfo.getUserID());
        operLog.setLocation(logInfo.getLocation());
        operLog.setOperateName(logInfo.getOperateName());
        operLog.setOperateObject(logInfo.getOperateObject());
        operLog.setOperateDesc(logInfo.getOperateDesc());
        if (null == logInfo.getOperateResult() || logInfo.getOperateResult().isEmpty()) {
            String errStr = TEErrorResourceUtil.getErrCodeResWithDot(errCode);
            operLog.setOperateResult(errStr);
        } else {
            operLog.setOperateResult(logInfo.getOperateResult());
        }
        operLog.setResult(errCode);
        operLog.setErrCode(logInfo.getErrCode());
        operLog.setOperateTime(logInfo.getOperateTime());
        operLog.setUserName(logInfo.getUserName());
        operLog.setSid(logInfo.getOSTID());
        operLog.setTid(logInfo.getOTID());
        operLog.setErrInfo(logInfo.getErrInfo());
        return operLog;
    }

    public static TELogInfo convertOperLogToTELog(OperLogInfo operLogInfo) {
        if (null == operLogInfo) {
            return null;
        }
        TELogInfo logInfo = new TELogInfo();
        logInfo.setCmdID(operLogInfo.getCmdID());
        logInfo.setUserID(operLogInfo.getUserID());
        logInfo.setLocation(operLogInfo.getLocation());
        logInfo.setOperateName(operLogInfo.getOperateName());
        logInfo.setOperateObject(operLogInfo.getOperateObject());
        logInfo.setOperateDesc(operLogInfo.getOperateDesc());
        logInfo.setOperateResult(operLogInfo.getOperateResult());
        logInfo.setErrCode(operLogInfo.getErrCode());
        logInfo.setOperateTime(operLogInfo.getOperateTime());
        logInfo.setUserName(operLogInfo.getUserName());
        logInfo.setOSTID((int)operLogInfo.getSid());
        logInfo.setOTID(operLogInfo.getTid());
        logInfo.setErrInfo(operLogInfo.getErrInfo());
        return logInfo;
    }

    public static List<TELogInfo> convertTELogList(List<OperLogInfo> operLogInfoList) {
        ArrayList<TELogInfo> logInfoList = new ArrayList<TELogInfo>();
        if (null == operLogInfoList || operLogInfoList.isEmpty()) {
            return logInfoList;
        }
        TELogInfo logInfo = null;
        for (OperLogInfo operLogInfo : operLogInfoList) {
            logInfo = TELogUtil.convertOperLogToTELog(operLogInfo);
            if (null == logInfo) continue;
            logInfoList.add(logInfo);
        }
        return logInfoList;
    }

    public static String getOperationResultDes(TELogInfo logInfo) {
        if (null == logInfo) {
            return "";
        }
        TEResourceUtil res = null;
        StringBuffer filePath = new StringBuffer();
        filePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append("funcdesres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        res = TEResourceUtil.getInstance(filePath.toString());
        int errCode = logInfo.getErrCode();
        String errStr = TEErrorResourceUtil.getErrCodeResWithDot(errCode);
        int result = logInfo.getResult();
        if (1 == result) {
            errStr = errStr + "(" + res.getString("ERRORCODE") + errCode + ")";
        } else if (2 == result) {
            errStr = errStr + "(" + res.getString("ERRORCODE") + errCode + ")";
        }
        return errStr;
    }

    public static boolean isContainsPasswordPrint(int sfid) {
        return SFID_IN_OR_OUT_XML_CONTAINS_PWD.contains(sfid);
    }

    public static boolean isContainsImportancePrint(int sfid) {
        return SFID_IMPORTANCE.contains(sfid);
    }

    static {
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(12288);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(12290);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(1025);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(67056);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(67057);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2179679);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2179683);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2139392);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2117651);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2556058);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2556059);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(0x202332);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2106165);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2556063);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2106168);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2132438);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2167973);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(0x202333);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2179530);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2179531);
        SFID_IN_OR_OUT_XML_CONTAINS_PWD.add(2179532);
        SFID_IMPORTANCE.add(2555987);
        SFID_IMPORTANCE.add(2179826);
    }
}

