/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TESplitPageBean;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class TELogServlet
extends HttpServlet {
    private static final long serialVersionUID = 1262899679635664131L;
    private static Logger log = TELogFactory.getNormalLogger();

    public void init() throws ServletException {
        super.init();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Datainterface inputData = null;
        Datainterface outputData = null;
        Datainterface allData = null;
        int sfid = -1;
        int flag = -1;
        try {
            String inputDataStr = request.getParameter("inputdata");
            flag = Integer.parseInt(request.getParameter("flag"));
            sfid = Integer.parseInt(request.getParameter("sfid"));
            StringReader r = new StringReader(inputDataStr);
            inputData = Datainterface.unmarshal(r);
            TELogMgr logMgr = new TELogMgr();
            if (1 == flag) {
                allData = logMgr.queryLog(inputData);
            } else if (0 == flag) {
                allData = (Datainterface)request.getSession().getAttribute("" + sfid);
            } else {
                log.error("get flag error\u00a3\u00ba" + flag);
                return;
            }
            if (null != inputData.getPageParams()) {
                if (1 == flag) {
                    request.getSession().setAttribute("" + sfid, (Object)allData);
                }
                outputData = TESplitPageBean.getSplitPageData(allData, inputData.getPageParams(), TECreateObjectFactory.getSubFunc(sfid));
            } else {
                outputData = allData;
            }
            response.setContentType("text/xml;charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            StringWriter out = new StringWriter();
            outputData.marshal(out);
            response.getWriter().println(((Object)out).toString());
            ((Writer)out).close();
            response.getWriter().close();
        }
        catch (Exception e) {
            log.error("program inner error\u00a3\u00ba\n", (Throwable)e);
            outputData = new Datainterface();
            StringWriter out = new StringWriter();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            try {
                outputData.marshal(out);
                response.getWriter().println(((Object)out).toString());
                TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nReturn page's XML Data is \u00a3\u00ba" + ((Object)out).toString());
            }
            catch (Exception ex) {
                log.error("Parse fail\u00a3\u00ba", (Throwable)ex);
                return;
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
        super.destroy();
    }
}

