/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.nglct.cbb.log.TELogComparator;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogUtil;
import com.huawei.nglct.cbb.log.TEOperCmdType;
import com.huawei.nglct.cbb.log.TESOperateLogInfor;
import com.huawei.nglct.cbb.log.TEStaticLogCmd;
import com.huawei.nglct.cbb.log.t2kinterface.TEInterfaceProcess;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.communication.DebugTracer;
import com.huawei.nglct.core.necoordinator.TENEIDCacheMgr;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.device.ne.TENEUtils;
import com.huawei.nglct.util.device.ne.TENMUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.security.operlogmgr.api.FilterCondition;
import com.huawei.uflight.security.operlogmgr.api.OperLogInfo;
import com.huawei.uflight.security.operlogmgr.api.OperLoggerMgr;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class TELogMgr
implements TENEMgrInterface {
    private static final DeploymentMode RUN_SINGLE = DeploymentMode.independent;
    private static final DeploymentMode RUN_INTEGERATION = DeploymentMode.integrated;
    private static final int NAME_MAX_LENGTH = 64;
    private static TESysManagerBean sysManager = TESysManagerBean.getInstance();
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static void writeLog(TELogInfo logInfo) {
        TELogMgr logMgr = new TELogMgr();
        DeploymentMode runningStatus = sysManager.getSysStauts();
        TELogFactory.getNormalLogger().info("Operation log infomation is " + logInfo);
        TELogFactory.getNormalLogger().info("Running Status = " + runningStatus);
        if (RUN_SINGLE.equals((Object)runningStatus)) {
            logMgr.writeLogOfSingle(logInfo);
        } else if (RUN_INTEGERATION.equals((Object)runningStatus)) {
            TELogUtil.writeLogOfIntegeration(logInfo);
        }
    }

    public static void writeLog(ArrayList<TELogInfo> logInfoList) {
        TELogMgr logMgr = new TELogMgr();
        DeploymentMode runningStatus = sysManager.getSysStauts();
        TELogFactory.getNormalLogger().info("Running Status = " + runningStatus);
        if (RUN_SINGLE.equals((Object)runningStatus)) {
            int size = logInfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogInfo logInfo = logInfoList.get(i);
                TELogFactory.getNormalLogger().info("Operation log infomation is " + logInfo);
                logMgr.writeLogOfSingle(logInfo);
            }
        } else if (RUN_INTEGERATION.equals((Object)runningStatus)) {
            TELogUtil.batchWriteLogListUseAsn(logInfoList);
        }
    }

    private void writeLogOfSingle(TELogInfo logInfo) {
        if (null == logInfo || null == logInfo.getOperateName() || "".equals(logInfo.toString())) {
            return;
        }
        if (logInfo.getOperateName() == null || logInfo.getOperateName().equals("")) {
            return;
        }
        OperLogInfo operLogInfo = TELogUtil.convertTELogToOperLog(logInfo);
        if (null == operLogInfo) {
            return;
        }
        OperLoggerMgr.writeLog((OperLogInfo)operLogInfo);
    }

    public Datainterface queryLog(Datainterface inputData) {
        Datainterface outputData = new Datainterface();
        if (null == inputData) {
            return outputData;
        }
        Map<String, String> paramMap = this.parseInputData(inputData);
        FilterCondition condition = this.getFilterCondition(paramMap);
        if (null == condition) {
            return outputData;
        }
        List operLogInfoList = OperLoggerMgr.queryLog((FilterCondition)condition);
        List<TELogInfo> logInfoList = TELogUtil.convertTELogList(operLogInfoList);
        TELogComparator logComp = new TELogComparator();
        logComp.setOrder(Integer.parseInt(paramMap.get("order")));
        logComp.setOrderByCol(Integer.parseInt(paramMap.get("orderByCol")));
        Collections.sort(logInfoList, logComp);
        TELogInfo logInfo = null;
        BussinessParams bussiness = new BussinessParams();
        int size = logInfoList.size();
        for (int i = 0; i < size; ++i) {
            logInfo = logInfoList.get(i);
            RowParams row = new RowParams();
            Param operNameP = new Param();
            operNameP.setName("operName");
            operNameP.setValue(logInfo.getOperateName());
            row.addParam(operNameP);
            Param userNameP = new Param();
            userNameP.setName("userName");
            userNameP.setValue(logInfo.getUserName());
            row.addParam(userNameP);
            Param timeParam = new Param();
            timeParam.setName("oprationTime");
            Calendar calendar = TEDateUtils.strToCalendar(logInfo.getOperateTime(), DEFAULT_DATE_FORMAT);
            if (null != calendar) {
                SimpleDateFormat format = new SimpleDateFormat(TimeZoneDateBean.getTimeConvertFormat(), Locale.ENGLISH);
                String operate_Time = format.format(calendar.getTime());
                timeParam.setValue(operate_Time);
            } else {
                timeParam.setValue(logInfo.getOperateTime());
            }
            row.addParam(timeParam);
            Param terminal = new Param();
            terminal.setName("operationTerminal");
            terminal.setValue(logInfo.getLocation() == null ? "127.0.0.1" : logInfo.getLocation());
            row.addParam(terminal);
            Param operationObj = new Param();
            operationObj.setName("operationObj");
            operationObj.setValue(logInfo.getOperateObject());
            row.addParam(operationObj);
            Param operationDesc = new Param();
            operationDesc.setName("oprationDescription");
            operationDesc.setValue(logInfo.getOperateDesc());
            row.addParam(operationDesc);
            Param errorDesc = new Param();
            errorDesc.setName("errorDescription");
            String errorInfo = logInfo.getErrInfo();
            if (null == errorInfo || "".equals(errorInfo)) {
                errorInfo = TELogUtil.getOperationResultDes(logInfo);
            }
            errorDesc.setValue(errorInfo);
            row.addParam(errorDesc);
            Param operationResult = new Param();
            operationResult.setName("operationResult");
            String operRes = logInfo.getOperateResult();
            if (null == operRes || "".equals(operRes)) {
                operRes = TEErrorResourceUtil.getErrCodeResWithDot(logInfo.getResult());
            }
            operationResult.setValue(operRes);
            row.addParam(operationResult);
            bussiness.addRowParams(row);
        }
        outputData.setBussinessParams(bussiness);
        ErrorMessage errorMsg = TEErrorResourceUtil.getErrorMessage(0);
        outputData.setErrorMessage(errorMsg);
        return outputData;
    }

    private FilterCondition getFilterCondition(Map<String, String> paramMap) {
        if (null == paramMap || paramMap.isEmpty()) {
            return null;
        }
        FilterCondition condition = new FilterCondition();
        condition.setStartTime(this.getTime(paramMap.get("startTime")));
        condition.setEndTime(this.getTime(paramMap.get("endTime")));
        String tmpStr = paramMap.get("userName");
        if ("".equals(tmpStr)) {
            tmpStr = null;
        }
        condition.setUserName(tmpStr);
        tmpStr = paramMap.get("operobj");
        if ("".equals(tmpStr)) {
            tmpStr = null;
        }
        condition.setOperateObject(tmpStr);
        tmpStr = paramMap.get("operresult");
        if ("".equals(tmpStr)) {
            tmpStr = null;
        }
        condition.setOperateResult(tmpStr);
        return condition;
    }

    private Date getTime(String timeStr) {
        if (null == timeStr || "".equals(timeStr)) {
            return null;
        }
        Calendar calendar = TEDateUtils.strToCalendar(timeStr, DEFAULT_DATE_FORMAT);
        return calendar.getTime();
    }

    @Override
    public Datainterface performBussinessProcess(int neID, SubFunc subFuc, Datainterface inputData, Datainterface MemoryData, String user, String ipAddress) {
        return this.queryLog(inputData);
    }

    @Override
    public boolean isNeedOperationlog() {
        return false;
    }

    public static int writeOperationLog(TESOperateLogInfor sOperateLog) {
        if (sOperateLog.cmd == 0) {
            DebugTracer.trace("\n Operation Log Input Parameter Illigal:nCmd=0!!!\n");
            return -2;
        }
        if (sOperateLog.type > 7 || sOperateLog.type < 0) {
            DebugTracer.trace("\n Operation Log Input Parameter Illigal:log.nType>7 or log.nType<0!!!\n");
            return -2;
        }
        if (sOperateLog.userId == 0 && sOperateLog.ipAddr == 0) {
            return 0;
        }
        TELogInfo logInfo = new TELogInfo();
        logInfo.setUserID(sOperateLog.userId);
        logInfo.setLocation(TopoUtility.ipToString(sOperateLog.ipAddr));
        logInfo.setCmdID(sOperateLog.cmd);
        if (sOperateLog.result == 0) {
            logInfo.setResult(0);
        } else if (sOperateLog.result == 86017) {
            logInfo.setResult(1);
        } else {
            logInfo.setResult(2);
        }
        logInfo.setErrCode(sOperateLog.result);
        String operInfo = sOperateLog.operInfo != null && sOperateLog.operInfo.length() > 255 ? sOperateLog.operInfo.substring(0, 255) : sOperateLog.operInfo;
        logInfo.setOperateDesc(operInfo);
        TEOperCmdType cmdType = TEStaticLogCmd.getInstance().getCmdType(sOperateLog.cmd);
        if (cmdType == null) {
            logInfo.setOTID(4);
            logInfo.setOSTID(1);
        } else {
            logInfo.setOTID(cmdType.objectTID);
            logInfo.setOSTID(cmdType.objectSubTID);
        }
        switch (sOperateLog.type) {
            case 3: {
                if (sOperateLog.neId == 0) break;
                StringBuffer name = new StringBuffer();
                int errcode = sOperateLog.neId == 1 ? TENMUtil.getNMName(sOperateLog.neId, name, false) : TENEUtils.getNEName(sOperateLog.neId, name, false);
                if (errcode == 0) {
                    int len = name.length();
                    if (len > 64) {
                        name.setLength(64);
                    }
                    logInfo.setOperateObject(name.toString());
                    break;
                }
                return -1;
            }
            case 4: {
                if (sOperateLog.neId == 0) break;
                StringBuffer name = new StringBuffer();
                int errcode = sOperateLog.neId == 1 ? TENMUtil.getNMName(sOperateLog.neId, name, false) : TENEUtils.getNEName(sOperateLog.neId, name, false);
                if (errcode == 0) {
                    int len = name.length();
                    if (len > 64) {
                        name.setLength(64);
                    }
                    logInfo.setOperateObject(name.toString());
                    break;
                }
                return -1;
            }
            case 5: {
                int len = 0;
                StringBuffer name = new StringBuffer();
                if (sOperateLog.neId == 0) {
                    name.append("Network");
                    logInfo.setOperateObject("");
                    break;
                }
                if (0 == TENEUtils.getNEName(sOperateLog.neId, name, false)) {
                    len = name.length();
                }
                if (len > 64) {
                    len = 64;
                }
                logInfo.setOperateObject(name.toString());
                if (len != 0) break;
                return -1;
            }
            default: {
                return -2;
            }
        }
        return TEInterfaceProcess.writeLog(logInfo) ? 0 : -1;
    }

    public Map<String, String> parseInputData(Datainterface inputData) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        BussinessParams bussParams = inputData.getBussinessParams();
        for (int i = 0; i < bussParams.getRowParamsCount(); ++i) {
            RowParams rowParam = bussParams.getRowParams(i);
            paramMap.put("startTime", rowParam.getParam("startTime").getValue());
            paramMap.put("endTime", rowParam.getParam("endTime").getValue());
            paramMap.put("userName", rowParam.getParam("userName").getValue());
            paramMap.put("operobj", rowParam.getParam("operobj").getValue());
            String errStr = "";
            if (!rowParam.getParam("operresult").getValue().isEmpty()) {
                int errCode = Integer.valueOf(rowParam.getParam("operresult").getValue());
                errStr = TEErrorResourceUtil.getErrCodeResWithDot(errCode);
            }
            paramMap.put("operresult", errStr);
            paramMap.put("order", rowParam.getParam("order").getValue());
            paramMap.put("orderByCol", rowParam.getParam("orderByCol").getValue());
        }
        return paramMap;
    }

    public static void writeOperationLog(MSGPacketExt msg, int userID, int neID, int result, String detailInfo) {
        TELogMgr.writeNEOpLog(4, msg, userID, neID, result, detailInfo);
    }

    public static void writeOperationLog(MSGPacketExt msg, int userID, int equipType, int ulID, String equipName, int result, String detailInfo, int OTID, int phyDevID, int senderIP, int type, ResourceBundle res) {
        TESOperateLogInfor logInfo = new TESOperateLogInfor();
        logInfo.neId = ulID;
        logInfo.userId = userID;
        logInfo.ipAddr = msg.mheader.senderProcIP;
        logInfo.cmd = msg.getCmdCode();
        logInfo.OTID = OTID;
        logInfo.type = type;
        if (senderIP != 0) {
            logInfo.ipAddr = senderIP;
        }
        logInfo.OSTID = 1;
        logInfo.operateObject = TEStringUtils.strncpy(equipName, 64);
        logInfo.result = result == 0 ? 0 : 2;
        logInfo.errorCode = result;
        if (TELogMgr.isRealNE(equipType)) {
            int phyID;
            int tl1ID = phyID = TENEIDCacheMgr.getInstance().getPhyID(ulID);
            if (phyID == 0 && phyDevID != -1) {
                tl1ID = phyID = phyDevID;
            }
            String sNEID = TEStringUtils.getString(res.getString("CFG_NEID"));
            if ((tl1ID & 0x4000000) != 0) {
                if (detailInfo != null) {
                    logInfo.operateDesc = TEStringUtils.snprintf(255, "%s", detailInfo);
                }
            } else {
                logInfo.operateDesc = detailInfo != null ? TEStringUtils.snprintf(255, "%s%d-%d %s", sNEID, phyID >> 16, phyID & 0xFFFF, detailInfo) : TEStringUtils.snprintf(255, "%s%d-%d", sNEID, phyID >> 16, phyID & 0xFFFF);
            }
        } else {
            switch (equipType) {
                case 1873: {
                    if (logInfo.cmd == 2109446) {
                        logInfo.cmd = 0x202100;
                    }
                    if (detailInfo != null) {
                        logInfo.operateDesc = TEStringUtils.snprintf(255, "nmid:%d %s", ulID, detailInfo);
                        break;
                    }
                    logInfo.operateDesc = TEStringUtils.snprintf(255, "nmid:%d", ulID);
                    break;
                }
                case 254: 
                case 1891: 
                case 1892: 
                case 1893: 
                case 1898: {
                    if (detailInfo != null) {
                        logInfo.operateDesc = TEStringUtils.snprintf(255, "dwdmid:0x%x  %s", ulID, detailInfo);
                        break;
                    }
                    logInfo.operateDesc = TEStringUtils.snprintf(255, "dwdmid:0x%x", ulID);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        TELogMgr.writeOperationLog(logInfo);
    }

    public static int writeNEOpLog(int opType, MSGPacketExt msg, int userID, int neID, int errCode, String detailInfo) {
        return TELogMgr.writeNEOpLog(opType, msg.mheader.senderProcIP, msg.getCmdCode(), userID, neID, errCode, detailInfo);
    }

    public static int writeNEOpLog(int opType, int ipAddr, int cmdCode, int userID, int neID, int errCode, String detailInfo) {
        TESOperateLogInfor info = new TESOperateLogInfor();
        info.userId = userID;
        info.ipAddr = ipAddr;
        info.cmd = cmdCode;
        info.type = opType;
        info.neId = neID;
        info.result = errCode;
        info.operInfo = detailInfo;
        return TELogMgr.writeOperationLog(info);
    }

    protected static boolean isRealNE(int equipmentType) {
        return true;
    }
}

