/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.cbb.log.TEParseWriteLogFile;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.security.TESecurityVerify;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TECommonWriteLogBean
extends TENEExplorerBean {
    private static final int QUERY_RESULT_NULL = 38662;
    private static final int QUERY_RESULT_NULL_COM = 38917;

    @Override
    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(38917);
        if (this.subfunc != null && this.subfunc.getFilterErrCodeList() != null && !this.subfunc.getFilterErrCodeList().isEmpty()) {
            list.addAll(this.subfunc.getFilterErrCodeList());
        }
        return list;
    }

    @Override
    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = TESecurityVerify.getSuperUserID();
                }
            }
            this.subfunc = subfunc;
            this.outputData = outputData;
            String operObj = this.getOperObj();
            String operName = this.getOperateName();
            List<TELogInfo> loginfoList = this.getLogInfoList(inputData);
            TELogInfo loginfo = null;
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                loginfo = loginfoList.get(i);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(operName);
                loginfo.setOperateObject(operObj);
                TELogMgr.writeLog(loginfoList.get(i));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    protected String getOperObj() {
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        String operObj = String.valueOf(this.neid);
        if (null != neObj) {
            operObj = neObj.getNEName();
        }
        return operObj;
    }

    protected String getOperateName() {
        return this.subfunc.getSubFuncDes(this.neid);
    }

    protected boolean isSingletonLog() {
        return false;
    }

    public List<TELogInfo> getLogInfoList(Datainterface inputData) {
        if (this.isSingletonLog()) {
            return this.getSingletonLogInfo(inputData);
        }
        Node currFuncNode = TEParseWriteLogFile.getInstance().getNodeByFuncCode(this.neid, this.subfunc.getCode());
        if (null == currFuncNode) {
            return this.getMultiLogInfoList(inputData);
        }
        Node singletonNode = currFuncNode.getAttributes().getNamedItem("singleton");
        if (singletonNode != null && singletonNode.getNodeValue().equals("true")) {
            return this.getSingletonLogInfo(inputData);
        }
        return this.getMultiLogInfoList(inputData);
    }

    public List<TELogInfo> getMultiLogInfoList(Datainterface inputData) {
        ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
        RowParams rowparams = null;
        RowParams errorRowParams = null;
        TELogInfo loginfo = null;
        int errorCode = null == this.outputData.getErrorMessage() || null == this.outputData.getErrorMessage().getErrorcode() || "".equals(this.outputData.getErrorMessage()) ? 0 : Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        int len = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            loginfo = new TELogInfo();
            rowparams = inputData.getBussinessParams().getRowParams(i);
            loginfo.setOperateDesc(this.getDetailInfo(new RowParams[]{rowparams}));
            Param logFlag = rowparams.getParam("isNoLog");
            if (null != logFlag && "1".equals(logFlag.getValue())) continue;
            if (errorCode != 0 && errorCode != 2 && errorCode != 1) {
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
            } else if (errorCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
            } else {
                int outputRowCount = this.outputData.getBussinessParams().getRowParamsCount();
                errorRowParams = this.outputData.getBussinessParams().getRowParams(outputRowCount - 1);
                int errorCodeTmp = this.getOperResult(rowparams, errorRowParams);
                if (errorCode == 0) {
                    loginfo.setResult(0);
                } else if (errorCodeTmp == 0) {
                    loginfo.setResult(0);
                } else {
                    loginfo.setResult(2);
                }
                loginfo.setErrCode(errorCodeTmp);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCodeTmp));
            }
            loginfoList.add(loginfo);
        }
        return loginfoList;
    }

    public List<TELogInfo> getSingletonLogInfo(Datainterface inputData) {
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
        TELogInfo loginfo = new TELogInfo();
        loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
        loginfo.setOperateName(this.subfunc.getSubFuncDes(this.neid));
        RowParams[] rParamsArr = inputData.getBussinessParams().getRowParams();
        loginfo.setOperateDesc(this.getSinleDetailInfo(rParamsArr));
        if (errorCode == 0) {
            loginfo.setResult(0);
            loginfo.setErrCode(0);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
            loginfoList.add(loginfo);
        } else if (errorCode == 2 || errorCode == 1) {
            loginfo.setResult(errorCode);
            if (null == this.outputData.getBussinessParams() || this.outputData.getBussinessParams().getRowParamsCount() == 0) {
                loginfo.setErrCode(errorCode);
            }
            int len = this.outputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                RowErrors[] rowErrors = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
                if (rowErrors.length <= 0) continue;
                loginfo.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                loginfo.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                loginfoList.add(loginfo);
                break;
            }
        } else {
            loginfo.setResult(2);
            loginfo.setErrCode(errorCode);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
            loginfoList.add(loginfo);
        }
        return loginfoList;
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        Node currFuncNode = TEParseWriteLogFile.getInstance().getNodeByFuncCode(this.neid, this.subfunc.getCode());
        TEResourceUtil res = this.parseResFile(currFuncNode);
        if (null == res) {
            return this.subfunc.getSubFuncDes(this.neid);
        }
        NodeList nodeList = currFuncNode.getChildNodes();
        int nodeListLength = nodeList.getLength();
        StringBuffer detailInfo = new StringBuffer();
        detailInfo.append(this.subfunc.getSubFuncDes(this.neid)).append(' ');
        for (int i = 0; i < nodeListLength; ++i) {
            Node aNode = nodeList.item(i);
            if (!(aNode instanceof Element) || !"logparam".equalsIgnoreCase(aNode.getNodeName())) continue;
            NamedNodeMap nodeMap = aNode.getAttributes();
            String paramName = nodeMap.getNamedItem("name").getNodeValue();
            String paramDes = res.getString(paramName);
            for (int j = 0; j < rParamsArr.length; ++j) {
                RowParams rowparams = rParamsArr[j];
                Param paramObj = rowparams.getParam(paramName);
                if (paramObj == null) {
                    if (TEStringUtils.isEmpty(paramDes) && nodeMap.getNamedItem("value") == null) continue;
                    if (paramName.equals("parseString") && nodeMap.getNamedItem("value") != null) {
                        String paramDefaultValue = nodeMap.getNamedItem("value").getNodeValue();
                        detailInfo.deleteCharAt(detailInfo.length() - 1);
                        detailInfo.append(paramDefaultValue);
                        continue;
                    }
                    if (nodeMap.getNamedItem("OperType") == null || !nodeMap.getNamedItem("OperType").getNodeValue().equals("operObj")) continue;
                    detailInfo.append(paramDes).append(':');
                    continue;
                }
                String paramValue = paramObj.getValue();
                Node convertNode = nodeMap.getNamedItem("convertTo");
                if (convertNode != null) {
                    String convertTo = convertNode.getNodeValue();
                    if ("SlotToName".equals(convertTo)) {
                        paramValue = TEBoardUtil.getShelfBoardName(this.neid, Integer.parseInt(paramObj.getValue()));
                    } else {
                        paramValue = res.getString(convertTo + "_" + paramValue);
                        if (paramValue.equals(convertTo + "_" + paramObj.getValue())) {
                            paramValue = paramObj.getValue();
                        }
                    }
                }
                if (!paramDes.equals(paramName)) {
                    detailInfo.append(paramDes);
                    if (paramDes.indexOf(":") != paramDes.length() - 1) {
                        detailInfo.append(':');
                    }
                }
                detailInfo.append(paramValue).append(';');
            }
        }
        return detailInfo.toString().substring(0, detailInfo.length() - 1);
    }

    public String getSinleDetailInfo(RowParams[] rParamsArr) {
        Node currFuncNode = TEParseWriteLogFile.getInstance().getNodeByFuncCode(this.neid, this.subfunc.getCode());
        TEResourceUtil res = this.parseResFile(currFuncNode);
        if (null == res) {
            return this.getDetailInfo(rParamsArr);
        }
        NodeList nodeList = currFuncNode.getChildNodes();
        int nodeListLength = nodeList.getLength();
        HashMap<String, NamedNodeMap> logParamList = new HashMap<String, NamedNodeMap>();
        for (int i = 0; i < nodeListLength; ++i) {
            Node aNode = nodeList.item(i);
            if (!(aNode instanceof Element) || !"logparam".equalsIgnoreCase(aNode.getNodeName())) continue;
            NamedNodeMap nodeMap = aNode.getAttributes();
            String paramName = nodeMap.getNamedItem("name").getNodeValue();
            logParamList.put(paramName, nodeMap);
        }
        StringBuffer detailInfo = new StringBuffer();
        if (0 != rParamsArr.length) {
            detailInfo.append(this.subfunc.getSubFuncDes(this.neid)).append(' ');
        }
        for (int j = 0; j < rParamsArr.length; ++j) {
            RowParams rowparams = rParamsArr[j];
            int logParamLen = rowparams.getParamCount();
            for (int i = 0; i < logParamLen; ++i) {
                String convertTo;
                Param paramObj = rowparams.getParam(i);
                String paramName = paramObj.getName();
                if (!logParamList.containsKey(paramName)) continue;
                String paramValue = paramObj.getValue();
                String paramDes = res.getString(paramName);
                Node convertNode = ((NamedNodeMap)logParamList.get(paramName)).getNamedItem("convertTo");
                if (convertNode != null && (paramValue = res.getString((convertTo = convertNode.getNodeValue()) + "_" + paramValue)).equals(convertTo + "_" + paramObj.getValue())) {
                    paramValue = paramObj.getValue();
                }
                if (!paramObj.getModifyFlag()) continue;
                if (!paramDes.equals(paramName)) {
                    detailInfo.append(paramDes).append(':');
                }
                detailInfo.append(paramValue).append(';');
            }
        }
        return detailInfo.toString().substring(0, detailInfo.length() - 1);
    }

    private TEResourceUtil parseResFile(Node currFuncNode) {
        if (null == currFuncNode) {
            return null;
        }
        NodeList nodeList = currFuncNode.getChildNodes();
        int nodeListLength = nodeList.getLength();
        String logResFilePath = "";
        for (int i = 0; i < nodeListLength; ++i) {
            Node aNode = nodeList.item(i);
            if (!(aNode instanceof Element) || !"filepath".equalsIgnoreCase(aNode.getNodeName())) continue;
            logResFilePath = aNode.getAttributes().item(0).getNodeValue();
            break;
        }
        if ("".equals(logResFilePath)) {
            return null;
        }
        logResFilePath = logResFilePath.replaceAll("\\\\", "/");
        StringBuffer filePath = new StringBuffer();
        filePath.append("nemgr").append(File.separator).append(logResFilePath).append('_').append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        return TEResourceUtil.getInstance(filePath.toString());
    }
}

