/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.nglct.cbb.log.TELogFactory;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import net.commustru.fstru.FStruct;

public class TEAsn1Util {
    private static final int DEFAULT_REQUEST_ASN_PRINT_TRUNCATE = 0x100000;

    private TEAsn1Util() {
    }

    public static String getAsn1String(Object asn1) {
        return asn1.getClass().getSimpleName() + '\n' + TEAsn1Util.toAsn1String(asn1);
    }

    public static String toAsn1String(Object asn) {
        MyStringBuild stringBuilder = new MyStringBuild(0x100000);
        try {
            TEAsn1Util.printAsn(asn, stringBuilder, new HashSet<Object>(), " ");
        }
        catch (IllegalArgumentException e) {
            TELogFactory.getNormalLogger().error("toAsn1String fail!", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            TELogFactory.getNormalLogger().error("toAsn1String fail!", (Throwable)e);
        }
        return stringBuilder.toString();
    }

    private static void printAsn(Object asn, MyStringBuild stringBuilder, Set<Object> printedObjects, String tag) throws IllegalArgumentException, IllegalAccessException {
        if (asn == null || asn instanceof FStruct && printedObjects.contains(asn)) {
            return;
        }
        if (!(asn instanceof FStruct)) {
            TEAsn1Util.printAsnValue(asn, stringBuilder);
            return;
        }
        printedObjects.add(asn);
        if (asn instanceof Vector) {
            TEAsn1Util.printAsnVector((Vector)asn, stringBuilder, printedObjects, tag);
            return;
        }
        stringBuilder.append('{');
        for (Field f : asn.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers())) break;
            Object value = f.get(asn);
            if (value == null) continue;
            stringBuilder.append(tag);
            stringBuilder.append(f.getName());
            stringBuilder.append(':');
            TEAsn1Util.printAsn(value, stringBuilder, printedObjects, tag + " ");
            stringBuilder.append('\n');
        }
        stringBuilder.append(tag);
        stringBuilder.append('}');
    }

    private static void printAsnValue(Object value, MyStringBuild stringBuilder) {
        if (byte[].class.isAssignableFrom(value.getClass())) {
            String ss = TEAsn1Util.globalString((byte[])value);
            stringBuilder.append(ss);
            return;
        }
        String ss = value.toString();
        stringBuilder.append(ss);
    }

    public static byte[] globalByte(String str) {
        if (str == null) {
            return new byte[0];
        }
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static String globalString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    private static void printAsnVector(Vector<?> vec, MyStringBuild stringBuilder, Set<Object> printedObjects, String tag) throws IllegalArgumentException, IllegalAccessException {
        stringBuilder.append("[");
        for (Object element : vec) {
            TEAsn1Util.printAsn(element, stringBuilder, printedObjects, tag + " ");
            stringBuilder.append("\n");
            stringBuilder.append(tag);
        }
        stringBuilder.append("]");
    }

    private static class MyStringBuild {
        private final int cap;
        private final StringBuilder stringBuilder = new StringBuilder();

        public MyStringBuild(int cap) {
            this.cap = cap;
        }

        public MyStringBuild append(char c) {
            if (this.leftCap() < 0) {
                return this;
            }
            this.stringBuilder.append(c);
            return this;
        }

        public MyStringBuild append(String ss) {
            if (this.leftCap() < 0) {
                return this;
            }
            this.stringBuilder.append(ss);
            return this;
        }

        public int leftCap() {
            return this.cap - this.stringBuilder.length();
        }

        public String toString() {
            return this.stringBuilder.toString();
        }
    }
}

