/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.nglct.cbb.log.LogWriter;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class LogRollingWriter
extends LogWriter {
    private BufferedWriter logWriter = null;
    private String backup = ".backup";
    private long fileLength = 0L;

    public LogRollingWriter() {
        String filePath = TEResourceManager.getRealPathByAppName("weblct") + this.fileName;
        this.fileLength = new File(filePath).length();
    }

    @Override
    public void write(String message) throws IOException {
        this.setFile(message);
        if (null != this.logWriter) {
            TELogFactory.getNormalLogger().info("logWriter = " + this.logWriter);
            this.logWriter.write(message);
            this.logWriter.newLine();
            this.logWriter.flush();
        }
    }

    private void setFile(String message) {
        String filePath = TEResourceManager.getRealPathByAppName("weblct") + this.fileName;
        File file = new File(filePath);
        int mLen = message.getBytes().length;
        this.fileLength += (long)mLen;
        if (null == this.logWriter) {
            this.setBufferWriter(file);
        }
        if (this.fileLength >= this.maxFileSize) {
            this.rollOver();
        }
    }

    protected void rollOver() {
        boolean isDeleteSucess;
        File file = new File(this.fileName + this.backup);
        if (file.exists() && !(isDeleteSucess = file.delete())) {
            TELogFactory.getNormalLogger().info("delete " + file.getName() + " failed!");
        }
        if ((file = new File(this.fileName)).exists()) {
            File target = new File(this.fileName + this.backup);
            this.close();
            if (file.renameTo(target)) {
                this.fileLength = 0L;
            }
        }
    }

    protected void setBufferWriter(File file) {
        FileOutputStream oStream = null;
        try {
            oStream = new FileOutputStream(file, true);
        }
        catch (FileNotFoundException ex) {
            TELogFactory.getNormalLogger().error(file.getAbsoluteFile() + "is not found", (Throwable)ex);
            try {
                if (null != file.getParent()) {
                    File parentFile = file.getParentFile();
                    if (parentFile.exists() || !parentFile.mkdirs()) {
                        throw ex;
                    }
                } else {
                    throw ex;
                }
                oStream = new FileOutputStream(file, true);
            }
            catch (IOException ioEX) {
                TELogFactory.getNormalLogger().error(file.getAbsoluteFile().toString(), (Throwable)ioEX);
            }
        }
        this.logWriter = new BufferedWriter(new OutputStreamWriter(oStream));
    }

    @Override
    public void close() {
        if (null != this.logWriter) {
            try {
                this.logWriter.close();
                this.logWriter = null;
            }
            catch (IOException ex) {
                TELogFactory.getNormalLogger().error("LogRollingWriter.close() exception!", (Throwable)ex);
            }
        }
    }
}

