/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.nglct.cbb.log.LogWriter;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogIncrementWriter
extends LogWriter {
    private Writer logWriter = null;
    private long fileLength = 0L;

    public LogIncrementWriter() {
        String filePath = TEResourceManager.getRealPathByAppName("weblct") + this.fileName;
        this.fileLength = new File(filePath).length();
    }

    @Override
    public void write(String message) throws IOException {
        this.setFile(message);
        if (null != this.logWriter) {
            this.logWriter.write(message);
            this.logWriter.write(System.getProperty("line.separator"));
            this.logWriter.flush();
        }
    }

    private void setFile(String message) {
        String filePath = TEResourceManager.getRealPathByAppName("weblct") + this.fileName;
        File file = new File(filePath);
        int mLen = message.getBytes().length;
        this.fileLength += (long)mLen;
        if (null == this.logWriter) {
            this.setBufferWriter(file);
        }
        if (this.fileLength >= this.maxFileSize) {
            this.rollOver();
        }
    }

    protected void setBufferWriter(File file) {
        FileOutputStream oStream = null;
        try {
            oStream = new FileOutputStream(file, true);
        }
        catch (FileNotFoundException ex) {
            TELogFactory.getNormalLogger().error(file.getAbsoluteFile() + "is not found", (Throwable)ex);
            try {
                if (null != file.getParent()) {
                    File parentFile = file.getParentFile();
                    if (parentFile.exists() || !parentFile.mkdirs()) {
                        throw ex;
                    }
                } else {
                    throw ex;
                }
                oStream = new FileOutputStream(file, true);
            }
            catch (IOException ioEX) {
                TELogFactory.getNormalLogger().error(file.getAbsoluteFile().toString(), (Throwable)ioEX);
            }
        }
        this.logWriter = new BufferedWriter(new OutputStreamWriter(oStream));
    }

    private void rollOver() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssS");
        String dateStr = format.format(date);
        File f = new File(this.fileName);
        String logFileName = f.getName();
        String logFileParent = f.getParent();
        String targetFileName = logFileParent + File.separator + dateStr + logFileName;
        File target = new File(targetFileName);
        this.close();
        boolean success = f.renameTo(target);
        if (success) {
            this.fileLength = 0L;
        }
    }

    @Override
    public void close() {
        if (null != this.logWriter) {
            try {
                this.logWriter.close();
                this.logWriter = null;
            }
            catch (IOException ex) {
                TELogFactory.getNormalLogger().error("LogIncrementWriter.close() fail!", (Throwable)ex);
            }
        }
    }
}

