/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class LogFileReader {
    public String[] readRollingFile(File[] files, Map paramMap) {
        if (files.length == 0) {
            return new String[0];
        }
        ArrayList<String> msgList = new ArrayList<String>();
        Arrays.sort(files);
        String startTime = (String)paramMap.get("startTime");
        String endTime = (String)paramMap.get("endTime");
        String userName = (String)paramMap.get("userName");
        String operObj = (String)paramMap.get("operobj");
        String operResult = (String)paramMap.get("operresult");
        File logFile = null;
        File logBackFile = null;
        boolean isExistBackup = false;
        for (int i = files.length - 1; i >= 0; --i) {
            if (-1 == files[i].getName().indexOf("backup")) continue;
            logBackFile = files[i];
            isExistBackup = true;
            break;
        }
        logFile = isExistBackup ? files[files.length - 2] : files[files.length - 1];
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(logFile));
        }
        catch (FileNotFoundException ex) {
            TELogFactory.getNormalLogger().error("not find nglct.log ", (Throwable)ex);
        }
        boolean isReadBackFile = true;
        while (true) {
            String message = null;
            try {
                if (in != null) {
                    message = in.readLine();
                }
            }
            catch (IOException ex) {
                TELogFactory.getNormalLogger().error("reading nglct.log throw IOException " + ex);
                try {
                    in.close();
                }
                catch (IOException ex2) {
                    TELogFactory.getNormalLogger().error("closing BufferedReader throw IOException " + ex2);
                }
            }
            if (null == message) break;
            String timeStr = this.getStrOfMsg(2, message);
            String userStr = this.getStrOfMsg(1, message);
            if (startTime.compareTo(timeStr) > 0) {
                isReadBackFile = false;
                continue;
            }
            if (startTime.compareTo(timeStr) > 0 || endTime.compareTo(timeStr) < 0 || !userName.equals(userStr) || !this.filtrateMessage(operObj, operResult, message)) continue;
            msgList.add(message);
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ex) {
            TELogFactory.getNormalLogger().error("closing BufferedReader throw IOException " + ex);
        }
        if (null != logBackFile && isReadBackFile) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(logBackFile));
            }
            catch (FileNotFoundException ex) {
                TELogFactory.getNormalLogger().error("not find nglct.log " + ex);
            }
            while (true) {
                String message = null;
                try {
                    if (reader != null) {
                        message = reader.readLine();
                    }
                }
                catch (IOException ex) {
                    TELogFactory.getNormalLogger().error("reading nglct.log throw IOException " + ex);
                    try {
                        reader.close();
                    }
                    catch (IOException ex1) {
                        TELogFactory.getNormalLogger().error("closing BufferedReader throw IOException " + ex1);
                    }
                }
                if (null == message) break;
                String timeStr = this.getStrOfMsg(2, message);
                String userStr = this.getStrOfMsg(1, message);
                if (startTime.compareTo(timeStr) > 0) {
                    isReadBackFile = false;
                    continue;
                }
                if (startTime.compareTo(timeStr) > 0 || endTime.compareTo(timeStr) < 0 || !userName.equals(userStr) || !this.filtrateMessage(operObj, operResult, message)) continue;
                msgList.add(message);
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                TELogFactory.getNormalLogger().error("closing BufferedReader throw IOException " + ex);
            }
        }
        return msgList.toArray(new String[0]);
    }

    public String[] readIncrementFile(File[] files, Map paramMap) {
        ArrayList<String> msgList = new ArrayList<String>();
        String startTime = (String)paramMap.get("startTime");
        String endTime = (String)paramMap.get("endTime");
        String userName = (String)paramMap.get("userName");
        String operObj = (String)paramMap.get("operobj");
        String operResult = (String)paramMap.get("operresult");
        Arrays.sort(files);
        int len = files.length;
        File logFile = null;
        for (int i = files.length - 1; i >= 0; --i) {
            if (-1 == files[i].getName().indexOf("backup")) continue;
            len = files.length - 1;
            break;
        }
        logFile = files[len - 1];
        boolean isReadBackFile = true;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(logFile));
        }
        catch (FileNotFoundException ex) {
            TELogFactory.getNormalLogger().error("not find nglct.log ", (Throwable)ex);
        }
        while (true) {
            String message = null;
            try {
                if (in != null) {
                    message = in.readLine();
                }
            }
            catch (IOException ex1) {
                TELogFactory.getNormalLogger().error("reading nglct.log throw IOException " + ex1);
                try {
                    in.close();
                }
                catch (IOException ex2) {
                    TELogFactory.getNormalLogger().error("closing BufferedReader throw IOException " + ex2);
                }
            }
            if (null == message) break;
            String timeStr = this.getStrOfMsg(2, message);
            String userStr = this.getStrOfMsg(1, message);
            if (startTime.compareTo(timeStr) > 0) {
                isReadBackFile = false;
                continue;
            }
            if (startTime.compareTo(timeStr) > 0 || endTime.compareTo(timeStr) < 0 || !userName.equals(userStr) || !this.filtrateMessage(operObj, operResult, message)) continue;
            msgList.add(message);
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ex3) {
            TELogFactory.getNormalLogger().error("closing BufferedReader throw IOException " + ex3);
        }
        if (len >= 2 && isReadBackFile) {
            for (int i = len - 2; i >= 0; --i) {
                if (!isReadBackFile) continue;
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(files[i]));
                }
                catch (FileNotFoundException ex4) {
                    TELogFactory.getNormalLogger().error("not find nglct.log " + ex4);
                }
                while (true) {
                    String message = null;
                    try {
                        if (reader != null) {
                            message = reader.readLine();
                        }
                    }
                    catch (IOException ex5) {
                        TELogFactory.getNormalLogger().error("reading nglct.log throw IOException " + ex5);
                        try {
                            reader.close();
                        }
                        catch (IOException ex) {
                            TELogFactory.getNormalLogger().error("closing BufferedReader throw IOException " + ex);
                        }
                    }
                    if (null == message) break;
                    String timeStr = this.getStrOfMsg(2, message);
                    String userStr = this.getStrOfMsg(1, message);
                    if (startTime.compareTo(timeStr) > 0) {
                        isReadBackFile = false;
                        continue;
                    }
                    if (startTime.compareTo(timeStr) > 0 || endTime.compareTo(timeStr) < 0 || !userName.equals(userStr) || !this.filtrateMessage(operObj, operResult, message)) continue;
                    msgList.add(message);
                }
                try {
                    if (reader == null) continue;
                    reader.close();
                    continue;
                }
                catch (IOException ex) {
                    TELogFactory.getNormalLogger().error("closing BufferedReader throw IOException " + ex);
                }
            }
        }
        return msgList.toArray(new String[0]);
    }

    private String getStrOfMsg(int col, String msg) {
        String timeStr = "";
        String[] msgs = msg.split("\t");
        if (null != msgs && col < msgs.length) {
            timeStr = msgs[col];
        }
        return timeStr;
    }

    private boolean filtrateMessage(String operObj, String operResult, String message) {
        if (!(operObj != null && operObj != "" || operResult != null && operResult != "")) {
            return true;
        }
        boolean flag1 = false;
        boolean flag2 = false;
        if (operObj == null || operObj == "") {
            flag1 = true;
        } else {
            String[] neids = operObj.split(",");
            String neidStr = this.getStrOfMsg(4, message).trim();
            for (int i = 0; i < neids.length; ++i) {
                if (neidStr.indexOf(neids[i]) == -1) continue;
                flag1 = true;
                break;
            }
        }
        if (operResult == null || operResult == "") {
            flag2 = true;
        } else {
            String resultStr = this.getStrOfMsg(7, message).trim();
            String errStr0 = TEErrorResourceUtil.getErrCodeResWithDot(0);
            String errStr1 = TEErrorResourceUtil.getErrCodeResWithDot(1);
            String errStr2 = TEErrorResourceUtil.getErrCodeResWithDot(2);
            if (operResult.equals("0") && resultStr.equals(errStr0) || operResult.equals("1") && resultStr.equals(errStr1) || operResult.equals("2") && resultStr.equals(errStr2)) {
                flag2 = true;
            }
        }
        return flag1 && flag2;
    }
}

