/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.log;

import com.huawei.nglct.cbb.log.TELogFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.GregorianCalendar;

public class LCTDebugTracer {
    private static GregorianCalendar gregorianCalendar = new GregorianCalendar();

    private static synchronized StringBuffer constructPrefix(StringBuffer buffer) {
        buffer.append('[');
        buffer.append(Thread.currentThread().getName());
        buffer.append(']');
        gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
        buffer.append(gregorianCalendar.get(2) + 1);
        buffer.append('-');
        buffer.append(gregorianCalendar.get(5));
        buffer.append('-');
        buffer.append(gregorianCalendar.get(1));
        buffer.append(' ');
        buffer.append(gregorianCalendar.get(11));
        buffer.append(':');
        buffer.append(gregorianCalendar.get(12));
        buffer.append(':');
        buffer.append(gregorianCalendar.get(13));
        return buffer;
    }

    public static void redirectOutputStream(OutputStream redirectStream) {
        PrintStream osStream = new PrintStream(redirectStream, true){

            @Override
            public void print(Object ob) {
                if (ob instanceof Throwable) {
                    StringBuffer buf = new StringBuffer(16);
                    LCTDebugTracer.constructPrefix(buf);
                    buf.append(' ');
                    super.print(buf.toString());
                }
                super.print(ob);
            }

            @Override
            public void println(Object ob) {
                if (ob instanceof Throwable) {
                    StringBuffer buf = new StringBuffer(16);
                    LCTDebugTracer.constructPrefix(buf);
                    buf.append(' ');
                    super.println(buf.toString());
                }
                super.println(ob);
            }
        };
        System.setErr(osStream);
    }

    public static void redirectSystemErrToFile(String filename) {
        File fHtmlFile = new File(filename);
        try {
            FileOutputStream fOutputStream = new FileOutputStream(fHtmlFile, true);
            LCTDebugTracer.redirectOutputStream(fOutputStream);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("RedirectSystemErrToFile to Open file[" + filename + "] failed!", (Throwable)e);
        }
    }
}

