/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.datamanage.integration.util;

import com.huawei.nglct.cbb.datamanage.integration.TEInteDataCfgMgr;
import com.huawei.nglct.cbb.datamanage.integration.model.JniDataCfgReq;
import com.huawei.nglct.cbb.datamanage.integration.model.JniDataCfgRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import org.slf4j.Logger;

public final class TEJniDataCfgUtil {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    private TEJniDataCfgUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDataCfgHandle(JniDataCfgReq request, JniDataCfgRsp response) {
        normalLogger.info("Do data cfg handle begin.");
        if (null == request) {
            normalLogger.error("The request is null!");
            return;
        }
        if (null == request.getTmpNEINfo()) {
            normalLogger.error("The request temp ne info is null!");
            return;
        }
        int neID = request.getTmpNEINfo().getNeID();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            normalLogger.error("The ne is not exist! neID->" + neID);
            return;
        }
        try {
            ne.getNeImplInterface().setNeDatacfgStatus(request.getOperType());
            TEInteDataCfgMgr.getInstance().doDataCfgHandle(request, response);
        }
        catch (Throwable e) {
            normalLogger.error("do data cfg hande fail! itemID->" + request.getItemID() + " neID->" + neID, e);
        }
        finally {
            ne.getNeImplInterface().setNeDatacfgStatus(255);
        }
        normalLogger.info("Do data cfg handle end. neID->" + neID);
    }
}

