/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.datamanage.integration.util;

import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgItemPara;
import com.huawei.nglct.cbb.datamanage.integration.util.TEDataCfgConstant;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEDataCfgUtil {
    Bundle bundle = FrameworkUtil.getBundle(this.getClass());
    private static Logger log = TELogFactory.getNormalLogger();

    public static Document parseFile(String filepath) {
        File file = new File(filepath);
        if (!file.exists()) {
            return null;
        }
        return TEDataCfgUtil.parseFile(file);
    }

    public static Document parseFile(File file) {
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builderFactory = DocumentBuilderFactory.newInstance();
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (Exception e) {
            log.error("TEDataCfgUtil.parseFile() fail!", (Throwable)e);
            return null;
        }
        return doc;
    }

    public static int parseCfgFile(Map<TEDataCfgItemPara, String> handlerMap) {
        if (null == handlerMap) {
            return -1;
        }
        if (!handlerMap.isEmpty()) {
            return 0;
        }
        String fileNamePath = TEDataCfgConstant.CFG_FILE_PATH + File.separator + "datamgr_item.xml";
        File file = TEDataCfgUtil.getFileByName(fileNamePath);
        Document doc = TEDataCfgUtil.parseFile(file);
        if (null == doc) {
            log.info("W-NEMGR data manage -> The file " + file.getAbsolutePath() + " is not exist!");
            return -1;
        }
        return TEDataCfgUtil.parseDeviceTypeFromCfgDoc(doc, handlerMap);
    }

    private static int parseDeviceTypeFromCfgDoc(Document doc, Map<TEDataCfgItemPara, String> handlerMap) {
        NodeList deviceNodeList = doc.getElementsByTagName("Device");
        if (null == deviceNodeList || 0 == deviceNodeList.getLength()) {
            log.info("W-NEMGR data manage -> the xml param of \"Device\" is not exist!");
            return 0;
        }
        int len = deviceNodeList.getLength();
        for (int index = 0; index < len; ++index) {
            Element deviceElement;
            String deviceTypeStr;
            Node deviceNode = deviceNodeList.item(index);
            if (1 != deviceNode.getNodeType() || null == (deviceTypeStr = (deviceElement = (Element)deviceNode).getAttribute("type")) || "".equals(deviceTypeStr)) continue;
            TEDataCfgUtil.parseOperTypeFromElement(deviceElement, deviceTypeStr, handlerMap);
        }
        return 0;
    }

    public static int parseOperTypeFromElement(Element deviceElement, String deviceTypeStr, Map<TEDataCfgItemPara, String> handlerMap) {
        NodeList operTypeNodeList = deviceElement.getChildNodes();
        if (null == operTypeNodeList || 0 == operTypeNodeList.getLength()) {
            log.info("W-NEMGR data manage -> the xml param of \"Operation\" is not exist!");
            return 0;
        }
        int len = operTypeNodeList.getLength();
        for (int index = 0; index < len; ++index) {
            Element operTypeElement;
            String operTypeStr;
            Node operTypeNode = operTypeNodeList.item(index);
            if (1 != operTypeNode.getNodeType() || null == (operTypeStr = (operTypeElement = (Element)operTypeNode).getAttribute("type")) || "".equals(operTypeStr)) continue;
            TEDataCfgUtil.parseItemInfoFormElement(operTypeElement, deviceTypeStr, handlerMap, operTypeStr);
        }
        return 0;
    }

    private static int parseItemInfoFormElement(Element operTypeElement, String deviceTypeStr, Map<TEDataCfgItemPara, String> handlerMap, String operTypeStr) {
        NodeList itemNodeList = operTypeElement.getChildNodes();
        if (null == itemNodeList || 0 == itemNodeList.getLength()) {
            log.info("W-NEMGR data manage -> the xml param of \"Item\" is not exist!");
            return 0;
        }
        int len = itemNodeList.getLength();
        for (int index = 0; index < len; ++index) {
            Node itemNode = itemNodeList.item(index);
            if (1 != itemNode.getNodeType()) continue;
            Element itemElement = (Element)itemNode;
            String itemIDStr = itemElement.getAttribute("itemid");
            String handlerImplStr = itemElement.getAttribute("impl");
            if (null == itemIDStr || "".equals(itemIDStr) || null == handlerImplStr || "".equals(handlerImplStr)) continue;
            String[] deviceTypes = deviceTypeStr.split(",");
            int leni = deviceTypes.length;
            for (int i = 0; i < leni; ++i) {
                TEDataCfgItemPara itemInfo = TEDataCfgUtil.getItemInfo(itemIDStr, deviceTypes[i], operTypeStr);
                if (null == itemInfo) continue;
                handlerMap.put(itemInfo, handlerImplStr);
            }
        }
        return 0;
    }

    private static TEDataCfgItemPara getItemInfo(String itemIDStr, String deviceTypeStr, String operTypeStr) {
        int itemID = Integer.valueOf(itemIDStr);
        int operType = TEDataCfgUtil.parseOperType(operTypeStr);
        if (255 == operType) {
            return null;
        }
        return new TEDataCfgItemPara(operType, itemID, deviceTypeStr);
    }

    private static int parseOperType(String typeStr) {
        if ("upload".equals(typeStr)) {
            return 3;
        }
        if ("copy".equals(typeStr)) {
            return 7;
        }
        if ("consistverify".equals(typeStr)) {
            return 6;
        }
        if ("upgrade".equals(typeStr)) {
            return 9;
        }
        if ("datasync".equals(typeStr)) {
            return 10;
        }
        if ("download".equals(typeStr)) {
            return 4;
        }
        if ("planningData".equals(typeStr)) {
            return 12;
        }
        log.info("W-NEMGR data manage -> do not have the operation handler : " + typeStr);
        return 255;
    }

    private static File getFileByName(String fileNamePath) {
        return TEResourceManager.getFileByName(fileNamePath);
    }
}

