/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.datamanage.integration.util;

import com.huawei.nglct.cbb.datamanage.integration.handler.TECIConsistVerifyHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECICopyHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECIDownLoadHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECIPlanningDataHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECISyncHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECIUpLoadHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECfgItem;
import com.huawei.nglct.cbb.datamanage.integration.model.JniDataCfgNEInfo;
import com.huawei.nglct.cbb.datamanage.integration.model.JniDataCfgReq;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgCopyPara;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgDownloadPara;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgItemPara;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgParaInf;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgSyncPara;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgUploadPara;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TERefreshNEInfo;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import org.slf4j.Logger;

public class TEDataCfgConverterUtil {
    private static final Logger log = TELogFactory.getNormalLogger();

    public static TEDataCfgItemPara convertReqToItemInfo(JniDataCfgReq request) {
        if (null == request) {
            return null;
        }
        JniDataCfgNEInfo neInfo = request.getTmpNEINfo();
        if (null == neInfo) {
            return null;
        }
        int devType = neInfo.getNeType();
        int neType = TEGetNEDomainVersion.getInstance().getNeType(devType);
        String neTypeName = TEGetNEDomainVersion.getInstance().getNETypeName(neType);
        return new TEDataCfgItemPara(request.getOperType(), request.getItemID(), neTypeName, request.getExtendMDS());
    }

    public static TEDataCfgParaInf convertReqToPara(JniDataCfgReq request) {
        if (null == request) {
            return null;
        }
        TEDataCfgItemPara itemInfo = TEDataCfgConverterUtil.convertReqToItemInfo(request);
        if (null == itemInfo) {
            return null;
        }
        return TEDataCfgConverterUtil.convertReqItemToPara(request, itemInfo);
    }

    private static TEDataCfgParaInf convertReqItemToPara(JniDataCfgReq request, TEDataCfgItemPara itemInfo) {
        int operType = itemInfo.getOperType();
        switch (operType) {
            case 3: 
            case 6: {
                return new TEDataCfgUploadPara(itemInfo, request);
            }
            case 7: {
                return new TEDataCfgCopyPara(itemInfo, request);
            }
            case 4: {
                return new TEDataCfgDownloadPara(itemInfo, request);
            }
            case 9: {
                break;
            }
            case 10: {
                return new TEDataCfgSyncPara(itemInfo, request);
            }
            case 255: {
                break;
            }
            case 12: {
                return new TEDataCfgDownloadPara(itemInfo, request);
            }
        }
        return null;
    }

    public static int doHandler(String handlerStr, TEDataCfgParaInf dataCfgPara) {
        TECfgItem handler = TEDataCfgConverterUtil.getCfgHandler(handlerStr);
        if (null == handler) {
            log.info("the handler is null!");
            return 0;
        }
        int operType = dataCfgPara.getOperType();
        int ret = 0;
        switch (operType) {
            case 3: {
                TECIUpLoadHandler newHandler = (TECIUpLoadHandler)handler;
                TEDataCfgUploadPara uploadPara = (TEDataCfgUploadPara)dataCfgPara;
                TEDataCfgConverterUtil.refreshNEInfo(uploadPara);
                ret = newHandler.upLoad(uploadPara);
                break;
            }
            case 6: {
                TECIConsistVerifyHandler verifyHandler = (TECIConsistVerifyHandler)handler;
                TEDataCfgUploadPara verifyPara = (TEDataCfgUploadPara)dataCfgPara;
                ret = verifyHandler.consistVerify(verifyPara);
                break;
            }
            case 7: {
                TECICopyHandler copyHandler = (TECICopyHandler)handler;
                TEDataCfgCopyPara copyPara = (TEDataCfgCopyPara)dataCfgPara;
                ret = copyHandler.copy(copyPara);
                break;
            }
            case 4: {
                TECIDownLoadHandler downloadHandler = (TECIDownLoadHandler)handler;
                TEDataCfgDownloadPara downloadPara = (TEDataCfgDownloadPara)dataCfgPara;
                ret = downloadHandler.download(downloadPara);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                TECISyncHandler syncHandler = (TECISyncHandler)handler;
                TEDataCfgSyncPara syncPara = (TEDataCfgSyncPara)dataCfgPara;
                ret = syncHandler.sync(syncPara);
                break;
            }
            case 255: {
                break;
            }
            case 12: {
                TECIPlanningDataHandler planningDataHandler = (TECIPlanningDataHandler)handler;
                TEDataCfgDownloadPara planningDataPara = (TEDataCfgDownloadPara)dataCfgPara;
                TELogFactory.getNormalLogger().info("planning data!");
                ret = planningDataHandler.setToNE(planningDataPara);
                break;
            }
        }
        return ret;
    }

    private static void refreshNEInfo(TEDataCfgUploadPara uploadPara) {
        try {
            int neID = uploadPara.getTmpNEInfo().getNeID();
            TERefreshNEInfo.refreshNEInfo(neID);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("refresh ne before upload error!", (Throwable)e);
        }
    }

    private static TECfgItem getCfgHandler(String handlerImplStr) {
        if (null == handlerImplStr || "".equals(handlerImplStr)) {
            return null;
        }
        try {
            return (TECfgItem)Class.forName(handlerImplStr).newInstance();
        }
        catch (Throwable e) {
            TELogFactory.getNormalLogger().error("TEDataCfgConverterUtil getCfgHandler() fail!", e);
            return null;
        }
    }
}

