/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.datamanage.integration;

import com.huawei.nglct.cbb.datamanage.integration.model.JniDataCfgReq;
import com.huawei.nglct.cbb.datamanage.integration.model.JniDataCfgRsp;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgItemPara;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgParaInf;
import com.huawei.nglct.cbb.datamanage.integration.util.TEDataCfgConverterUtil;
import com.huawei.nglct.cbb.datamanage.integration.util.TEDataCfgUtil;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.pnp.TESDMgrInterface;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class TEInteDataCfgMgr
implements TESDMgrInterface {
    private static TEInteDataCfgMgr instance = null;
    private Map<TEDataCfgItemPara, String> handlerMap = new HashMap<TEDataCfgItemPara, String>();
    private Logger log = TELogFactory.getNormalLogger();

    private TEInteDataCfgMgr() {
        this.installHandler();
    }

    public static synchronized TEInteDataCfgMgr getInstance() {
        if (null == instance) {
            instance = new TEInteDataCfgMgr();
        }
        return instance;
    }

    public Map<TEDataCfgItemPara, String> getHandlerMap() {
        return this.handlerMap;
    }

    public void setHandlerMap(Map<TEDataCfgItemPara, String> handlerMap) {
        this.handlerMap = handlerMap;
    }

    public void addHandlerMap(Map<TEDataCfgItemPara, String> handlerMap) {
        if (this.handlerMap == null) {
            this.handlerMap = new HashMap<TEDataCfgItemPara, String>();
        }
        this.handlerMap.putAll(handlerMap);
    }

    private synchronized int installHandler() {
        if (null == this.handlerMap) {
            this.handlerMap = new HashMap<TEDataCfgItemPara, String>();
        }
        return TEDataCfgUtil.parseCfgFile(this.handlerMap);
    }

    public int doDataCfgHandle(JniDataCfgReq request, JniDataCfgRsp response) {
        int ret = 0;
        response.setResult(ret);
        if (null == request) {
            this.log.info("The Jni request object is null!");
            return 0;
        }
        String handlerStr = this.getHandlerFromReq(request);
        if (null == handlerStr) {
            this.log.info("The TECfgItem is not registe in W-NEMgr!!");
            return 0;
        }
        TEDataCfgParaInf dataCfgPara = TEDataCfgConverterUtil.convertReqToPara(request);
        if (null == dataCfgPara) {
            this.log.info("The TEDataCfgParaInf is not null!");
            return 0;
        }
        ret = TEDataCfgConverterUtil.doHandler(handlerStr, dataCfgPara);
        this.log.info("The doHandler result is " + ret);
        response.setResult(ret);
        return ret;
    }

    private String getHandlerFromReq(JniDataCfgReq request) {
        TEDataCfgItemPara itemInfo = TEDataCfgConverterUtil.convertReqToItemInfo(request);
        if (null == itemInfo) {
            this.log.info("The itemInfo object is null!");
            return null;
        }
        return this.getHandler(itemInfo);
    }

    private synchronized String getHandler(TEDataCfgItemPara itemInfo) {
        if (null == this.handlerMap) {
            this.handlerMap = new HashMap<TEDataCfgItemPara, String>();
            return null;
        }
        return this.handlerMap.get(itemInfo);
    }

    @Override
    public void clear() {
        this.handlerMap.clear();
        TEDataCfgUtil.parseCfgFile(this.handlerMap);
    }
}

