/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.datamanage.datasync;

import com.huawei.nglct.cbb.datamanage.datasync.base.DBCHGEvent;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class TEDBCHGEventFile {
    String m_fileName;
    Map<Integer, List<Integer>> seqQxparaMap = new HashMap<Integer, List<Integer>>();

    public TEDBCHGEventFile(int neID) {
        this.makeFileName(neID);
    }

    public boolean write(List<DBCHGEvent> eventPtrVec) {
        Document doc = TEParseXMLFile.parseFile(this.m_fileName);
        Element root = doc.createElement("root");
        Element elem = null;
        int m = eventPtrVec.size();
        for (int i = 0; i < m; ++i) {
            elem = doc.createElement("item");
            elem.setAttribute("seq", String.valueOf(eventPtrVec.get(i).getDBCHGSEQ()));
            elem.setAttribute("content", new String(eventPtrVec.get(i).getContents()));
            root.appendChild(elem);
        }
        return this.writeXmlFile(doc, this.m_fileName);
    }

    public boolean read(List<DBCHGEvent> eventPtrVec) {
        HashMap<Integer, byte[]> seqQxparaMap = new HashMap<Integer, byte[]>();
        Document document = TEParseXMLFile.parseFile(this.m_fileName);
        this.readItem(document.getElementsByTagName("item"), seqQxparaMap);
        int m = eventPtrVec.size();
        for (int i = 0; i < m; ++i) {
            DBCHGEvent event = eventPtrVec.get(i);
            if (null == event) continue;
            if (!seqQxparaMap.containsKey(event.getDBCHGSEQ())) {
                return false;
            }
            event.setContents((byte[])seqQxparaMap.get(event.getDBCHGSEQ()));
        }
        return true;
    }

    public boolean clear() {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.m_fileName)));
            writer.write("");
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEDBCHGEventFile clear() fail!", (Throwable)e);
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                TELogFactory.getNormalLogger().error("TEDBCHGEventFile clear() fail!", (Throwable)e1);
            }
            return false;
        }
    }

    private boolean writeXmlFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            if (!file.canWrite()) {
                file.delete();
            }
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            return true;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEDBCHGEventFile writeXmlFile() fail!", (Throwable)e);
            return false;
        }
    }

    private void readItem(NodeList nodeList, Map<Integer, byte[]> seqQxparaMap) {
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            NamedNodeMap atttr = nodeList.item(i).getAttributes();
            int seq = Integer.parseInt(atttr.getNamedItem("seq").getNodeValue());
            String strContent = atttr.getNamedItem("content").getNodeValue();
            if (0 == seq) continue;
            seqQxparaMap.put(seq, strContent.getBytes());
        }
    }

    private void makeFileName(int neID) {
        this.m_fileName = "";
        this.m_fileName = this.m_fileName + "/nedatasync";
        File file = new File(this.m_fileName);
        if (!file.exists()) {
            file.mkdir();
        }
        this.m_fileName = this.m_fileName + "/ne-";
        String cStr = (neID >> 16) + "-" + (neID & 0xFFFF);
        this.m_fileName = this.m_fileName + cStr;
        this.m_fileName = this.m_fileName + "-failedevents.dat";
    }
}

