/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.cbb.alarm;

import com.huawei.nglct.cbb.alarm.AlarmFilterKey;
import com.huawei.nglct.cbb.alarm.xml.TESDAlarmFilterInterpreter;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class TEAlmFilterMgr {
    private static TEAlmFilterMgr instance;
    private Map<AlarmFilterKey, List<Integer>> alarmFilter;

    private TEAlmFilterMgr() {
    }

    private void initialize() {
        this.alarmFilter = new Hashtable<AlarmFilterKey, List<Integer>>();
        TESDAlarmFilterInterpreter pAlarmInterpreter = new TESDAlarmFilterInterpreter();
        String fileName = TEResourceManager.getPath() + File.separator + "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "alarm" + File.separator + "alarm_filter.xml";
        Document doc = TEParseXMLFile.parseFile(fileName);
        if (null != doc) {
            pAlarmInterpreter.interpretXMLTag(doc);
        }
    }

    public static synchronized TEAlmFilterMgr getInstance() {
        if (null == instance) {
            instance = new TEAlmFilterMgr();
        }
        if (null == TEAlmFilterMgr.instance.alarmFilter) {
            instance.initialize();
        }
        return instance;
    }

    public void addAlarmFilter(String functionDes, List<Integer> alarmIDs) {
        AlarmFilterKey key = new AlarmFilterKey();
        key.operaType = functionDes;
        this.alarmFilter.put(key, alarmIDs);
    }

    public boolean isContainAlarm(String functionDes, int alarmID) {
        List<Integer> alarms;
        AlarmFilterKey key = new AlarmFilterKey();
        key.operaType = functionDes;
        return this.alarmFilter.containsKey(key) && null != (alarms = this.alarmFilter.get(key)) && alarms.contains(alarmID);
    }

    public static void main(String[] args) {
        for (AlarmFilterKey key : TEAlmFilterMgr.getInstance().alarmFilter.keySet()) {
            System.out.println(key.toString());
            System.out.println(TEAlmFilterMgr.getInstance().alarmFilter.get(key).toString());
        }
    }
}

