/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.bundleactivator;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.t2kinterface.TEInterfaceProcess;
import com.huawei.nglct.cbb.pnp.TENEPNPTask;
import com.huawei.nglct.db.TEDaoHolder;
import com.huawei.nglct.jni.asncommu.TEAsnMsgDispatcher;
import com.huawei.nglct.nelist.TENEListInit;
import com.huawei.nglct.po.security.TELctUser;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.TETL1CmdCallBackHandle;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.IFileRegisterer;
import com.huawei.nglct.util.string.TEFileRegisterer;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.hibernate.Dao;
import com.huawei.uflight.security.sysusermgr.api.SysUserInfo;
import com.huawei.uflight.tl1.ICallBackHandle;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.util.SecurityUtil;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;

public class CommonBundleActivator
implements BundleActivator,
IFileRegisterer {
    private Logger logger = TELogFactory.getNormalLogger();
    private TIntArrayList fbMapping = new TIntArrayList();
    private ServiceRegistration sr;

    public void start(BundleContext context) throws Exception {
        try {
            this.fbMapping = TEFileRegisterer.registerFiles(context.getBundle());
            this.sr = context.registerService(IFileRegisterer.class.getName(), (Object)this, null);
            TETL1NECommMgr.getInstance().registerCallHandle((ICallBackHandle)TETL1CmdCallBackHandle.getInstance());
            this.logger.info("Start TENEListInit...");
            TENEListInit.getInstance().init();
            this.logger.info("Finish TENEListInit.");
            if (TESysManagerBean.getInstance().isIntegratedStatus()) {
                this.logger.info("Start init TEInterfaceProcess...");
                TEInterfaceProcess.iniTEDataBaseParam();
                this.logger.info("Finish init TEInterfaceProcess.");
                TEAsnMsgDispatcher.getInstance().registerTask(TENEPNPTask.class);
            } else {
                this.initDB();
            }
        }
        catch (Exception e) {
            this.logger.error("CommonBundleActivator.start() fail!", (Throwable)e);
            TELogFactory.getNormalLogger().info("exception occured during commonbundle initializing.");
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
        this.logger.info("commonbundle start!");
    }

    public void stop(BundleContext context) throws Exception {
        this.sr.unregister();
        this.logger.info("commonbundle stop!");
    }

    @Override
    public boolean containsResFile(String filePaht) {
        int hash = TEStringUtils.hashString(filePaht);
        return this.fbMapping.contains(hash);
    }

    private void initDB() {
        Properties dbProp = this.loadDBConfFile();
        this.changeDbPw(dbProp);
        this.importSysUser(dbProp);
    }

    private Properties newPropObj(Properties dbProp, String key) {
        Properties newProp = new Properties();
        newProp.put("hibernate.connection.username", dbProp.getProperty("userName"));
        newProp.put("hibernate.connection.password", EncryptUtils.decryptAES(dbProp.getProperty(key)));
        return newProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadDBConfFile() {
        Properties res = new Properties();
        InputStream inputStr = null;
        try {
            inputStr = new FileInputStream(TEResourceManager.getFileByName("conf" + File.separator + "db" + File.separator + "dbconfig.properties"));
            res.load(inputStr);
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("initial db config file Fail!", (Throwable)ex);
        }
        finally {
            try {
                if (null != inputStr) {
                    inputStr.close();
                }
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("Close db config file stream failed!", (Throwable)e);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeDbPw(Properties prop) {
        Properties newProp = this.newPropObj(prop, "priPassword");
        Dao dao = TEDaoHolder.getInstance().getDao(newProp, prop.getProperty("dbName"));
        Session session = dao.getService().get();
        try {
            SQLQuery query = session.createSQLQuery("ALTER USER sa SET PASSWORD \"" + EncryptUtils.decryptAES(prop.getProperty("secPassword")) + "\"");
            query.executeUpdate();
        }
        catch (Exception e) {
            this.logger.info("modify db password failed!password may have been changed", (Throwable)e);
        }
        finally {
            dao.getService().free();
            TEDaoHolder.getInstance().closeDao();
        }
    }

    private void importSysUser(Properties prop) {
        Properties newProp = this.newPropObj(prop, "secPassword");
        Dao dao = TEDaoHolder.getInstance().getDao(newProp, prop.getProperty("dbName"));
        List users = dao.getListByHql("from TELctUser", null);
        TELctUser user = new TELctUser();
        SysUserInfo curUser = TESysManagerBean.getInstance().getSysUserInfo(TESysManagerBean.getInstance().getSysUser());
        if (null != curUser) {
            user.setUserName(curUser.getUserName());
            char[] charPwd = SecurityUtil.decryptStrTochar((String)curUser.getPassword());
            byte[] bytePwd = EncryptUtils.decodePlainText(charPwd);
            bytePwd = IOStreamConvertor.removeByteZero(bytePwd);
            user.setPassword(EncryptUtils.encryptAESByte2Str(bytePwd));
            EncryptUtils.clearByte(bytePwd);
            EncryptUtils.clearChar(charPwd);
            user.setTime(new Date());
            if (!users.contains(user)) {
                dao.save((Object)user);
                user = null;
                curUser = null;
                this.logger.info("importing System user finish.");
            }
        }
    }
}

