/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.bscfg.installcp;

import com.huawei.nglct.bscfg.equipment.TEConfigUtil;
import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.mo.TECPMenuRecord;
import com.huawei.nglct.mo.TENETypeCpMenu;
import com.huawei.nglct.mo.TENETypeVerCpMenu;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEConvertUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TECPUtil {
    public static final int OTUTYPESINGLEMODE = 1;
    public static final int PORTNO2 = 2;
    public static final int LS_OPEN = 1;
    public static final int NO_LOOP = 0;
    public static final int CFGDATA_BOARD_MODESWITCH_DOMAIN = 180;
    public static final int CFGDATA_WDM_DISABLE_PORT_BYCPMODE = 807;

    public static String getCPTypeName(int type) {
        return TECircuitPackDescription.getInstance().getTypeName(type);
    }

    public static int[] getBoardType(int neID, int slotID) {
        int[] ret = new int[2];
        ret[0] = 0;
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        if (null == board) {
            ret[0] = 1090646021;
        } else {
            ret[1] = board.getBoardType();
        }
        return ret;
    }

    public static int[] slotIDQx2E(int neID, int qx) {
        int[] ret = new int[2];
        ret[0] = 0;
        int ems = qx;
        int[] result = TEConfigUtil.getNEPara(neID);
        ret[0] = result[0];
        if (0 == ret[0]) {
            ems = TEEquipmentDescription.getInstance().slotIDQx2E(result[1], result[2], qx);
        }
        ret[1] = ems;
        return ret;
    }

    public static int slotIDQx2E(int neType, int eShelfType, int qx) {
        return TEEquipmentDescription.getInstance().slotIDQx2E(neType, eShelfType, qx);
    }

    public static int[] slotIDE2Qx(int neID, int ems) {
        int[] cpType;
        int[] ret = new int[2];
        int retCode = 0;
        int qx = ems;
        int[] result = TEConfigUtil.getNEPara(neID);
        retCode = result[0];
        if (0 == retCode && 0 == (retCode = (cpType = TECPUtil.getBoardType(neID, ems))[0])) {
            qx = TEEquipmentDescription.getInstance().slotIDE2Qx(result[1], result[2], ems, cpType[1]);
        }
        ret[0] = retCode;
        ret[1] = qx;
        return ret;
    }

    public static int getCpMenuList(int neID, int neType, int cpType, TIntArrayList cpMenuList) {
        TECPMenuRecord tempCpMenuRec = TECircuitPackDescription.getInstance().getCPMenuRecordList(cpType);
        if (tempCpMenuRec == null) {
            return 2;
        }
        int nmNEType = TEGetNEDomainVersion.getInstance().getDevType(neType);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (!tempCpMenuRec.m_NeTVCpMenuList.isEmpty() && null != ne) {
            int neVer = TEConvertUtil.convertVerStrToInt(ne.getHostVersion());
            TENETypeVerCpMenu typeVerCpMenu = null;
            int m = tempCpMenuRec.m_NeTVCpMenuList.size();
            for (int i = 0; i < m; ++i) {
                typeVerCpMenu = tempCpMenuRec.m_NeTVCpMenuList.get(i);
                if (nmNEType != typeVerCpMenu.m_NEType || !typeVerCpMenu.m_NeVerRange.isWithInRange(neVer)) continue;
                cpMenuList.add(typeVerCpMenu.m_CpMenuList.toNativeArray());
                return 0;
            }
        }
        if (!tempCpMenuRec.m_NeTypeMenuList.isEmpty()) {
            TENETypeCpMenu typeCpMenu = null;
            int n = tempCpMenuRec.m_NeTypeMenuList.size();
            for (int j = 0; j < n; ++j) {
                typeCpMenu = tempCpMenuRec.m_NeTypeMenuList.get(j);
                if (nmNEType != typeCpMenu.m_NeType) continue;
                cpMenuList.add(typeCpMenu.m_CpMenuList.toNativeArray());
                return 0;
            }
        }
        if (ne.getIsTL1OrQX() == 1 && tempCpMenuRec.m_tl1CPMenuList.size() != 0) {
            cpMenuList.add(tempCpMenuRec.m_tl1CPMenuList.toNativeArray());
        } else {
            cpMenuList.add(tempCpMenuRec.m_CPMenuList.toNativeArray());
        }
        return 0;
    }

    public static List getAttrSupportCPs(int neid, String attrId) {
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        ArrayList<TEBoard> supportCPs = new ArrayList<TEBoard>();
        if (null == neObj) {
            return null;
        }
        Vector boardList = neObj.getBoardList();
        if (null == boardList) {
            return null;
        }
        TEBoard board = null;
        Collections.sort(boardList);
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            board = (TEBoard)boardList.get(i);
            if (null == TEGenCfgDataMgr.getGenCfgMode(board.getBoardType()) || null == TEGenCfgDataMgr.getGenCfgMode(board.getBoardType()).getAttrFromId(attrId)) continue;
            supportCPs.add(board);
        }
        return supportCPs;
    }
}

