/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.bscfg.equipment;

import com.huawei.nglct.bscfg.equipment.TEConfigUtil;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.nemgr.f_interface.emf.common.GetLicenseItemReqEx;
import com.huawei.nglct.nemgr.f_interface.emf.common.GetLicenseItemReqExSeqOf;
import com.huawei.nglct.nemgr.f_interface.emf.common.GetLicenseItemRspEx;
import com.huawei.nglct.nemgr.f_interface.emf.common.LicenseItemInfoEx;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TELicenseMgr {
    private static TELicenseMgr m_instance = null;
    private Map<Integer, String> m_MapTypeStr = new HashMap<Integer, String>();
    private Map<String, Integer> m_licenseItemMap = new HashMap<String, Integer>();

    private TELicenseMgr() {
        this.loadDevLicenseName();
    }

    public static synchronized TELicenseMgr getInstance() {
        if (null == m_instance) {
            m_instance = new TELicenseMgr();
        }
        return m_instance;
    }

    public int[] getEquitmentMaxAllowNum(int neType) {
        int[] ret = new int[2];
        int errCode = 0;
        int maxNum = 0;
        String neTypeName = "";
        if (this.m_MapTypeStr.containsKey(neType)) {
            neTypeName = this.m_MapTypeStr.get(neType);
        }
        if (neTypeName == "") {
            ret[0] = 1090592794;
            return ret;
        }
        if (neType == 2005 || neType == 2007) {
            neTypeName = "METRO6100";
        }
        if (neType == 2010 || neType == 2011 || neType == 2012) {
            neTypeName = "BWS320G";
        }
        if (neType == 2003 || neType == 2006) {
            neTypeName = "METRO6040";
        }
        if (neType == 1932 || neType == 1933) {
            neTypeName = "METRO1000";
        }
        GetLicenseItemReqEx ssReq = new GetLicenseItemReqEx();
        GetLicenseItemRspEx ssRsp = new GetLicenseItemRspEx();
        LicenseItemInfoEx itemInfo = new LicenseItemInfoEx();
        itemInfo.feature = "T2000".getBytes();
        itemInfo.item = neTypeName.getBytes();
        GetLicenseItemReqExSeqOf ssReqOf = new GetLicenseItemReqExSeqOf();
        ssReqOf.add((Object)itemInfo);
        ssReq.licenseItemList = ssReqOf;
        errCode = TEASN1CommMgr.sendCommand(TEASN1CommMgr.SECU_PROCID, (FStruct)ssReq, (FStruct)ssRsp, 1108);
        if (0 != errCode) {
            ret[0] = errCode;
            return ret;
        }
        if (null == ssRsp.licenseItemList) {
            ret[0] = 1090592794;
            return ret;
        }
        LicenseItemInfoEx pInfo = (LicenseItemInfoEx)ssRsp.licenseItemList.get(0);
        if (pInfo != null && pInfo.maxValue != null) {
            ret[1] = maxNum = Integer.parseInt(new String(pInfo.maxValue));
            ret[0] = 0;
            return ret;
        }
        ret[0] = 1090592794;
        return ret;
    }

    public String getEquipmentStr(int neType) {
        String neTypeName = "";
        if (this.m_MapTypeStr.containsKey(neType)) {
            neTypeName = this.m_MapTypeStr.get(neType);
        }
        return neTypeName;
    }

    public int isOverMaxNENum(int neType, int curNeNum) {
        if (TEConfigUtil.isVNE(neType)) {
            return 0;
        }
        int[] ret = this.getEquitmentMaxAllowNum(neType);
        int errCode = ret[0];
        if (0 == errCode) {
            int maxNum = ret[1];
            if (curNeNum <= maxNum) {
                return 0;
            }
            return 1090605079;
        }
        return errCode;
    }

    public int getLicenseItem(String licenseName) {
        if (this.m_licenseItemMap.isEmpty()) {
            this.getLicenseItemFromSecurity();
        }
        if (this.m_licenseItemMap.containsKey(licenseName)) {
            return this.m_licenseItemMap.get(licenseName);
        }
        return 0;
    }

    public void addLicenseItem(String licenseName, int value) {
        this.m_licenseItemMap.put(licenseName, value);
    }

    public int getLicenseItemFromSecurity() {
        GetLicenseItemReqEx ssReq = new GetLicenseItemReqEx();
        GetLicenseItemRspEx ssRsp = new GetLicenseItemRspEx();
        int ret = TEASN1CommMgr.sendCommand(TEASN1CommMgr.SECU_PROCID, (FStruct)ssReq, (FStruct)ssRsp, 1108);
        if (0 == ret) {
            ret = ssRsp.iResult;
        }
        if (0 != ret || null == ssRsp.licenseItemList) {
            return ret;
        }
        LicenseItemInfoEx pInfo = null;
        int m = ssRsp.licenseItemList.size();
        for (int i = 0; i < m; ++i) {
            pInfo = (LicenseItemInfoEx)ssRsp.licenseItemList.get(i);
            if (null == pInfo.item) continue;
            String strTmp = new String(pInfo.item);
            int value = Integer.parseInt(new String(pInfo.maxValue));
            if (-1 == strTmp.indexOf("Support")) continue;
            this.addLicenseItem(strTmp, value);
        }
        return ret;
    }

    private void loadDevLicenseName() {
        String filepath = TEResourceManager.getPath() + File.separator + "nemgr" + File.separator + "device" + File.separator + "ne_domain_version.xml";
        File file = new File(filepath);
        if (file.exists()) {
            Document doc = TEParseXMLFile.parseFile(filepath);
            NodeList nodeList = doc.getElementsByTagName("ne");
            Node node = null;
            NamedNodeMap nodeMap = null;
            int m = nodeList.getLength();
            for (int i = 0; i < m; ++i) {
                node = nodeList.item(i);
                nodeMap = node.getAttributes();
                Integer devType = Integer.valueOf(nodeMap.getNamedItem("devtype").getNodeValue());
                String licenseName = nodeMap.getNamedItem("licensename").getNodeValue();
                if (this.m_MapTypeStr.containsKey(devType)) continue;
                this.m_MapTypeStr.put(devType, licenseName);
            }
        }
    }
}

